/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util.stereo;

import com.jogamp.opengl.math.FloatUtil;
import com.jogamp.opengl.math.Quaternion;
import com.jogamp.opengl.math.VectorUtil;
import com.jogamp.opengl.util.stereo.EyeParameter;
import com.jogamp.opengl.util.stereo.EyePose;
import com.jogamp.opengl.util.stereo.StereoDeviceRenderer;

public class StereoUtil {
    public static float getVertPupilCenterFromTop(float f, float f2) {
        return f2 / f;
    }

    public static float[] getHorizPupilCenterFromLeft(float f, float f2) {
        float f3 = 0.5f * f;
        float f4 = (f - f2) * 0.5f;
        float f5 = f4 + f2 - f3;
        return new float[]{f4 / f3, f5 / f3};
    }

    public static boolean usesBarrelDistortion(int n) {
        return 0 != (n & 1);
    }

    public static boolean usesTimewarpDistortion(int n) {
        return 0 != (n & 8);
    }

    public static boolean usesChromaticDistortion(int n) {
        return 0 != (n & 2);
    }

    public static boolean usesVignetteDistortion(int n) {
        return 0 != (n & 4);
    }

    public static String distortionBitsToString(int n) {
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        if (StereoUtil.usesBarrelDistortion(n)) {
            if (bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("barrel");
            bl = true;
        }
        if (StereoUtil.usesVignetteDistortion(n)) {
            if (bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("vignette");
            bl = true;
        }
        if (StereoUtil.usesChromaticDistortion(n)) {
            if (bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("chroma");
            bl = true;
        }
        if (StereoUtil.usesTimewarpDistortion(n)) {
            if (bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("timewarp");
            bl = true;
        }
        return stringBuilder.toString();
    }

    public static void getSBSUpstreamPMV(StereoDeviceRenderer.Eye eye, float f, float f2, float[] fArray, float[] fArray2) {
        float[] fArray3 = new float[16];
        float[] fArray4 = new float[16];
        float[] fArray5 = new float[3];
        float[] fArray6 = new float[3];
        float[] fArray7 = new float[3];
        EyeParameter eyeParameter = eye.getEyeParameter();
        EyePose eyePose = eye.getLastEyePose();
        FloatUtil.makePerspective(fArray, 0, true, eyeParameter.fovhv, f, f2);
        Quaternion quaternion = new Quaternion();
        float[] fArray8 = quaternion.rotateVector(fArray5, 0, eyePose.position, 0);
        VectorUtil.addVec3(fArray8, fArray8, eyeParameter.positionOffset);
        quaternion.mult(eyePose.orientation);
        float[] fArray9 = quaternion.rotateVector(fArray6, 0, VectorUtil.VEC3_UNIT_Y, 0);
        float[] fArray10 = quaternion.rotateVector(fArray7, 0, VectorUtil.VEC3_UNIT_Z_NEG, 0);
        float[] fArray11 = VectorUtil.addVec3(fArray10, fArray8, fArray10);
        float[] fArray12 = FloatUtil.makeLookAt(fArray4, 0, fArray8, 0, fArray11, 0, fArray9, 0, fArray3);
        float[] fArray13 = FloatUtil.makeTranslation(fArray2, true, eyeParameter.distNoseToPupilX, eyeParameter.distMiddleToPupilY, eyeParameter.eyeReliefZ);
        FloatUtil.multMatrix(fArray13, fArray12);
    }
}

