/*
 * Decompiled with CFR 0.152.
 */
package rtree;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.RandomAccessFile;

class RTreeRead {
    static int nleaf;
    static int leaf;
    static int minX;
    static int minY;
    static int maxX;
    static int maxY;
    RandomAccessFile file;

    RTreeRead(String fileName) {
        leaf = 0;
        nleaf = 0;
        try {
            this.file = new RandomAccessFile(fileName, "r");
        }
        catch (Exception e) {
            System.out.println("RTreeRead " + e.getMessage());
        }
    }

    public void readSeq() {
        try {
            long length = this.file.length();
            if (length == 0L) {
                return;
            }
            Integer ln = new Integer(new Long(this.file.length()).intValue());
            int kbytes = new Double(Math.floor(ln.doubleValue() / 4096.0)).intValue();
            this.file.seek(0L);
            for (int i = 0; i < kbytes + 1; ++i) {
                byte[] data = new byte[4096];
                this.file.read(data);
                if (i == 0) {
                    this.printFlHdr(data);
                    continue;
                }
                this.printNode(i - 1, data);
            }
            System.out.println("Total Leaf:" + leaf + "\tNonLeaf:" + nleaf);
            System.out.println("MinX:" + minX + "\tMinY:" + minY + "\tMaxX:" + maxX + "\tMaxY:" + maxY);
        }
        catch (Exception e) {
            System.out.println("RTreeRead" + e.getMessage());
        }
    }

    public void printFlHdr(byte[] data) {
        try {
            int frNode;
            DataInputStream ds = new DataInputStream(new ByteArrayInputStream(data));
            System.out.println("\t***The File Header***");
            System.out.println("TotalNodes:(includes unused ones):" + ds.readInt());
            System.out.println("RootIndex: " + ds.readLong());
            System.out.println("The free nodes Stack");
            for (int topIdx = 0; topIdx < 1020 && (frNode = ds.readInt()) != -999; ++topIdx) {
                System.out.println("At " + topIdx + ": " + frNode);
            }
        }
        catch (Exception e) {
            System.out.println("Error at printFlHdr");
            System.exit(1);
        }
    }

    public void printNode(int index, byte[] data) {
        try {
            DataInputStream ds = new DataInputStream(new ByteArrayInputStream(data));
            System.out.println("\t***Node at Index: " + index + "***");
            System.out.println("Node Header");
            int totElmt = ds.readInt();
            System.out.println("TotalElements:" + totElmt);
            System.out.println("Parent:" + ds.readLong());
            System.out.println("Element Size:" + ds.readInt());
            int elmtType = ds.readInt();
            System.out.println("Element Types:" + elmtType);
            if (elmtType == 2) {
                ++nleaf;
            } else {
                ++leaf;
            }
            for (int i = 0; i < totElmt; ++i) {
                System.out.println("Elements...");
                int mx = ds.readInt();
                if (mx < minX) {
                    minX = mx;
                }
                System.out.println("MinX: " + mx);
                int my = ds.readInt();
                if (my < minY) {
                    minY = my;
                }
                System.out.println("MinY: " + my);
                int xx = ds.readInt();
                if (xx > maxX) {
                    maxX = xx;
                }
                System.out.println("MaxX: " + xx);
                int xy = ds.readInt();
                if (xy > maxY) {
                    maxY = xy;
                }
                System.out.println("MaxY: " + xy);
                System.out.println("Pointer: " + ds.readLong());
            }
        }
        catch (Exception e) {
            System.out.println("Error");
            System.exit(1);
        }
    }

    static {
        minX = Integer.MAX_VALUE;
        minY = Integer.MAX_VALUE;
        maxX = Integer.MIN_VALUE;
        maxY = Integer.MIN_VALUE;
    }
}

