/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.wiki.commonswiki.parser;

import info.bliki.wiki.filter.ITextConverter;
import info.bliki.wiki.filter.PlainTextConverter;
import info.bliki.wiki.model.WikiModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.osmand.PlatformUtil;
import net.osmand.wiki.commonswiki.parser.ParserUtils;
import org.apache.commons.logging.Log;

public final class DescriptionParser {
    private static final Log log = PlatformUtil.getLog(DescriptionParser.class);
    private static final int MAX_LANGUAGE_CODE_LENGTH = 5;
    private static final Pattern LINK_PATTERN = Pattern.compile("\\[(https?://\\S+)\\s([^]]+)]");
    private static final Pattern PROVIDED_DESC_PATTERN = Pattern.compile("\\w+\\s+provided\\s+description\\s*:", 2);

    private DescriptionParser() {
    }

    public static Map<String, String> parse(String line, String title) {
        HashMap<String, String> result = new HashMap<String, String>();
        String descriptionBlock = line;
        if (descriptionBlock.contains("{{mld|") || descriptionBlock.contains("{{MLD|")) {
            DescriptionParser.parseMldDescription(descriptionBlock, result);
        } else {
            descriptionBlock = DescriptionParser.parseMultilingualDescriptions(descriptionBlock, result);
        }
        if (result.isEmpty()) {
            DescriptionParser.parsePlainTextDescription(descriptionBlock, result, title);
        }
        return result;
    }

    private static void parseMldDescription(String descriptionBlock, Map<String, String> result) {
        int mldStart = descriptionBlock.indexOf("{{mld|");
        if (mldStart == -1) {
            mldStart = descriptionBlock.indexOf("{{MLD|");
        }
        if (mldStart == -1) {
            return;
        }
        int openBraces = 1;
        int mldEnd = -1;
        for (int i = mldStart + 6; i < descriptionBlock.length() - 1 && openBraces > 0; ++i) {
            if (descriptionBlock.charAt(i) == '{' && descriptionBlock.charAt(i + 1) == '{') {
                ++openBraces;
                ++i;
                continue;
            }
            if (descriptionBlock.charAt(i) != '}' || descriptionBlock.charAt(i + 1) != '}') continue;
            if (--openBraces == 0) {
                mldEnd = i;
                break;
            }
            ++i;
        }
        if (mldEnd == -1) {
            return;
        }
        String mldContent = descriptionBlock.substring(mldStart + 6, mldEnd);
        List<String> parts = ParserUtils.splitByPipeOutsideBraces(mldContent, true);
        for (String part : parts) {
            String cleanedText;
            int equalsIndex = (part = part.trim()).indexOf(61);
            if (equalsIndex <= 0 || equalsIndex >= part.length() - 1) continue;
            String lang = part.substring(0, equalsIndex).trim();
            String text = part.substring(equalsIndex + 1).trim();
            if (lang.length() > 5 || text.isEmpty() || (cleanedText = (cleanedText = DescriptionParser.renderWikiText(text, null)) == null || cleanedText.isEmpty() || cleanedText.startsWith("Template:") ? DescriptionParser.cleanDescriptionText(text) : cleanedText.trim()).isEmpty()) continue;
            result.put(lang, cleanedText);
        }
    }

    private static String parseMultilingualDescriptions(String descriptionBlock, Map<String, String> result) {
        LanguageBlock block;
        while (descriptionBlock.contains("{{") && descriptionBlock.contains("}}") && (block = DescriptionParser.extractLanguageBlock(descriptionBlock)) != null) {
            String cleanedDescription = DescriptionParser.renderWikiText(block.content, null);
            cleanedDescription = cleanedDescription == null || cleanedDescription.isEmpty() || cleanedDescription.startsWith("Template:") ? DescriptionParser.cleanDescriptionText(block.content) : cleanedDescription.trim();
            result.put(block.language, cleanedDescription);
            descriptionBlock = descriptionBlock.substring(block.endIndex).trim();
        }
        return descriptionBlock;
    }

    private static LanguageBlock extractLanguageBlock(String descriptionBlock) {
        int langStart = descriptionBlock.indexOf("{{") + 2;
        int langEnd = descriptionBlock.indexOf("|", langStart);
        if (langEnd == -1) {
            return null;
        }
        String lang = descriptionBlock.substring(langStart, langEnd).trim();
        if (lang.length() > 5) {
            return null;
        }
        int descStart = DescriptionParser.findDescriptionStart(descriptionBlock, langEnd);
        int descEnd = DescriptionParser.findDescriptionEnd(descriptionBlock, descStart);
        if (descEnd == -1) {
            return null;
        }
        String content = descriptionBlock.substring(descStart, descEnd);
        return new LanguageBlock(lang, content, descEnd);
    }

    private static int findDescriptionStart(String descriptionBlock, int langEnd) {
        int explicitStart = descriptionBlock.indexOf("|1=", langEnd);
        if (explicitStart != -1) {
            return explicitStart + 3;
        }
        return langEnd + 1;
    }

    private static int findDescriptionEnd(String descriptionBlock, int startIndex) {
        int openBraces = 1;
        for (int i = startIndex; i < descriptionBlock.length() - 1; ++i) {
            if (descriptionBlock.charAt(i) == '{' && descriptionBlock.charAt(i + 1) == '{') {
                ++openBraces;
                ++i;
                continue;
            }
            if (descriptionBlock.charAt(i) != '}' || descriptionBlock.charAt(i + 1) != '}') continue;
            if (--openBraces == 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static String cleanDescriptionText(String description) {
        description = description.replaceAll("\\[\\[([^|\\]]+)\\|([^\\]]+?)\\]\\]", "$2");
        description = description.replaceAll("\\[\\[([^\\]]+?)\\]\\]", "$1");
        description = description.replaceAll("\\[#[^\\]]+\\]", "");
        return description.replaceAll("\\{\\{[^|]+\\|", "").replaceAll("}}", "").replaceAll("\\{\\{", "").replaceAll("}$", "").trim();
    }

    private static void parsePlainTextDescription(String descriptionBlock, Map<String, String> result, String title) {
        String plainText;
        String description = ParserUtils.extractFieldValue(descriptionBlock, "description");
        if (description == null) {
            description = descriptionBlock.trim();
        }
        if ((description = description.trim()).startsWith("{{")) {
            String plainText2 = DescriptionParser.renderWikiText(description, title);
            if (plainText2 == null) {
                return;
            }
            if ((plainText2 = plainText2.trim()).isEmpty() || plainText2.startsWith("Template:")) {
                plainText2 = DescriptionParser.extractTemplateName(description);
            }
            if (!plainText2.isEmpty()) {
                result.put("en", plainText2);
            }
            return;
        }
        Matcher matcher = PROVIDED_DESC_PATTERN.matcher(description);
        if (matcher.find() && matcher.start() < description.length() / 3) {
            description = description.substring(matcher.end()).trim();
        }
        if ((plainText = DescriptionParser.renderWikiText(description = description.replaceAll("\\[#[^\\]]+\\]", "").trim(), title)) == null) {
            return;
        }
        plainText = plainText.trim();
        List<String> links = DescriptionParser.extractLinks(description);
        if (!links.isEmpty()) {
            plainText = DescriptionParser.appendLinks(plainText, links);
        }
        if (!plainText.isEmpty()) {
            result.put("en", plainText);
        }
    }

    private static String renderWikiText(String description, String title) {
        try {
            WikiModel wikiModel = new WikiModel("", "");
            return wikiModel.render((ITextConverter)new PlainTextConverter(true), description);
        }
        catch (Exception e) {
            log.info((Object)String.format("Rendering wiki text (title: %s)", title != null ? title : "unknown"));
            return null;
        }
    }

    private static String extractTemplateName(String template) {
        if (!template.startsWith("{{") || !template.endsWith("}}")) {
            return "";
        }
        String content = template.substring(2, template.length() - 2).trim();
        List<String> parts = ParserUtils.splitByPipeOutsideBraces(content, true);
        if (parts.isEmpty()) {
            return "";
        }
        return parts.get(0).trim();
    }

    private static List<String> extractLinks(String description) {
        ArrayList<String> links = new ArrayList<String>();
        Matcher matcher = LINK_PATTERN.matcher(description);
        while (matcher.find()) {
            links.add(matcher.group(1));
        }
        return links;
    }

    private static String appendLinks(String text, List<String> links) {
        StringBuilder result = new StringBuilder(text);
        result.append("\n\nLinks:");
        for (int i = 0; i < links.size(); ++i) {
            result.append("\n[").append(i + 1).append("] ").append(links.get(i));
        }
        return result.toString();
    }

    private record LanguageBlock(String language, String content, int endIndex) {
    }
}

