/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.wiki;

import com.google.gson.Gson;
import info.bliki.Messages;
import info.bliki.htmlcleaner.BaseToken;
import info.bliki.htmlcleaner.ContentToken;
import info.bliki.htmlcleaner.TagNode;
import info.bliki.htmlcleaner.TagToken;
import info.bliki.htmlcleaner.Utils;
import info.bliki.wiki.filter.Encoder;
import info.bliki.wiki.filter.SectionHeader;
import info.bliki.wiki.filter.WikipediaParser;
import info.bliki.wiki.model.Configuration;
import info.bliki.wiki.model.ITableOfContent;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.model.ImageFormat;
import info.bliki.wiki.model.WikiModel;
import info.bliki.wiki.tags.HTMLBlockTag;
import info.bliki.wiki.tags.HTMLTag;
import info.bliki.wiki.tags.PTag;
import info.bliki.wiki.tags.TableOfContentTag;
import info.bliki.wiki.tags.util.TagStack;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import net.osmand.util.Algorithms;
import net.osmand.wiki.WikiImageUrlStorage;
import org.apache.commons.codec.digest.DigestUtils;

public class CustomWikiModel
extends WikiModel {
    private Map<String, Map<String, Object>> dataMap;
    private String prevHead = "";
    private boolean preserveContents;
    String[] additionalImageAliases = new String[]{"\u05e7\u05d5\u05d1\u05e5", "\u0645\u0644\u0641", "\u0424\u0430\u0439\u043b"};
    public static final String WIKIPEDIA_COMMONS = "https://upload.wikimedia.org/wikipedia/commons/";
    private static final String PREFIX = "320px-";
    private final WikiImageUrlStorage imageUrlStorage;

    public CustomWikiModel(String imageBaseURL, String linkBaseURL, WikiImageUrlStorage imageUrlStorage, boolean preserveContents) {
        super(imageBaseURL, linkBaseURL);
        this.dataMap = new LinkedHashMap<String, Map<String, Object>>();
        this.imageUrlStorage = imageUrlStorage;
        this.preserveContents = preserveContents;
        for (String alias : this.additionalImageAliases) {
            this.getNamespace().getImage().addAlias(alias);
        }
    }

    public String getContentsJson() {
        LinkedHashMap<String, Map<String, Map<String, Object>>> finalData = new LinkedHashMap<String, Map<String, Map<String, Object>>>();
        finalData.put("headers", this.dataMap);
        return new Gson().toJson(finalData);
    }

    protected String createImageName(ImageFormat imageFormat) {
        Object imageName = imageFormat.getFilename();
        if (((String)imageName).endsWith(".svg")) {
            imageName = (String)imageName + ".png";
        }
        imageName = Encoder.encodeUrl((String)imageName);
        if (this.replaceColon()) {
            imageName = ((String)imageName).replace(':', '/');
        }
        return imageName;
    }

    public void parseInternalImageLink(String imageNamespace, String rawImageLink) {
        String[] parts;
        String imageName = rawImageLink.split("\\|")[0];
        if ((imageName = imageName.substring(imageName.indexOf(":") + 1).trim()).isEmpty()) {
            return;
        }
        String imageHref = this.getWikiBaseURL();
        ImageFormat imageFormat = ImageFormat.getImageFormat((String)rawImageLink, (String)imageNamespace);
        String link = imageFormat.getLink();
        if (link != null) {
            if (link.length() == 0) {
                imageHref = "";
            } else {
                String encodedTitle = this.encodeTitleToUrl(link, true);
                imageHref = imageHref.replace("${title}", encodedTitle);
            }
        } else {
            imageHref = this.replaceColon() ? imageHref.replace("${title}", imageNamespace + "/" + imageName) : imageHref.replace("${title}", imageNamespace + ":" + imageName);
        }
        Object imageSrc = this.getThumbUrl(imageName);
        if (((String)imageSrc).isEmpty()) {
            return;
        }
        if (((String)imageSrc).endsWith(".svg")) {
            imageSrc = (String)imageSrc + ".png";
        }
        String type = imageFormat.getType();
        String caption = imageFormat.getCaption();
        TagToken tag = null;
        if ("thumb".equals(type) || "frame".equals(type)) {
            if (this.fTagStack.size() > 0) {
                tag = this.peekNode();
            }
            this.reduceTokenStack((TagToken)Configuration.HTML_DIV_OPEN);
        }
        if ("frameless".equals(caption)) {
            imageFormat.setCaption(null);
        } else {
            imageFormat.setType("thumbnail");
        }
        for (String part : parts = rawImageLink.split("\\|")) {
            if (!part.contains("px")) continue;
            imageFormat.setSize(part);
        }
        if (imageFormat.getWidth() == 0) {
            imageFormat.setWidth(-1);
        }
        this.appendInternalImageLink(imageHref, (String)imageSrc, imageFormat);
        if (tag instanceof PTag) {
            this.pushNode((TagToken)new PTag());
        }
    }

    public boolean isValidUriScheme(String uriScheme) {
        return uriScheme.contains("http") || uriScheme.contains("https") || uriScheme.contains("ftp") || uriScheme.contains("mailto") || uriScheme.contains("tel") || uriScheme.contains("geo");
    }

    public void appendExternalLink(String uriSchemeName, String link, String linkName, boolean withoutSquareBrackets) {
        link = Utils.escapeXml((String)link, (boolean)true, (boolean)false, (boolean)false);
        if (!(uriSchemeName.equals("http") || uriSchemeName.equals("https") || uriSchemeName.equals("ftp"))) {
            if (uriSchemeName.equals("tel")) {
                link = link.replaceAll("/", " ").replaceAll("o", "(").replaceAll("c", ")");
                linkName = link.replaceFirst(uriSchemeName + ":", "");
            } else {
                linkName = uriSchemeName.equals("geo") ? "Open on map" : link.replaceFirst(uriSchemeName + ":", "");
            }
        }
        TagNode aTagNode = new TagNode("a");
        aTagNode.addAttribute("href", link, true);
        aTagNode.addAttribute("rel", "nofollow", true);
        if (withoutSquareBrackets) {
            boolean geo = uriSchemeName.equals("geo");
            geo = geo ? aTagNode.addAttribute("class", "geo url-geo", true) : aTagNode.addAttribute("class", "external free", true);
            this.append((BaseToken)aTagNode);
            aTagNode.addChild((Object)new ContentToken(linkName));
        } else {
            String trimmedText = linkName.trim();
            if (trimmedText.length() > 0) {
                this.pushNode((TagToken)aTagNode);
                if (linkName.equals(link) || link.length() >= 2 && link.charAt(0) == '/' && link.charAt(1) == '/' && link.substring(2).equals(linkName)) {
                    aTagNode.addAttribute("class", "external autonumber", true);
                    aTagNode.addChild((Object)new ContentToken("[" + ++this.fExternalLinksCounter + "]"));
                } else {
                    aTagNode.addAttribute("class", link.contains(".wikipedia.org/wiki/") ? "geo url-wikipedia" : "external text", true);
                    WikipediaParser.parseRecursive((String)trimmedText, (IWikiModel)this, (boolean)false, (boolean)true);
                }
                this.popNode();
            }
        }
    }

    public void appendInternalLink(String topic, String hashSection, String topicDescription, String cssClass, boolean parseRecursive) {
        this.appendInternalLink(topic, hashSection, topicDescription, cssClass, parseRecursive, true);
    }

    protected void appendInternalLink(String topic, String hashSection, String topicDescription, String cssClass, boolean parseRecursive, boolean topicExists) {
        String description = topicDescription.trim();
        if (topic.length() > 0) {
            String toCompare;
            String pageName;
            String title = Encoder.normaliseTitle((String)topic, (boolean)true, (char)' ', (boolean)true);
            if (hashSection == null && title.equals(pageName = Encoder.normaliseTitle((String)this.fPageTitle, (boolean)true, (char)' ', (boolean)true))) {
                HTMLTag selfLink = new HTMLTag("strong");
                selfLink.addAttribute("class", "selflink", false);
                this.pushNode((TagToken)selfLink);
                selfLink.addChild((Object)new ContentToken(description));
                this.popNode();
                return;
            }
            String encodedtopic = this.encodeTitleToUrl(topic, true);
            if (this.replaceColon()) {
                encodedtopic = encodedtopic.replace(':', '/');
            }
            Object hrefLink = this.getWikiBaseURL().replace("${title}", encodedtopic);
            if (!topicExists) {
                if (cssClass == null) {
                    cssClass = "new";
                }
                hrefLink = ((String)hrefLink).indexOf(63) != -1 ? (String)hrefLink + "&" : (String)hrefLink + "?";
                hrefLink = (String)hrefLink + "action=edit&redlink=1";
                String redlinkString = Messages.getString((ResourceBundle)this.getResourceBundle(), (String)"wiki.tags.red-link", (String)"${title} (page does not exist)");
                title = redlinkString.replace("${title}", title);
            }
            if (!((toCompare = ((String)hrefLink).toLowerCase()).contains(".jpg") || toCompare.contains(".jpeg") || toCompare.contains(".png") || toCompare.contains(".gif") || toCompare.contains(".svg"))) {
                this.appendExternalLink("https", (String)hrefLink, topicDescription, true);
            }
        } else if (hashSection != null) {
            TagNode aTagNode = new TagNode("a");
            Object href = this.encodeTitleToUrl(topic, true);
            if (hashSection != null) {
                href = (String)href + "#" + this.encodeTitleDotUrl(hashSection, false);
            }
            aTagNode.addAttribute("href", (String)href, true);
            if (cssClass != null) {
                aTagNode.addAttribute("class", cssClass, true);
            }
            this.pushNode((TagToken)aTagNode);
            aTagNode.addChild((Object)new ContentToken(description));
            this.popNode();
        }
    }

    public ITableOfContent appendHead(String rawHead, int headLevel, boolean noToC, int headCounter, int startPosition, int endPosition) {
        Map<String, Object> data;
        if (this.preserveContents) {
            return super.appendHead(rawHead, headLevel, noToC, headCounter, startPosition, endPosition);
        }
        TagStack localStack = WikipediaParser.parseRecursive((String)rawHead.trim(), (IWikiModel)this, (boolean)true, (boolean)true);
        HTMLBlockTag headTagNode = new HTMLBlockTag("h" + headLevel, "|applet|snippet|blockquote|body|button|center|dd|del|div|fieldset|form|iframe|ins|li|map|noframes|noscript|object|td|th|");
        TagNode spanTagNode = new TagNode("span");
        spanTagNode.addChildren(localStack.getNodeList());
        headTagNode.addChild((Object)spanTagNode);
        String tocHead = headTagNode.getBodyString();
        String anchor = Encoder.encodeDotUrl((String)tocHead);
        this.createTableOfContent(false);
        if (this.fToCSet.contains(anchor)) {
            Object newAnchor = anchor;
            for (int i = 2; i < Integer.MAX_VALUE && this.fToCSet.contains(newAnchor = anchor + "_" + Integer.toString(i)); ++i) {
            }
            anchor = newAnchor;
        }
        this.fToCSet.add(anchor);
        String trimmedHead = rawHead.trim();
        if (headLevel == 2) {
            LinkedHashMap<String, CallSite> data2 = new LinkedHashMap<String, CallSite>();
            data2.put("link", (CallSite)((Object)("#" + anchor)));
            this.dataMap.put(trimmedHead, data2);
            this.prevHead = trimmedHead;
        } else if (headLevel == 3 && (data = this.dataMap.get(this.prevHead)) != null) {
            Map subHeaders = (Map)data.get("subheaders");
            subHeaders = subHeaders == null ? new LinkedHashMap() : subHeaders;
            HashMap<String, CallSite> link = new HashMap<String, CallSite>();
            link.put("link", (CallSite)((Object)("#" + anchor)));
            subHeaders.put(trimmedHead, link);
            data.put("subheaders", subHeaders);
        }
        SectionHeader strPair = new SectionHeader(headLevel, startPosition, endPosition, tocHead, anchor);
        if (this.getRecursionLevel() == 1) {
            this.buildEditLinkUrl(this.fSectionCounter++);
        }
        spanTagNode.addAttribute("class", "mw-headline", true);
        spanTagNode.addAttribute("id", anchor, true);
        this.append((BaseToken)headTagNode);
        return new TableOfContentTag("a");
    }

    public String getThumbUrl(String fileName) {
        String thumbUrl;
        String simplify = fileName.replace(' ', '_');
        if (this.imageUrlStorage != null && !Algorithms.isEmpty((CharSequence)(thumbUrl = this.imageUrlStorage.getThumbUrl(simplify)))) {
            return thumbUrl;
        }
        String md5 = DigestUtils.md5Hex((String)simplify);
        String hash1 = md5.substring(0, 1);
        String hash2 = md5.substring(0, 2);
        return "https://upload.wikimedia.org/wikipedia/commons/thumb/" + hash1 + "/" + hash2 + "/" + simplify + "/320px-" + simplify;
    }
}

