/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.router;

import gnu.trove.iterator.TIntIntIterator;
import gnu.trove.iterator.TLongObjectIterator;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.set.hash.TLongHashSet;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import net.osmand.binary.BinaryMapRouteReaderAdapter;
import net.osmand.binary.RouteDataObject;
import net.osmand.data.LatLon;
import net.osmand.data.QuadRect;
import net.osmand.osm.edit.Entity;
import net.osmand.osm.edit.Node;
import net.osmand.osm.edit.Way;
import net.osmand.osm.io.OsmBaseStorage;
import net.osmand.osm.io.OsmStorageWriter;
import net.osmand.router.BinaryRoutePlanner;
import net.osmand.router.HHRouteDataStructure;
import net.osmand.router.HHRoutePlanner;
import net.osmand.router.HHRoutingSubGraphCreator;
import net.osmand.router.RouteSegmentResult;
import net.osmand.util.MapUtils;

public class HHRoutingUtilities {
    static long DEBUG_OSM_ID = -1L;
    static long DEBUG_START_TIME = 0L;

    public static void logf(String string, Object ... a) {
        if (DEBUG_START_TIME == 0L) {
            DEBUG_START_TIME = System.currentTimeMillis();
        }
        String ms = String.format("%3.1fs ", Float.valueOf((float)(System.currentTimeMillis() - DEBUG_START_TIME) / 1000.0f));
        System.out.printf(ms + string + "\n", a);
    }

    static LatLon getPoint(BinaryRoutePlanner.RouteSegment r) {
        double lon = MapUtils.get31LongitudeX((int)r.getRoad().getPoint31XTile((int)r.getSegmentStart(), (int)r.getSegmentEnd()));
        double lat = MapUtils.get31LatitudeY((int)r.getRoad().getPoint31YTile((int)r.getSegmentStart(), (int)r.getSegmentEnd()));
        return new LatLon(lat, lon);
    }

    static BinaryRoutePlanner.RouteSegment makePositiveDir(BinaryRoutePlanner.RouteSegment next) {
        return next == null ? null : (next.isPositive() ? next : new BinaryRoutePlanner.RouteSegment(next.getRoad(), (int)next.getSegmentEnd(), (int)next.getSegmentStart()));
    }

    static void addWay(TLongObjectHashMap<Entity> osmObjects, BinaryRoutePlanner.RouteSegment s) {
        Way w = new Way(DEBUG_OSM_ID--);
        int[] tps = s.getRoad().getTypes();
        for (int i = 0; i < tps.length; ++i) {
            BinaryMapRouteReaderAdapter.RouteTypeRule rtr = s.getRoad().region.quickGetEncodingRule(tps[i]);
            w.putTag(rtr.getTag(), rtr.getValue());
        }
        int xt = s.getRoad().getPoint31XTile((int)s.getSegmentStart());
        int yt = s.getRoad().getPoint31YTile((int)s.getSegmentStart());
        w.addNode(new Node(MapUtils.get31LatitudeY((int)yt), MapUtils.get31LongitudeX((int)xt), DEBUG_OSM_ID--));
        int xs = s.getRoad().getPoint31XTile((int)s.getSegmentEnd());
        int ys = s.getRoad().getPoint31YTile((int)s.getSegmentEnd());
        w.addNode(new Node(MapUtils.get31LatitudeY((int)ys), MapUtils.get31LongitudeX((int)xs), DEBUG_OSM_ID--));
        w.putTag("oid", "" + s.getRoad().getId() / 64L);
        osmObjects.put(HHRoutePlanner.calcUniDirRoutePointInternalId((BinaryRoutePlanner.RouteSegment)s), (Object)w);
    }

    public static void addWay(TLongObjectHashMap<Entity> osmObjects, HHRouteDataStructure.NetworkDBSegment segment, String tag, String value) {
        if (segment.geom == null || segment.geom.isEmpty()) {
            return;
        }
        List geometry = segment.getGeometry();
        Way w = new Way(DEBUG_OSM_ID--);
        w.putTag("name", String.format("%d -> %d %.1f", segment.start.index, segment.end.index, segment.dist));
        for (LatLon l : geometry) {
            w.addNode(new Node(l.getLatitude(), l.getLongitude(), DEBUG_OSM_ID--));
        }
        osmObjects.put(w.getId(), (Object)w);
    }

    public static void addWay(TLongObjectHashMap<Entity> osmObjects, RouteSegmentResult segment, String tag, String value) {
        Way w = new Way(DEBUG_OSM_ID--);
        int i = segment.getStartPointIndex();
        boolean pos = segment.getStartPointIndex() < segment.getEndPointIndex();
        while (true) {
            int x = segment.getObject().getPoint31XTile(i);
            int y = segment.getObject().getPoint31YTile(i);
            w.addNode(new Node(MapUtils.get31LatitudeY((int)y), MapUtils.get31LongitudeX((int)x), DEBUG_OSM_ID--));
            if (i == segment.getEndPointIndex()) break;
            i += pos ? 1 : -1;
        }
        osmObjects.put(w.getId(), (Object)w);
    }

    public static void addWay(TLongObjectHashMap<Entity> osmObjects, BinaryRoutePlanner.RouteSegment segment, String tag, String value) {
        Way w = new Way(DEBUG_OSM_ID--);
        int i = segment.getSegmentStart();
        boolean pos = segment.getSegmentStart() < segment.getSegmentEnd();
        while (true) {
            int x = segment.getRoad().getPoint31XTile(i);
            int y = segment.getRoad().getPoint31YTile(i);
            w.addNode(new Node(MapUtils.get31LatitudeY((int)y), MapUtils.get31LongitudeX((int)x), DEBUG_OSM_ID--));
            if (i == segment.getSegmentEnd()) break;
            i += pos ? 1 : -1;
        }
        osmObjects.put(w.getId(), (Object)w);
    }

    static void addNode(TLongObjectHashMap<Entity> osmObjects, HHRouteDataStructure.NetworkDBPoint pnt, LatLon l, String tag, String val) {
        if (l == null) {
            l = pnt.getPoint();
        }
        Node n = new Node(l.getLatitude(), l.getLongitude(), DEBUG_OSM_ID--);
        n.putTag(tag, val);
        n.putTag("name", pnt.index + " " + pnt.roadId / 64L + " " + pnt.start + " " + pnt.end);
        n.putTag("clusterId", "" + pnt.clusterId);
        n.putTag("index", "" + pnt.index);
        if (pnt.dualPoint != null) {
            n.putTag("dualClusterId", "" + pnt.dualPoint.clusterId);
            n.putTag("dualPoint", "" + pnt.dualPoint.index);
        }
        osmObjects.put(pnt.getGeoPntId(), (Object)n);
    }

    public static List<Entity> visualizeClusters(List<HHRoutingSubGraphCreator.NetworkIsland> visualClusters) {
        ArrayList<Entity> objs = new ArrayList<Entity>();
        int clusters = 0;
        int allCenterRoads = 0;
        int allShortcuts = 0;
        if (visualClusters == null) {
            return objs;
        }
        int allRoads = HHRoutingUtilities.visualizeAllNodes(visualClusters, objs);
        TLongObjectHashMap pnts = new TLongObjectHashMap();
        for (HHRoutingSubGraphCreator.NetworkIsland island : visualClusters) {
            LatLon l = island.startLatLon;
            Node startNode = new Node(l.getLatitude(), l.getLongitude(), DEBUG_OSM_ID--);
            startNode.putTag("highway", "traffic_signals");
            startNode.putTag("name", island.startToString);
            startNode.putTag("clusterId", "" + island.dbIndex);
            objs.add((Entity)startNode);
            startNode.putTag("borderPoints", "" + island.borderVertices.size());
            ++clusters;
            allShortcuts += island.borderVertices.size() * (island.borderVertices.size() - 1);
            allCenterRoads += island.borderVertices.size();
            for (HHRoutingSubGraphCreator.RouteSegmentBorderPoint bp : island.borderVertices) {
                double lon = MapUtils.get31LongitudeX((int)(bp.sx / 2 + bp.ex / 2));
                double lat = MapUtils.get31LatitudeY((int)(bp.sy / 2 + bp.ey / 2));
                Node bNode = new Node(lat, lon, DEBUG_OSM_ID--);
                bNode.putTag("highway", "stop");
                bNode.putTag("dir", "" + bp.isPositive());
                bNode.putTag("unidir", "" + bp.unidirId);
                bNode.putTag("name", bp.toString());
                bNode.putTag("clusterId", "" + island.dbIndex);
                pnts.put(bp.uniqueId, (Object)bNode);
                if (island.visualBorders != null) continue;
                Way w = new Way(DEBUG_OSM_ID--, Arrays.asList(startNode, bNode));
                w.putTag("highway", "track");
                objs.add((Entity)w);
            }
            if (island.visualBorders == null) continue;
            TLongObjectIterator it = island.visualBorders.iterator();
            while (it.hasNext()) {
                it.advance();
                long pid = it.key();
                List lls = (List)it.value();
                if (lls.size() <= 0) continue;
                ArrayList<Node> nodesList = new ArrayList<Node>();
                nodesList.add(startNode);
                for (int i = lls.size() - 2; i >= 0; --i) {
                    LatLon ln = (LatLon)lls.get(i);
                    Node n2 = new Node(ln.getLatitude(), ln.getLongitude(), DEBUG_OSM_ID--);
                    objs.add((Entity)n2);
                    nodesList.add(n2);
                }
                if (!pnts.containsKey(pid)) {
                    LatLon ln = (LatLon)lls.get(0);
                    Node n2 = new Node(ln.getLatitude(), ln.getLongitude(), DEBUG_OSM_ID--);
                    objs.add((Entity)n2);
                    pnts.put(pid, (Object)n2);
                }
                if (lls.size() > 1) {
                    nodesList.add((Node)pnts.get(pid));
                    Way w = new Way(DEBUG_OSM_ID--, nodesList);
                    w.putTag("highway", "track");
                    objs.add((Entity)w);
                }
                nodesList.clear();
                nodesList.add(startNode);
                nodesList.add((Node)pnts.get(pid));
                Way w = new Way(DEBUG_OSM_ID--, nodesList);
                w.putTag("highway", "motorway");
                objs.add((Entity)w);
            }
        }
        System.out.printf("Total visited roads %d, total clusters %d, total segments %d (from centers) - 2x border points, total segments %d between border points \n", allRoads, clusters, allCenterRoads, allShortcuts);
        return objs;
    }

    private static int visualizeAllNodes(List<HHRoutingSubGraphCreator.NetworkIsland> visualClusters, List<Entity> objs) {
        boolean merge = false;
        int ways1 = 0;
        for (HHRoutingSubGraphCreator.NetworkIsland ni : visualClusters) {
            TLongHashSet viewed = new TLongHashSet();
            if (ni.visitedVertices == null) continue;
            TLongObjectIterator it = ni.visitedVertices.iterator();
            while (it.hasNext()) {
                BinaryRoutePlanner.RouteSegment s;
                it.advance();
                long pntKey = it.key();
                if (viewed.contains(pntKey) || (s = (BinaryRoutePlanner.RouteSegment)it.value()) == null) continue;
                int d = s.getSegmentStart() < s.getSegmentEnd() ? 1 : -1;
                int segmentEnd = s.getSegmentEnd();
                viewed.add(pntKey);
                if (merge) {
                    BinaryRoutePlanner.RouteSegment nxt;
                    while (segmentEnd + d >= 0 && segmentEnd + d < s.getRoad().getPointsLength() && ni.visitedVertices.containsKey(pntKey = HHRoutePlanner.calcUniDirRoutePointInternalId((BinaryRoutePlanner.RouteSegment)(nxt = new BinaryRoutePlanner.RouteSegment(s.getRoad(), segmentEnd, segmentEnd + d)))) && !viewed.contains(pntKey)) {
                        viewed.add(pntKey);
                        segmentEnd += d;
                    }
                }
                Way w = HHRoutingUtilities.convertRoad(s.getRoad(), s.getSegmentStart(), segmentEnd);
                if (s.distanceToEnd > 0.0f) {
                    w.putTag("dist", "" + (int)s.distanceToEnd);
                }
                objs.add((Entity)w);
                ++ways1;
            }
        }
        return ways1;
    }

    private static Way convertRoad(RouteDataObject road, int st, int end) {
        Way w = new Way(DEBUG_OSM_ID--);
        int[] tps = road.getTypes();
        for (int i = 0; i < tps.length; ++i) {
            BinaryMapRouteReaderAdapter.RouteTypeRule rtr = road.region.quickGetEncodingRule(tps[i]);
            w.putTag(rtr.getTag(), rtr.getValue());
        }
        w.putTag("oid", "" + road.getId() / 64L);
        while (true) {
            double lon = MapUtils.get31LongitudeX((int)road.getPoint31XTile(st));
            double lat = MapUtils.get31LatitudeY((int)road.getPoint31YTile(st));
            w.addNode(new Node(lat, lon, DEBUG_OSM_ID--));
            if (st == end) break;
            if (st < end) {
                ++st;
                continue;
            }
            --st;
        }
        return w;
    }

    public static void saveOsmFile(Collection<Entity> objects, File file) throws FileNotFoundException, XMLStreamException, IOException {
        OsmBaseStorage st = new OsmBaseStorage();
        for (Entity e : objects) {
            if (e instanceof Way) {
                for (Node n : ((Way)e).getNodes()) {
                    st.registerEntity((Entity)n, null);
                }
            }
            st.registerEntity(e, null);
        }
        OsmStorageWriter w = new OsmStorageWriter();
        FileOutputStream fous = new FileOutputStream(file);
        w.saveStorage(fous, st, null, true);
        fous.close();
    }

    public static int distrSum(TIntIntHashMap mp, int maxEl) {
        int k = 0;
        TIntIntIterator it = mp.iterator();
        while (it.hasNext()) {
            it.advance();
            if (it.key() >= maxEl && maxEl >= 0) continue;
            k += it.value();
        }
        return k;
    }

    public static int distrCumKey(TIntIntHashMap mp, int maxEl) {
        int sum = 0;
        int[] keys = mp.keys();
        Arrays.sort(keys);
        for (int k : keys) {
            if ((sum += mp.get(k)) <= maxEl) continue;
            return k;
        }
        return -1;
    }

    public static String distrString(TIntIntHashMap distr, String suf) {
        return HHRoutingUtilities.distrString(distr, suf, false, false, 3.0);
    }

    public static String distrString(TIntIntHashMap distr, String suf, boolean cum, boolean valPrint, double percentMin) {
        int k;
        int[] keys = distr.keys();
        Arrays.sort(keys);
        StringBuilder b = new StringBuilder();
        int sum = 0;
        for (k = 0; k < keys.length; ++k) {
            sum += distr.get(keys[k]);
        }
        b.append(String.format("%,d", sum));
        int val = 0;
        int prevVal = 0;
        double percent = 0.0;
        int kMin = -1;
        for (k = 0; k < keys.length; ++k) {
            if (kMin < 0) {
                kMin = keys[k];
            }
            if (!((percent = (double)(val += distr.get(keys[k])) * 100.0 / (double)sum) - (double)prevVal * 100.0 / (double)sum >= percentMin)) continue;
            String d = !valPrint ? (int)percent + "%" : "" + val;
            String range = "" + keys[k];
            if (!cum && kMin != keys[k]) {
                range = kMin + "-" + range;
            }
            b.append(", ").append(range).append(suf).append(" - " + d);
            if (!cum) {
                val = 0;
            } else {
                prevVal = val;
            }
            kMin = -1;
        }
        if (percent < percentMin && keys.length > 0) {
            b.append("... " + keys[keys.length - 1]);
        }
        return b.toString();
    }

    public static QuadRect expandLatLonRect(QuadRect qr, double left, double top, double right, double bottom) {
        if (qr == null) {
            qr = new QuadRect(left, top, right, bottom);
        }
        if (left < qr.left) {
            qr.left = left;
        }
        if (right > qr.right) {
            qr.right = right;
        }
        if (top > qr.top) {
            qr.top = top;
        }
        if (bottom < qr.bottom) {
            qr.bottom = bottom;
        }
        return qr;
    }

    static double testGetDist(BinaryRoutePlanner.RouteSegment t, boolean precise) {
        int px = 0;
        int py = 0;
        double d = 0.0;
        while (t != null) {
            int sx = t.getRoad().getPoint31XTile((int)t.getSegmentStart(), (int)t.getSegmentEnd());
            int sy = t.getRoad().getPoint31YTile((int)t.getSegmentStart(), (int)t.getSegmentEnd());
            t = t.getParentRoute();
            if (px != 0) {
                d = precise ? (d += MapUtils.measuredDist31((int)px, (int)py, (int)sx, (int)sy)) : (d += MapUtils.squareRootDist31((int)px, (int)py, (int)sx, (int)sy));
            }
            px = sx;
            py = sy;
        }
        return d;
    }

    static List<LatLon> testGeometry(BinaryRoutePlanner.RouteSegment t) {
        ArrayList<LatLon> l = new ArrayList<LatLon>();
        while (t != null) {
            LatLon p = HHRoutingUtilities.getPoint(t);
            l.add(p);
            t = t.getParentRoute();
        }
        return l;
    }

    static String testGetGeometry(List<LatLon> ls) {
        StringBuilder b = new StringBuilder();
        b.append("<?xml version='1.0' encoding='UTF-8' standalone='yes' ?>");
        b.append("<gpx version=\"1.1\" ><trk><trkseg>");
        for (LatLon p : ls) {
            b.append(String.format("<trkpt lat=\"%.6f\" lon=\"%.6f\"/> ", p.getLatitude(), p.getLongitude()));
        }
        b.append("</trkseg></trk></gpx>");
        return b.toString();
    }
}

