/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.router;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.router.HHRoutingPreparationDB;
import net.osmand.router.HHRoutingUtilities;
import net.osmand.router.RouteCalculationProgress;
import net.osmand.router.RoutePlannerFrontEnd;
import net.osmand.router.RoutingConfiguration;
import net.osmand.router.RoutingContext;

public class HHRoutingPrepareContext {
    static final int ROUTING_MEMORY_LIMIT = 3000;
    static int MEMORY_RELOAD_TIMEOUT_SECONDS = 120;
    static int MEMORY_RELOAD_MB = 1000;
    static long MEMEORY_LAST_RELOAD = System.currentTimeMillis();
    static long MEMORY_LAST_USED_MB;
    private String ROUTING_PROFILE = "car";
    private Map<String, String> PROFILE_SETTINGS = new TreeMap<String, String>();
    private List<File> FILE_SOURCES = new ArrayList<File>();
    public static final Map<String, String> ambiguousConditionalTags;

    public HHRoutingPrepareContext(File obfFile, String routingProfile, String ... profileSettings) {
        if (routingProfile != null) {
            this.ROUTING_PROFILE = routingProfile;
        }
        if (obfFile.isDirectory()) {
            for (File f : obfFile.listFiles()) {
                if (!f.getName().endsWith(".obf")) continue;
                this.FILE_SOURCES.add(f);
            }
        } else {
            this.FILE_SOURCES.add(obfFile);
        }
        if (profileSettings != null) {
            for (String sp : profileSettings) {
                String[] s = sp.split("=");
                String val = "true";
                if (s.length > 1) {
                    val = s[1];
                }
                this.PROFILE_SETTINGS.put(s[0], val);
            }
        }
        Collections.sort(this.FILE_SOURCES, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return Long.compare(o1.length(), o2.length());
            }
        });
    }

    RoutingContext gcMemoryLimitToUnloadAll(RoutingContext ctx, List<HHRoutingPreparationDB.NetworkRouteRegion> subRegions, boolean force) throws IOException {
        long usedMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory() >> 20;
        if (force || usedMemory - MEMORY_LAST_USED_MB > (long)MEMORY_RELOAD_MB && System.currentTimeMillis() - MEMEORY_LAST_RELOAD > (long)(MEMORY_RELOAD_TIMEOUT_SECONDS * 1000)) {
            long nt = System.nanoTime();
            System.gc();
            long ntusedMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory() >> 20;
            if (!force && ntusedMemory - MEMORY_LAST_USED_MB < (long)MEMORY_RELOAD_MB) {
                return ctx;
            }
            LinkedHashSet<File> fls = null;
            if (subRegions != null) {
                fls = new LinkedHashSet<File>();
                for (HHRoutingPreparationDB.NetworkRouteRegion r : subRegions) {
                    fls.add(r.file);
                }
            }
            ctx = this.prepareContext(fls, ctx);
            ctx.calculationProgress = new RouteCalculationProgress();
            System.gc();
            MEMORY_LAST_USED_MB = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory() >> 20;
            MEMEORY_LAST_RELOAD = System.currentTimeMillis();
            double reloadTimeSeconds = (double)(System.nanoTime() - nt) / 1.0E9;
            HHRoutingUtilities.logf("***** Reload memory used before %d MB -> GC %d MB -> reload ctx %d MB (%.1f s) *****\n", usedMemory, ntusedMemory, MEMORY_LAST_USED_MB, reloadTimeSeconds);
            if (reloadTimeSeconds * 8.0 > (double)MEMORY_RELOAD_TIMEOUT_SECONDS) {
                MEMORY_RELOAD_TIMEOUT_SECONDS = (int)(reloadTimeSeconds * 16.0);
                HHRoutingUtilities.logf("New reload memory time %d seconds", MEMORY_RELOAD_TIMEOUT_SECONDS);
            }
        }
        return ctx;
    }

    RoutingContext prepareContext(Collection<File> fileSources, RoutingContext oldCtx) throws IOException {
        List<BinaryMapIndexReader> readers = this.initReaders(fileSources);
        if (oldCtx != null) {
            for (BinaryMapIndexReader r : oldCtx.map.keySet()) {
                r.close();
            }
        }
        RoutePlannerFrontEnd router = new RoutePlannerFrontEnd();
        RoutingConfiguration config = this.getRoutingConfig();
        return router.buildRoutingContext(config, null, readers.toArray(new BinaryMapIndexReader[readers.size()]), RoutePlannerFrontEnd.RouteCalculationMode.NORMAL);
    }

    public RoutingConfiguration getRoutingConfig() {
        RoutingConfiguration.Builder builder = RoutingConfiguration.parseDefault();
        RoutingConfiguration.RoutingMemoryLimits memoryLimit = new RoutingConfiguration.RoutingMemoryLimits(3000, 3000);
        RoutingConfiguration config = builder.build(this.ROUTING_PROFILE, memoryLimit, this.PROFILE_SETTINGS);
        config.planRoadDirection = 1;
        config.heuristicCoefficient = 0.0f;
        config.ambiguousConditionalTags = ambiguousConditionalTags;
        return config;
    }

    private List<BinaryMapIndexReader> initReaders(Collection<File> hints) throws IOException {
        ArrayList<BinaryMapIndexReader> readers = new ArrayList<BinaryMapIndexReader>();
        for (File source : hints != null ? hints : this.FILE_SOURCES) {
            BinaryMapIndexReader reader = new BinaryMapIndexReader(new RandomAccessFile(source, "r"), source);
            readers.add(reader);
        }
        return readers;
    }

    static {
        ambiguousConditionalTags = Map.of("oneway:conditional", "no", "access:conditional", "yes", "maxspeed:conditional", "RULE_INT_MAX");
    }
}

