/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.obf.preparation;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.zip.GZIPInputStream;
import net.osmand.obf.preparation.OsmDbAccessorContext;
import net.osmand.osm.edit.Entity;
import net.osmand.osm.edit.Node;
import net.osmand.osm.edit.Relation;
import net.osmand.osm.edit.Way;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;

public class OverpassFetcher {
    private static final Log log = LogFactory.getLog(OverpassFetcher.class);
    private static OverpassFetcher instance;
    private final String overpassUrl = System.getenv("OVERPASS_URL");

    private OverpassFetcher() {
        if (this.overpassUrl == null || this.overpassUrl.isEmpty()) {
            log.warn((Object)"OVERPASS_URL environment variable is not set.");
        } else {
            log.warn((Object)"OVERPASS_URL is configured.");
        }
    }

    public static synchronized OverpassFetcher getInstance() {
        if (instance == null) {
            instance = new OverpassFetcher();
        }
        return instance;
    }

    public boolean isOverpassConfigured() {
        return this.overpassUrl != null && !this.overpassUrl.isEmpty();
    }

    public void fetchCompleteGeometryRelation(Relation relation, OsmDbAccessorContext ctx, Long lastModifiedDate) {
        List<Long> wayIdsToFetch = this.getIncompleteWayIdsForRelation(relation);
        if (wayIdsToFetch.isEmpty()) {
            return;
        }
        if (!this.isOverpassConfigured()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        String wayIds = String.join((CharSequence)",", (CharSequence[])wayIdsToFetch.stream().map(String::valueOf).toArray(String[]::new));
        String query = "[out:json];way(id:" + wayIds + "); out geom;";
        String formattedDate = "";
        if (lastModifiedDate != null) {
            Instant instant = Instant.ofEpochMilli(lastModifiedDate);
            DateTimeFormatter formatter = DateTimeFormatter.ISO_INSTANT;
            formattedDate = formatter.format(instant);
            query = "[out:json][date:\"" + formattedDate + "\"];way(id:" + wayIds + "); out geom;";
        }
        String urlString = this.overpassUrl + "/api/interpreter";
        try {
            URL url = new URL(urlString);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setDoOutput(true);
            String body = "data=" + URLEncoder.encode(query, StandardCharsets.UTF_8.toString());
            try (OutputStream os = connection.getOutputStream();){
                byte[] input = body.getBytes(StandardCharsets.UTF_8);
                os.write(input, 0, input.length);
            }
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                JSONObject element;
                int i;
                String inputLine;
                BufferedReader in = new BufferedReader(new InputStreamReader(new GZIPInputStream(connection.getInputStream())));
                StringBuilder response = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();
                JSONObject jsonResponse = new JSONObject(response.toString());
                JSONArray elements = jsonResponse.getJSONArray("elements");
                HashMap<Entity.EntityId, Object> fetchedEntities = new HashMap<Entity.EntityId, Object>();
                for (i = 0; i < elements.length(); ++i) {
                    element = elements.getJSONObject(i);
                    if (!element.getString("type").equals("node")) continue;
                    long nodeId = element.getLong("id");
                    double lat = element.getDouble("lat");
                    double lon = element.getDouble("lon");
                    Node node = new Node(lat, lon, nodeId);
                    fetchedEntities.put(new Entity.EntityId(Entity.EntityType.NODE, Long.valueOf(nodeId)), node);
                }
                for (i = 0; i < elements.length(); ++i) {
                    element = elements.getJSONObject(i);
                    if (!element.getString("type").equals("way")) continue;
                    long wayId = element.getLong("id");
                    JSONArray nodeIds = element.getJSONArray("nodes");
                    JSONArray geoms = element.getJSONArray("geometry");
                    Way way = new Way(wayId);
                    for (int j = 0; j < nodeIds.length(); ++j) {
                        long nodeId = nodeIds.getLong(j);
                        Node node = (Node)fetchedEntities.get(new Entity.EntityId(Entity.EntityType.NODE, Long.valueOf(nodeId)));
                        if (node == null) {
                            double lat = geoms.getJSONObject(j).getDouble("lat");
                            double lon = geoms.getJSONObject(j).getDouble("lon");
                            node = new Node(lat, lon, nodeId);
                        }
                        if (ctx != null) {
                            long nid = ctx.convertId((Entity)node);
                            node = new Node(node.getLatitude(), node.getLongitude(), nid);
                        }
                        way.addNode(node);
                    }
                    fetchedEntities.put(new Entity.EntityId(Entity.EntityType.WAY, Long.valueOf(wayId)), way);
                }
                relation.initializeLinks(fetchedEntities);
                log.info((Object)String.format("Fetched members on date \"%s\" for relation %d (%.2f sec)", formattedDate, relation.getId(), (double)(System.currentTimeMillis() - startTime) / 1000.0, wayIds));
            } else {
                log.error((Object)("Failed to fetch data from Overpass API. Response code: " + responseCode));
            }
        }
        catch (Exception e) {
            log.error((Object)"Error fetching data from Overpass API", (Throwable)e);
        }
    }

    public List<Long> getIncompleteWayIdsForRelation(Relation relation) {
        ArrayList<Long> wayIdsToFetch = new ArrayList<Long>();
        for (Relation.RelationMember member : relation.getMembers()) {
            if (!(member.getEntity() instanceof Way)) continue;
            long wayId = ((Way)member.getEntity()).getId();
            Way way = null;
            for (Relation.RelationMember m : relation.getMembers()) {
                if (!(m.getEntity() instanceof Way) || ((Way)m.getEntity()).getId() != wayId) continue;
                way = (Way)m.getEntity();
                break;
            }
            boolean hasNullNodes = false;
            if (way == null || way.getNodeIds().isEmpty() || way.getNodes().size() != way.getNodeIds().size()) {
                hasNullNodes = true;
            } else {
                for (Node node : way.getNodes()) {
                    if (node != null) continue;
                    hasNullNodes = true;
                    break;
                }
            }
            if (!hasNullNodes) continue;
            wayIdsToFetch.add(wayId);
        }
        return wayIdsToFetch;
    }
}

