/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.obf.preparation;

import gnu.trove.TLongCollection;
import gnu.trove.iterator.TLongObjectIterator;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.set.hash.TLongHashSet;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import net.osmand.PlatformUtil;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.binary.BinaryMapRouteReaderAdapter;
import net.osmand.binary.RouteDataObject;
import net.osmand.impl.ConsoleProgressImplementation;
import net.osmand.router.BinaryRoutePlanner;
import net.osmand.router.RoutePlannerFrontEnd;
import net.osmand.router.RoutingConfiguration;
import net.osmand.router.RoutingContext;
import net.osmand.router.VehicleRouter;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;

public class ImproveRoadConnectivity {
    private static final boolean TRACE = false;
    private static final boolean USE_NEW_IMPROVE_BASE_ROUTING_ALGORITHM = false;
    private final Log log = PlatformUtil.getLog(ImproveRoadConnectivity.class);

    public static void main(String[] args) throws IOException {
        ConsoleProgressImplementation.deltaTimeToPrintMax = 10000L;
        ImproveRoadConnectivity crc = new ImproveRoadConnectivity();
        File fl = new File("/Users/victorshcherb/Desktop/Denmark_central-region_europe_2.obf");
        RandomAccessFile raf = new RandomAccessFile(fl, "r");
        TLongObjectHashMap<RouteDataObject> map = crc.collectDisconnectedRoads(new BinaryMapIndexReader(raf, fl));
        System.out.println("Found roads: " + map.size());
    }

    public TLongObjectHashMap<RouteDataObject> collectDisconnectedRoads(BinaryMapIndexReader reader) throws IOException {
        TLongObjectHashMap all = new TLongObjectHashMap();
        TLongObjectHashMap onlyRoads = new TLongObjectHashMap();
        TLongHashSet registeredRoadIds = new TLongHashSet();
        this.findAllBaseRoadIntersections(reader, (TLongObjectHashMap<List<RouteDataObject>>)all, (TLongObjectHashMap<List<RouteDataObject>>)onlyRoads, registeredRoadIds);
        return this.getRoadsForImproveBaseRouting((TLongObjectHashMap<List<RouteDataObject>>)onlyRoads, (TLongObjectHashMap<List<RouteDataObject>>)all, reader, null, registeredRoadIds);
    }

    private void findAllBaseRoadIntersections(BinaryMapIndexReader reader, TLongObjectHashMap<List<RouteDataObject>> all, TLongObjectHashMap<List<RouteDataObject>> onlyRoads, TLongHashSet registeredRoadIds) throws IOException {
        RoutePlannerFrontEnd router = new RoutePlannerFrontEnd();
        RoutingConfiguration.Builder builder = RoutingConfiguration.getDefault();
        RoutingConfiguration.RoutingMemoryLimits memoryLimit = new RoutingConfiguration.RoutingMemoryLimits(90, 256);
        RoutingConfiguration config = builder.build("car", memoryLimit);
        RoutingContext ctx = router.buildRoutingContext(config, null, new BinaryMapIndexReader[]{reader}, RoutePlannerFrontEnd.RouteCalculationMode.BASE);
        if (reader.getRoutingIndexes().size() != 1) {
            throw new UnsupportedOperationException();
        }
        BinaryMapRouteReaderAdapter.RouteRegion reg = (BinaryMapRouteReaderAdapter.RouteRegion)reader.getRoutingIndexes().get(0);
        List baseSubregions = reg.getBaseSubregions();
        ArrayList tiles = new ArrayList();
        for (BinaryMapRouteReaderAdapter.RouteSubregion s : baseSubregions) {
            List loadTiles = ctx.loadAllSubregionTiles(reader, s);
            tiles.addAll(loadTiles);
        }
        for (RoutingContext.RoutingSubregionTile tile : tiles) {
            ArrayList dataObjects = new ArrayList();
            ctx.loadSubregionTile(tile, false, dataObjects, null);
            for (RouteDataObject o : dataObjects) {
                registeredRoadIds.add(o.getId());
                int len = o.getPointsLength() - 1;
                double dist = MapUtils.squareRootDist31((int)o.getPoint31XTile(0), (int)o.getPoint31YTile(0), (int)o.getPoint31XTile(len), (int)o.getPoint31YTile(len));
                boolean shortFerry = "ferry".equals(o.getRoute()) && dist < 1000.0;
                if (shortFerry) continue;
                boolean link = o.getHighway() != null && o.getHighway().endsWith("link");
                long b = this.calcPointId(o, 0);
                long e = this.calcPointId(o, len);
                if (!link) {
                    this.addPoint(onlyRoads, o, b);
                    this.addPoint(onlyRoads, o, e);
                }
                for (int i = 0; i < o.getPointsLength(); ++i) {
                    this.addPoint(all, o, this.calcPointId(o, i));
                }
            }
        }
    }

    private void addPoint(TLongObjectHashMap<List<RouteDataObject>> map, RouteDataObject routeDataObject, long pointId) {
        if (!map.containsKey(pointId)) {
            map.put(pointId, new ArrayList());
        }
        ((List)map.get(pointId)).add(routeDataObject);
    }

    private TLongObjectHashMap<RouteDataObject> getRoadsForImproveBaseRouting(TLongObjectHashMap<List<RouteDataObject>> mapOfObjectToCheck, TLongObjectHashMap<List<RouteDataObject>> all, BinaryMapIndexReader reader, TLongHashSet setToRemove, TLongHashSet registeredIds) {
        RoutePlannerFrontEnd frontEnd = new RoutePlannerFrontEnd();
        RoutingConfiguration.RoutingMemoryLimits memoryLimit = new RoutingConfiguration.RoutingMemoryLimits(4000, 2560);
        RoutingConfiguration config = RoutingConfiguration.getDefault().build("car", memoryLimit);
        TLongObjectHashMap toAdd = new TLongObjectHashMap();
        TLongHashSet beginIsolated = new TLongHashSet();
        TLongHashSet endIsolated = new TLongHashSet();
        ConsoleProgressImplementation cpi = new ConsoleProgressImplementation();
        TLongObjectHashMap pointsToCheck = new TLongObjectHashMap();
        TLongObjectIterator it = mapOfObjectToCheck.iterator();
        while (it.hasNext()) {
            it.advance();
            if (((List)it.value()).size() != 1) continue;
            pointsToCheck.put(it.key(), (Object)((RouteDataObject)((List)it.value()).get(0)));
        }
        cpi.startTask("Start found roads in Normal routing for added to Base routing: ", pointsToCheck.size());
        TLongObjectIterator itn = pointsToCheck.iterator();
        while (itn.hasNext()) {
            cpi.progress(1);
            itn.advance();
            long point = itn.key();
            RouteDataObject rdo = (RouteDataObject)itn.value();
            boolean isBeginPoint = this.calcPointId(rdo, 0) == point;
            RoutingContext baseCtx = frontEnd.buildRoutingContext(config, null, new BinaryMapIndexReader[]{reader}, RoutePlannerFrontEnd.RouteCalculationMode.BASE);
            RoutingContext ctx = frontEnd.buildRoutingContext(config, null, new BinaryMapIndexReader[]{reader}, RoutePlannerFrontEnd.RouteCalculationMode.NORMAL);
            List<RouteDataObject> result = this.findConnectedRoadsOld(ctx, rdo, isBeginPoint, all);
            if (result.isEmpty()) {
                if (isBeginPoint) {
                    beginIsolated.add(rdo.getId());
                    continue;
                }
                endIsolated.add(rdo.getId());
                continue;
            }
            for (RouteDataObject obj : result) {
                if (registeredIds.contains(obj.id)) continue;
                toAdd.put(obj.id, (Object)obj);
            }
        }
        int begSize = beginIsolated.size();
        int endSize = endIsolated.size();
        beginIsolated.retainAll((TLongCollection)endIsolated);
        int intersectionSize = beginIsolated.size();
        if (setToRemove != null) {
            setToRemove.addAll((TLongCollection)beginIsolated);
        }
        this.log.info((Object)("All objects in base file " + mapOfObjectToCheck.size() + " to keep isolated " + (begSize + endSize - 2 * intersectionSize) + " to add " + toAdd.size() + " to remove " + beginIsolated.size()));
        return toAdd;
    }

    private TLongObjectHashMap<List<RouteDataObject>> getPointsForFindDisconnectedRoads(TLongObjectHashMap<List<RouteDataObject>> allBaseIntersections, long startPointId, RoutingContext ctx) {
        TLongObjectHashMap neighboringPoints = new TLongObjectHashMap();
        RouteDataObject startRdo = (RouteDataObject)((List)allBaseIntersections.get(startPointId)).get(0);
        ArrayList roadsForCheck = new ArrayList();
        ctx.loadTileData(startRdo.getPoint31XTile(0), startRdo.getPoint31YTile(0), 14, roadsForCheck);
        for (RouteDataObject rdo : roadsForCheck) {
            this.addPoint((TLongObjectHashMap<List<RouteDataObject>>)neighboringPoints, rdo, this.calcPointId(rdo, 0));
            this.addPoint((TLongObjectHashMap<List<RouteDataObject>>)neighboringPoints, rdo, this.calcPointId(rdo, rdo.getPointsLength() - 1));
        }
        return neighboringPoints;
    }

    private TLongObjectHashMap<List<RouteDataObject>> findDisconnectedBasePoints(RoutingContext baseCtx, long pointId, TLongObjectHashMap<List<RouteDataObject>> neighboringPoints) {
        long[] pointsIds;
        TLongObjectHashMap result = new TLongObjectHashMap();
        VehicleRouter router = baseCtx.getRouter();
        HashMap<Long, Double> distFromStarts = new HashMap<Long, Double>();
        for (long id : pointsIds = neighboringPoints.keys()) {
            if (id == pointId) {
                distFromStarts.put(id, 0.0);
                continue;
            }
            distFromStarts.put(id, (Double)Double.MAX_VALUE);
        }
        PriorityQueue<Point> queue = new PriorityQueue<Point>(neighboringPoints.keys().length, new Point());
        queue.add(new Point(pointId, 0.0));
        TLongHashSet visited = new TLongHashSet();
        while (visited.size() != neighboringPoints.keys().length - 1) {
            if (queue.isEmpty()) {
                for (long id : pointsIds) {
                    if ((Double)distFromStarts.get(id) != Double.MAX_VALUE) continue;
                    result.put(id, (Object)((List)neighboringPoints.get(id)));
                }
                return result;
            }
            Point point = queue.poll();
            visited.add(point.pointId);
            this.processNeighboringPoints(point, neighboringPoints, router, distFromStarts, queue, visited, pointId);
        }
        return null;
    }

    private void processNeighboringPoints(Point point, TLongObjectHashMap<List<RouteDataObject>> neighboringPoints, VehicleRouter router, Map<Long, Double> distFromStarts, PriorityQueue<Point> queue, TLongHashSet visited, long pointId) {
        List rdos = (List)neighboringPoints.get(point.pointId);
        if (rdos != null) {
            for (RouteDataObject rdo : rdos) {
                boolean startRoad;
                int oneWay = router.isOneWay(rdo);
                boolean isBegin = this.calcPointId(rdo, 0) == point.pointId;
                BinaryRoutePlanner.RouteSegment segment = new BinaryRoutePlanner.RouteSegment(rdo, isBegin ? 0 : rdo.getPointsLength() - 1);
                boolean bl = startRoad = ((RouteDataObject)((List)neighboringPoints.get((long)pointId)).get((int)0)).id == segment.getRoad().id;
                if (startRoad) {
                    int n = oneWay = isBegin ? 1 : -1;
                }
                if (oneWay >= 0) {
                    this.findNextPoint(true, segment, neighboringPoints, distFromStarts, queue, point, visited);
                }
                if (oneWay > 0) continue;
                this.findNextPoint(false, segment, neighboringPoints, distFromStarts, queue, point, visited);
            }
        }
    }

    private void findNextPoint(boolean direction, BinaryRoutePlanner.RouteSegment segment, TLongObjectHashMap<List<RouteDataObject>> neighboringPoints, Map<Long, Double> distFromStarts, PriorityQueue<Point> queue, Point point, TLongHashSet visited) {
        block2: {
            long foundPointId;
            int ind = segment.getSegmentStart();
            double startLat = (float)MapUtils.get31LongitudeX((int)segment.getRoad().getPoint31XTile(ind));
            double startLon = (float)MapUtils.get31LatitudeY((int)segment.getRoad().getPoint31YTile(ind));
            do {
                ind = direction ? ++ind : --ind;
                if (ind < 0 || ind >= segment.getRoad().getPointsLength()) break block2;
            } while (!neighboringPoints.contains(foundPointId = this.calcPointId(segment.getRoad(), ind)) || visited.contains(foundPointId));
            double endLat = (float)MapUtils.get31LongitudeX((int)segment.getRoad().getPoint31XTile(ind));
            double endLon = (float)MapUtils.get31LatitudeY((int)segment.getRoad().getPoint31YTile(ind));
            double dist = MapUtils.getDistance((double)startLon, (double)startLat, (double)endLon, (double)endLat) + point.distFromStart;
            if (dist < distFromStarts.get(foundPointId)) {
                distFromStarts.replace(this.calcPointId(segment.getRoad(), ind), dist);
            }
            queue.add(new Point(foundPointId, distFromStarts.get(foundPointId)));
        }
    }

    private List<RouteDataObject> findConnectedRoads(RoutingContext ctx, RouteDataObject initial, boolean begin, TLongObjectHashMap<List<RouteDataObject>> disconnectedPoints) {
        PriorityQueue<BinaryRoutePlanner.RouteSegment> queue = new PriorityQueue<BinaryRoutePlanner.RouteSegment>(10, Comparator.comparingDouble(BinaryRoutePlanner.RouteSegment::getDistanceFromStart));
        ArrayList<RouteDataObject> rdoToAdd = new ArrayList<RouteDataObject>();
        VehicleRouter router = ctx.getRouter();
        ArrayList next = new ArrayList();
        ctx.loadTileData(initial.getPoint31XTile(0), initial.getPoint31YTile(0), 15, next);
        for (RouteDataObject n : next) {
            if (n.id != initial.id) continue;
            initial = n;
            break;
        }
        queue.add(new BinaryRoutePlanner.RouteSegment(initial, begin ? 1 : initial.getPointsLength() - 2));
        TLongHashSet visited = new TLongHashSet();
        while (!queue.isEmpty()) {
            boolean startRoad;
            BinaryRoutePlanner.RouteSegment segment = queue.poll();
            int oneWay = router.isOneWay(segment.getRoad());
            boolean bl = startRoad = initial.id == segment.getRoad().id;
            if (startRoad) {
                int n = oneWay = begin ? -1 : 1;
            }
            if (oneWay >= 0) {
                this.processSegment(ctx, segment, queue, visited, disconnectedPoints, true, startRoad, initial, rdoToAdd);
            }
            if (oneWay > 0) continue;
            this.processSegment(ctx, segment, queue, visited, disconnectedPoints, false, startRoad, initial, rdoToAdd);
        }
        return rdoToAdd;
    }

    private List<RouteDataObject> findConnectedRoadsOld(RoutingContext ctx, RouteDataObject initial, boolean begin, TLongObjectHashMap<List<RouteDataObject>> all) {
        PriorityQueue<BinaryRoutePlanner.RouteSegment> queue = new PriorityQueue<BinaryRoutePlanner.RouteSegment>(10, Comparator.comparingDouble(BinaryRoutePlanner.RouteSegment::getDistanceFromStart));
        ArrayList<RouteDataObject> rdoToAdd = new ArrayList<RouteDataObject>();
        VehicleRouter router = ctx.getRouter();
        ArrayList next = new ArrayList();
        ctx.loadTileData(initial.getPoint31XTile(0), initial.getPoint31YTile(0), 17, next);
        for (RouteDataObject n : next) {
            if (n.id != initial.id) continue;
            initial = n;
            break;
        }
        queue.add(new BinaryRoutePlanner.RouteSegment(initial, begin ? 1 : initial.getPointsLength() - 2));
        TLongHashSet visited = new TLongHashSet();
        BinaryRoutePlanner.RouteSegment finalSegment = null;
        while (!queue.isEmpty() && finalSegment == null) {
            boolean startRoad;
            BinaryRoutePlanner.RouteSegment segment = queue.poll();
            int oneWay = router.isOneWay(segment.getRoad());
            boolean bl = startRoad = initial.id == segment.getRoad().id;
            if (startRoad) {
                int n = oneWay = begin ? -1 : 1;
            }
            if (oneWay >= 0) {
                finalSegment = this.processSegment(ctx, segment, queue, visited, all, true, startRoad, initial, rdoToAdd);
            }
            if (oneWay > 0 || finalSegment == null) continue;
            finalSegment = this.processSegment(ctx, segment, queue, visited, all, false, startRoad, initial, rdoToAdd);
        }
        if (finalSegment != null) {
            StringBuilder b = new StringBuilder("Route for " + initial.id + " : ");
            for (BinaryRoutePlanner.RouteSegment s = finalSegment; s != null; s = s.getParentRoute()) {
                if (s.getRoad().id == initial.id) continue;
                b.append(s.getRoad().id).append(", ");
                rdoToAdd.add(s.getRoad());
            }
            return rdoToAdd;
        }
        return Collections.emptyList();
    }

    private BinaryRoutePlanner.RouteSegment processSegment(RoutingContext ctx, BinaryRoutePlanner.RouteSegment segment, PriorityQueue<BinaryRoutePlanner.RouteSegment> queue, TLongHashSet visited, TLongObjectHashMap<List<RouteDataObject>> basePoints, boolean direction, boolean start, RouteDataObject initial, List<RouteDataObject> rdoToAdd) {
        int ind = segment.getSegmentStart();
        RouteDataObject road = segment.getRoad();
        long pid = this.calcPointIdUnique(segment.getRoad(), ind);
        if (visited.contains(pid)) {
            return null;
        }
        visited.add(pid);
        double distFromStart = segment.getDistanceFromStart();
        block0: while (true) {
            int py = road.getPoint31YTile(ind);
            int px = road.getPoint31XTile(ind);
            ind = direction ? ++ind : --ind;
            if (ind < 0 || ind >= segment.getRoad().getPointsLength()) break;
            if (basePoints.contains(this.calcPointId(segment.getRoad(), ind)) && !start) {
                return segment;
            }
            visited.add(this.calcPointIdUnique(segment.getRoad(), ind));
            int x = road.getPoint31XTile(ind);
            int y = road.getPoint31YTile(ind);
            float spd = ctx.getRouter().defineRoutingSpeed(road, direction) * ctx.getRouter().defineSpeedPriority(road, direction);
            if (spd > ctx.getRouter().getMaxSpeed()) {
                spd = ctx.getRouter().getMaxSpeed();
            }
            distFromStart += MapUtils.squareDist31TileMetric((int)px, (int)py, (int)x, (int)y) / (double)spd;
            BinaryRoutePlanner.RouteSegment rs = ctx.loadRouteSegment(x, y, 0L);
            while (true) {
                if (rs == null) continue block0;
                if (!(visited.contains(this.calcPointIdUnique(rs.getRoad(), rs.getSegmentStart())) || queue.contains(rs) && !((double)rs.getDistanceFromStart() > distFromStart))) {
                    rs.setDistanceFromStart((float)distFromStart);
                    rs.setParentRoute(segment);
                    queue.remove(rs);
                    queue.add(rs);
                }
                rs = rs.getNext();
            }
            break;
        }
        return null;
    }

    private long calcPointId(RouteDataObject rdo, int i) {
        return ((long)rdo.getPoint31XTile(i) << 31) + (long)rdo.getPoint31YTile(i);
    }

    private long calcPointIdUnique(RouteDataObject rdo, int i) {
        return (rdo.getId() << 20) + (long)i;
    }

    static class Point
    implements Comparator<Point> {
        public long pointId;
        public double distFromStart;

        public Point() {
        }

        public Point(long pointId, double distFromStart) {
            this.pointId = pointId;
            this.distFromStart = distFromStart;
        }

        @Override
        public int compare(Point point1, Point point2) {
            return Double.compare(point1.distFromStart, point2.distFromStart);
        }
    }
}

