/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.obf.preparation;

import gnu.trove.set.hash.TLongHashSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.osmand.data.Building;
import net.osmand.data.City;
import net.osmand.data.LatLon;
import net.osmand.obf.preparation.DBStreetDAO;
import net.osmand.osm.edit.Entity;
import net.osmand.osm.edit.Way;
import net.osmand.util.Algorithms;

public class CachedDBStreetDAO
extends DBStreetDAO {
    private Map<String, DBStreetDAO.SimpleStreet> addressStreetLocalMap = new HashMap<String, DBStreetDAO.SimpleStreet>();
    private TLongHashSet addressBuildingLocalSet = new TLongHashSet();
    private TLongHashSet addressStreetNodeLocalSet = new TLongHashSet();

    @Override
    public DBStreetDAO.SimpleStreet findStreet(String name, City city, String cityPart) {
        return this.addressStreetLocalMap.get(this.createStreetUniqueName(name, city.getId(), cityPart));
    }

    @Override
    public DBStreetDAO.SimpleStreet findStreet(String name, City city) {
        return this.addressStreetLocalMap.get(this.createStreetUniqueName(name, city.getId()));
    }

    private String createStreetUniqueName(String name, Long cityId, String cityPart) {
        return name + "_" + cityId + "_" + cityPart;
    }

    private String createStreetUniqueName(String name, Long cityId) {
        return name + "_" + cityId;
    }

    @Override
    protected void writeStreetWayNodes(Set<Long> streetId, Way way) throws SQLException {
        super.writeStreetWayNodes(streetId, way);
        this.addressStreetNodeLocalSet.add(way.getId());
    }

    @Override
    protected void writeBuilding(Set<Long> streetId, Building building) throws SQLException {
        super.writeBuilding(streetId, building);
        this.addressBuildingLocalSet.add(building.getId().longValue());
    }

    @Override
    public long insertStreet(String name, Map<String, String> names, LatLon location, City city, String cityPart) throws SQLException {
        String langs = this.constructLangs(names);
        long streetId = this.fillInsertStreetStatement(name, names, location, city, cityPart, langs);
        this.addBatch(this.addressStreetStat);
        DBStreetDAO.SimpleStreet ss = new DBStreetDAO.SimpleStreet(streetId, name, city.getId(), cityPart, location, langs, Algorithms.encodeMap(names));
        this.addressStreetLocalMap.put(this.createStreetUniqueName(name, city.getId(), cityPart), ss);
        this.addressStreetLocalMap.put(this.createStreetUniqueName(name, city.getId()), ss);
        return streetId;
    }

    @Override
    public DBStreetDAO.SimpleStreet updateStreetCityPart(DBStreetDAO.SimpleStreet street, String cityPart) throws SQLException {
        this.commit();
        DBStreetDAO.SimpleStreet updatedSS = super.updateStreetCityPart(street, cityPart);
        this.addressStreetLocalMap.put(this.createStreetUniqueName(street.getName(), street.getCityId()), updatedSS);
        this.addressStreetLocalMap.put(this.createStreetUniqueName(street.getName(), street.getCityId(), cityPart), updatedSS);
        return updatedSS;
    }

    @Override
    public DBStreetDAO.SimpleStreet updateStreetLangs(DBStreetDAO.SimpleStreet street, Map<String, String> newNames) throws SQLException {
        this.commit();
        DBStreetDAO.SimpleStreet updatedSS = super.updateStreetLangs(street, newNames);
        this.addressStreetLocalMap.put(this.createStreetUniqueName(street.getName(), street.getCityId()), updatedSS);
        this.addressStreetLocalMap.put(this.createStreetUniqueName(street.getName(), street.getCityId(), street.getCityPart()), updatedSS);
        return updatedSS;
    }

    @Override
    public boolean findBuilding(Entity e) {
        return this.addressBuildingLocalSet.contains(e.getId());
    }

    @Override
    public boolean removeBuilding(Entity e) throws SQLException {
        this.addressBuildingLocalSet.remove(e.getId());
        return super.removeBuilding(e);
    }

    @Override
    public boolean findStreetNode(Entity e) {
        return this.addressStreetNodeLocalSet.contains(e.getId());
    }
}

