/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.obf.diff;

import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import net.osmand.binary.BinaryMapDataObject;
import net.osmand.binary.BinaryMapRouteReaderAdapter;
import net.osmand.binary.MapZooms;
import net.osmand.binary.RouteDataObject;
import net.osmand.data.Amenity;
import net.osmand.data.TransportStop;
import net.osmand.map.OsmandRegions;
import net.osmand.map.WorldRegion;
import net.osmand.obf.diff.ObfFileInMemory;
import net.osmand.obf.preparation.IndexHeightData;
import net.osmand.osm.edit.Node;
import net.osmand.osm.edit.Way;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;

public class ObfRegionSplitter {
    public static void main(String[] args) throws IOException {
        if (args.length == 1 && args[0].equals("test")) {
            args = new String[]{"~/24_08_04_21_40.obf", "~/Desktop/split/", "", "_24_08_04_21_40"};
        }
        if (args.length <= 3) {
            System.err.println("Usage: <path_to_world_obf_diff> <path_to_result_folder> <subfolder_name> <file_suffix> --srtm=<folder with srtm>");
            return;
        }
        ObfRegionSplitter thisGenerator = new ObfRegionSplitter();
        thisGenerator.split(args);
    }

    private void split(String[] args) throws IOException {
        String srtmDataFolderUrl;
        File heightDir;
        String fileSuffix;
        File worldObf = new File(args[0]);
        File dir = new File(args[1]);
        String subFolder = args.length > 2 ? args[2] : "";
        String string = fileSuffix = args.length > 3 ? args[3] : "";
        if (!worldObf.exists()) {
            System.out.println("Incorrect file!");
            System.exit(1);
        }
        if (!dir.exists()) {
            dir.mkdir();
        }
        IndexHeightData heightData = null;
        if (args.length > 4 && args[4].startsWith("--srtm=") && (heightDir = new File(srtmDataFolderUrl = args[4].replace("--srtm=", ""))).exists()) {
            heightData = new IndexHeightData();
            heightData.setSrtmData(srtmDataFolderUrl, dir);
        }
        try {
            ObfFileInMemory fl = new ObfFileInMemory();
            fl.readObfFiles(Collections.singletonList(worldObf));
            OsmandRegions osmandRegions = new OsmandRegions();
            osmandRegions.prepareFile();
            osmandRegions.cacheAllCountries();
            Map<String, Map<MapZooms.MapZoomPair, TLongObjectHashMap<BinaryMapDataObject>>> regionsMapData = this.splitRegionMapData(fl, osmandRegions);
            Map<String, TLongObjectHashMap<RouteDataObject>> regionsRouteData = this.splitRegionRouteData(fl, osmandRegions, heightData);
            Map<String, TLongObjectHashMap<Map<String, Amenity>>> regionsPoiData = this.splitRegionPoiData(fl, osmandRegions);
            Map<String, TLongObjectHashMap<TransportStop>> regionsTransportData = this.splitRegionTransportData(fl, osmandRegions);
            TreeSet<String> regionNames = new TreeSet<String>();
            regionNames.addAll(regionsMapData.keySet());
            regionNames.addAll(regionsRouteData.keySet());
            regionNames.addAll(regionsPoiData.keySet());
            regionNames.addAll(regionsTransportData.keySet());
            for (String regionName : regionNames) {
                TLongObjectHashMap<TransportStop> stops;
                TLongObjectHashMap<Map<String, Amenity>> poi;
                TLongObjectHashMap<RouteDataObject> ro;
                File folder = new File(dir, regionName);
                if (!Algorithms.isEmpty((CharSequence)subFolder)) {
                    folder = new File(folder, subFolder);
                }
                folder.mkdirs();
                File result = new File(folder, Algorithms.capitalizeFirstLetter((String)regionName) + fileSuffix + ".obf.gz");
                ObfFileInMemory obf = new ObfFileInMemory();
                Map<MapZooms.MapZoomPair, TLongObjectHashMap<BinaryMapDataObject>> mp = regionsMapData.get(regionName);
                if (mp != null) {
                    for (MapZooms.MapZoomPair mzPair : mp.keySet()) {
                        obf.putMapObjects(mzPair, mp.get(mzPair).valueCollection(), true);
                    }
                }
                if ((ro = regionsRouteData.get(regionName)) != null) {
                    obf.putRoutingData(ro, true);
                }
                if ((poi = regionsPoiData.get(regionName)) != null) {
                    obf.putPoiData(poi, true);
                }
                if ((stops = regionsTransportData.get(regionName)) != null) {
                    Collection stopsCollection = stops.valueCollection();
                    obf.setTransportRoutes(fl.getTransportRoutes());
                    obf.putTransportStops(stopsCollection, true);
                }
                obf.updateTimestamp(fl.getTimestamp());
                obf.writeFile(result, true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private Map<String, TLongObjectHashMap<Map<String, Amenity>>> splitRegionPoiData(ObfFileInMemory fl, OsmandRegions osmandRegions) throws IOException {
        HashMap<String, TLongObjectHashMap<Map<String, Amenity>>> result = new HashMap<String, TLongObjectHashMap<Map<String, Amenity>>>();
        TLongObjectHashMap<Map<String, Amenity>> poiData = fl.getPoiObjects();
        for (Map objMap : poiData.valueCollection()) {
            Amenity obj = (Amenity)objMap.values().iterator().next();
            int x = MapUtils.get31TileNumberX((double)obj.getLocation().getLongitude());
            int y = MapUtils.get31TileNumberY((double)obj.getLocation().getLatitude());
            List l = osmandRegions.query(x, y);
            for (BinaryMapDataObject b : l) {
                if (!OsmandRegions.contain((BinaryMapDataObject)b, (int)x, (int)y)) continue;
                String dw = osmandRegions.getDownloadName(b);
                WorldRegion wr = osmandRegions.getRegionDataByDownloadName(dw);
                if (dw == null || wr == null || Algorithms.isEmpty((CharSequence)dw) || !wr.isRegionMapDownload() && !wr.isRegionRoadsDownload()) continue;
                TLongObjectHashMap mp = (TLongObjectHashMap)result.get(dw);
                if (mp == null) {
                    mp = new TLongObjectHashMap();
                    result.put(dw, (TLongObjectHashMap<Map<String, Amenity>>)mp);
                }
                mp.put(obj.getId().longValue(), (Object)objMap);
            }
        }
        return result;
    }

    private Map<String, TLongObjectHashMap<RouteDataObject>> splitRegionRouteData(ObfFileInMemory fl, OsmandRegions osmandRegions, IndexHeightData heightData) throws IOException {
        HashMap<String, TLongObjectHashMap<RouteDataObject>> result = new HashMap<String, TLongObjectHashMap<RouteDataObject>>();
        TLongObjectHashMap<RouteDataObject> routingData = fl.getRoutingData();
        long time = System.currentTimeMillis();
        int count = 0;
        Map<Integer, List<Long>> sortedMap = this.createSortedMap(routingData);
        for (List<Long> keys : sortedMap.values()) {
            for (long key : keys) {
                RouteDataObject obj = (RouteDataObject)routingData.get(key);
                if (this.isPossibleVandalism(obj)) continue;
                if (heightData != null) {
                    this.attachElevationData(obj, heightData);
                    ++count;
                }
                int x = obj.getPoint31XTile(0);
                int y = obj.getPoint31YTile(0);
                List l = osmandRegions.query(x, y);
                for (BinaryMapDataObject b : l) {
                    if (!OsmandRegions.contain((BinaryMapDataObject)b, (int)x, (int)y)) continue;
                    String dw = osmandRegions.getDownloadName(b);
                    WorldRegion wr = osmandRegions.getRegionDataByDownloadName(dw);
                    if (dw == null || wr == null || Algorithms.isEmpty((CharSequence)dw) || !wr.isRegionMapDownload() && !wr.isRegionRoadsDownload()) continue;
                    TLongObjectHashMap mp = (TLongObjectHashMap)result.get(dw);
                    if (mp == null) {
                        mp = new TLongObjectHashMap();
                        result.put(dw, (TLongObjectHashMap<RouteDataObject>)mp);
                    }
                    mp.put(obj.getId(), (Object)obj);
                }
            }
        }
        long t = (System.currentTimeMillis() - time) / 1000L;
        long p = t > 0L ? (long)count / t : (long)count;
        System.out.println("Attach elevation data to ROUTE DATA section.");
        System.out.println("Time total:" + t + " count:" + count + " per/sec:" + p);
        return result;
    }

    private Map<Integer, List<Long>> createSortedMap(TLongObjectHashMap<RouteDataObject> routingData) {
        HashMap<Integer, List<Long>> sortedMap = new HashMap<Integer, List<Long>>();
        for (long key : routingData.keys()) {
            List<Long> list;
            int id;
            RouteDataObject rdo = (RouteDataObject)routingData.get(key);
            if (rdo.getPointsLength() <= 0) continue;
            double lon = MapUtils.get31LongitudeX((int)rdo.getPoint31XTile(0));
            double lat = MapUtils.get31LatitudeY((int)rdo.getPoint31YTile(0));
            int lt = (int)lat;
            int ln = (int)lon;
            double lonDelta = lon - (double)ln;
            double latDelta = lat - (double)lt;
            if (lonDelta < 0.0) {
                --ln;
            }
            if (latDelta < 0.0) {
                --lt;
            }
            if (sortedMap.containsKey(id = IndexHeightData.getTileId(lt, ln))) {
                list = (List)sortedMap.get(id);
                list.add(key);
                continue;
            }
            list = new ArrayList<Long>();
            list.add(key);
            sortedMap.put(id, list);
        }
        return sortedMap;
    }

    private void attachElevationData(RouteDataObject obj, IndexHeightData heightData) {
        List nodes = new ArrayList<Node>();
        int id = 1;
        int i = 0;
        while (i < obj.getPointsLength()) {
            double lon = MapUtils.get31LongitudeX((int)obj.getPoint31XTile(i));
            double lat = MapUtils.get31LatitudeY((int)obj.getPoint31YTile(i));
            Node n = new Node(lat, lon, (long)id);
            nodes.add(n);
            ++i;
            ++id;
        }
        Way simpleWay = new Way(obj.getId(), nodes);
        ArrayList<String> removeAfterSrtm = new ArrayList<String>();
        for (int t : obj.getTypes()) {
            BinaryMapRouteReaderAdapter.RouteTypeRule type = (BinaryMapRouteReaderAdapter.RouteTypeRule)obj.region.routeEncodingRules.get(t);
            String tag = type.getTag();
            if (IndexHeightData.ELEVATION_TAGS.contains(tag)) {
                return;
            }
            simpleWay.putTag(tag, type.getValue());
            removeAfterSrtm.add(tag);
        }
        heightData.proccess(simpleWay);
        simpleWay.removeTags(removeAfterSrtm.toArray(new String[0]));
        if (simpleWay.getTags().size() > 0) {
            int[] types = Arrays.copyOf(obj.types, obj.types.length + simpleWay.getTags().size());
            int index = obj.types.length;
            for (Map.Entry entry : simpleWay.getTags().entrySet()) {
                String val;
                String tag = (String)entry.getKey();
                int ruleId = obj.region.searchRouteEncodingRule(tag, val = (String)entry.getValue());
                if (ruleId == -1) {
                    ruleId = obj.region.routeEncodingRules.size();
                    obj.region.initRouteEncodingRule(ruleId, tag, val);
                }
                types[index] = ruleId;
                ++index;
            }
            obj.types = types;
        }
        nodes = simpleWay.getNodes();
        for (int i2 = 0; i2 < obj.getPointsLength(); ++i2) {
            Node n = (Node)nodes.get(i2);
            Map tags = n.getTags();
            if (tags.size() == 0) continue;
            int ind = 0;
            int size = tags.size();
            if (obj.pointTypes != null && obj.pointTypes.length > i2 && obj.pointTypes[i2] != null && obj.pointTypes[i2].length > 0) {
                ind = obj.pointTypes[i2].length;
                obj.pointTypes[i2] = Arrays.copyOf(obj.pointTypes[i2], obj.pointTypes[i2].length + size);
            } else {
                obj.setPointTypes(i2, new int[size]);
            }
            for (Map.Entry entry : tags.entrySet()) {
                String val;
                String tag = (String)entry.getKey();
                int ruleId = obj.region.searchRouteEncodingRule(tag, val = (String)entry.getValue());
                if (ruleId == -1) {
                    ruleId = obj.region.routeEncodingRules.size();
                    obj.region.initRouteEncodingRule(ruleId, tag, val);
                }
                obj.pointTypes[i2][ind] = ruleId;
                ++ind;
            }
        }
    }

    private Map<String, TLongObjectHashMap<TransportStop>> splitRegionTransportData(ObfFileInMemory fl, OsmandRegions osmandRegions) throws IOException {
        HashMap<String, TLongObjectHashMap<TransportStop>> result = new HashMap<String, TLongObjectHashMap<TransportStop>>();
        TLongObjectHashMap<TransportStop> transportStops = fl.getTransportStops();
        for (TransportStop stop : transportStops.valueCollection()) {
            int x = stop.x31;
            int y = stop.y31;
            List l = osmandRegions.query(x, y);
            for (BinaryMapDataObject b : l) {
                if (!OsmandRegions.contain((BinaryMapDataObject)b, (int)x, (int)y)) continue;
                String dw = osmandRegions.getDownloadName(b);
                WorldRegion wr = osmandRegions.getRegionDataByDownloadName(dw);
                if (dw == null || wr == null || Algorithms.isEmpty((CharSequence)dw) || !wr.isRegionMapDownload() && !wr.isRegionRoadsDownload()) continue;
                TLongObjectHashMap mp = (TLongObjectHashMap)result.get(dw);
                if (mp == null) {
                    mp = new TLongObjectHashMap();
                    result.put(dw, (TLongObjectHashMap<TransportStop>)mp);
                }
                mp.put(stop.getId().longValue(), (Object)stop);
            }
        }
        return result;
    }

    private boolean isPossibleVandalism(BinaryMapDataObject b) {
        if ("ferry".equals(b.getTagValue("route"))) {
            return false;
        }
        for (int j = 1; j < b.getPointsLength(); ++j) {
            double dist = MapUtils.squareRootDist31((int)b.getPoint31XTile(j - 1), (int)b.getPoint31YTile(j - 1), (int)b.getPoint31XTile(j), (int)b.getPoint31YTile(j));
            if (!(dist > 500000.0)) continue;
            return true;
        }
        return false;
    }

    private boolean isPossibleVandalism(RouteDataObject b) {
        if ("ferry".equals(b.getRoute())) {
            return false;
        }
        for (int j = 1; j < b.getPointsLength(); ++j) {
            double dist = MapUtils.squareRootDist31((int)b.getPoint31XTile(j - 1), (int)b.getPoint31YTile(j - 1), (int)b.getPoint31XTile(j), (int)b.getPoint31YTile(j));
            if (!(dist > 500000.0)) continue;
            return true;
        }
        return false;
    }

    private Map<String, Map<MapZooms.MapZoomPair, TLongObjectHashMap<BinaryMapDataObject>>> splitRegionMapData(ObfFileInMemory allMapObjects, OsmandRegions osmandRegions) throws IOException {
        HashMap<String, Map<MapZooms.MapZoomPair, TLongObjectHashMap<BinaryMapDataObject>>> result = new HashMap<String, Map<MapZooms.MapZoomPair, TLongObjectHashMap<BinaryMapDataObject>>>();
        for (MapZooms.MapZoomPair p : allMapObjects.getZooms()) {
            TLongObjectHashMap<BinaryMapDataObject> objects = allMapObjects.get(p);
            for (BinaryMapDataObject obj : objects.valueCollection()) {
                if (this.isPossibleVandalism(obj)) continue;
                int x = obj.getPoint31XTile(0);
                int y = obj.getPoint31YTile(0);
                List l = osmandRegions.query(x, y);
                for (BinaryMapDataObject b : l) {
                    TLongObjectHashMap list;
                    if (!OsmandRegions.contain((BinaryMapDataObject)b, (int)x, (int)y)) continue;
                    String dw = osmandRegions.getDownloadName(b);
                    WorldRegion wr = osmandRegions.getRegionDataByDownloadName(dw);
                    if (dw == null || wr == null || Algorithms.isEmpty((CharSequence)dw) || !wr.isRegionMapDownload() && !wr.isRegionRoadsDownload()) continue;
                    LinkedHashMap<MapZooms.MapZoomPair, TLongObjectHashMap> mp = (LinkedHashMap<MapZooms.MapZoomPair, TLongObjectHashMap>)result.get(dw);
                    if (mp == null) {
                        mp = new LinkedHashMap<MapZooms.MapZoomPair, TLongObjectHashMap>();
                        result.put(dw, mp);
                    }
                    if ((list = (TLongObjectHashMap)mp.get(p)) == null) {
                        list = new TLongObjectHashMap();
                        mp.put(p, list);
                    }
                    list.put(obj.getId(), (Object)obj);
                }
            }
        }
        return result;
    }
}

