/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filter.internal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.ClassUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.util.ReflectionMethodUtils;
import org.xwiki.component.util.ReflectionUtils;
import org.xwiki.filter.FilterDescriptor;
import org.xwiki.filter.FilterDescriptorManager;
import org.xwiki.filter.FilterElementDescriptor;
import org.xwiki.filter.FilterElementParameterDescriptor;
import org.xwiki.filter.annotation.Default;
import org.xwiki.filter.annotation.Name;
import org.xwiki.filter.internal.CompositeFilter;
import org.xwiki.filter.internal.FilterProxy;
import org.xwiki.properties.ConverterManager;
import org.xwiki.properties.converter.ConversionException;

@Component
@Singleton
public class DefaultFilterDescriptorManager
implements FilterDescriptorManager {
    public static final String PREFIX_BEGIN = "begin";
    public static final String PREFIX_END = "end";
    public static final String PREFIX_ON = "on";
    private static final Class<?>[] CLASS_ARRAY = new Class[0];
    private Map<Class<?>, FilterDescriptor> descriptors = new ConcurrentHashMap();
    @Inject
    private ConverterManager converter;

    @Override
    public FilterDescriptor getFilterDescriptor(Class<?> ... interfaces) {
        FilterDescriptor totalDescriptor = null;
        for (Class<?> i : interfaces) {
            FilterDescriptor descriptor = this.descriptors.get(i);
            if (descriptor == null) {
                descriptor = this.createDescriptor(i);
                this.descriptors.put(i, descriptor);
            }
            if (totalDescriptor == null) {
                totalDescriptor = descriptor;
                continue;
            }
            totalDescriptor.add(descriptor);
        }
        return totalDescriptor;
    }

    private Method[] getMethods(Class<?> clazz) {
        return clazz.getMethods();
    }

    public static String getElementName(String methodName) {
        String elementName = methodName.startsWith(PREFIX_BEGIN) ? methodName.substring(PREFIX_BEGIN.length(), methodName.length()) : (methodName.startsWith(PREFIX_END) ? methodName.substring(PREFIX_END.length(), methodName.length()) : (methodName.startsWith(PREFIX_ON) ? methodName.substring(PREFIX_ON.length(), methodName.length()) : null));
        if (elementName != null) {
            elementName = Character.toLowerCase(elementName.charAt(0)) + elementName.substring(1, elementName.length());
        }
        return elementName;
    }

    private FilterDescriptor createDescriptor(Class<?> type) {
        FilterDescriptor descriptor = new FilterDescriptor();
        for (Method method : this.getMethods(type)) {
            String elementName = DefaultFilterDescriptorManager.getElementName(method.getName());
            if (elementName == null) continue;
            this.addElement(elementName, descriptor, method);
        }
        return descriptor;
    }

    private void addElement(String elementName, FilterDescriptor descriptor, Method method) {
        String lowerElementName = elementName.toLowerCase();
        FilterElementDescriptor element = descriptor.getElements().get(lowerElementName);
        Type[] methodTypes = method.getGenericParameterTypes();
        if (element == null || methodTypes.length > element.getParameters().length) {
            FilterElementParameterDescriptor[] parameters = new FilterElementParameterDescriptor[methodTypes.length];
            for (int i = 0; i < methodTypes.length; ++i) {
                parameters[i] = this.createFilterElementParameter(method, i, methodTypes[i]);
            }
            element = new FilterElementDescriptor(elementName, parameters);
            descriptor.getElements().put(lowerElementName, element);
        }
        this.addMethod(element, method);
    }

    private FilterElementParameterDescriptor<?> createFilterElementParameter(Method method, int index, Type type) {
        Object defaultValue;
        List nameAnnotations = ReflectionMethodUtils.getMethodParameterAnnotations((Method)method, (int)index, Name.class, (boolean)true);
        String name = !nameAnnotations.isEmpty() ? ((Name)nameAnnotations.get(0)).value() : null;
        List defaultAnnotations = ReflectionMethodUtils.getMethodParameterAnnotations((Method)method, (int)index, Default.class, (boolean)true);
        if (!defaultAnnotations.isEmpty()) {
            defaultValue = ((Default)defaultAnnotations.get(0)).value();
            if (defaultValue != null) {
                try {
                    defaultValue = this.converter.convert(type, defaultValue);
                }
                catch (ConversionException e) {
                    if (ReflectionUtils.getTypeClass((Type)type) == Map.class && ((String)defaultValue).isEmpty()) {
                        defaultValue = Collections.EMPTY_MAP;
                    }
                    throw e;
                }
            }
        } else {
            defaultValue = null;
        }
        return new FilterElementParameterDescriptor<String>(index, name, type, (String)defaultValue);
    }

    private void addMethod(FilterElementDescriptor element, Method method) {
        String methodName = method.getName();
        Type[] methodTypes = method.getGenericParameterTypes();
        if (methodName.startsWith(PREFIX_BEGIN)) {
            if (element.getBeginMethod() == null || element.getBeginMethod().getGenericParameterTypes().length < methodTypes.length) {
                element.setBeginMethod(method);
            }
        } else if (methodName.startsWith(PREFIX_END)) {
            if (element.getEndMethod() == null || element.getEndMethod().getGenericParameterTypes().length < methodTypes.length) {
                element.setEndMethod(method);
            }
        } else if (element.getOnMethod() == null || element.getOnMethod().getGenericParameterTypes().length < methodTypes.length) {
            element.setOnMethod(method);
        }
    }

    @Override
    public <F> F createFilterProxy(Object targetFilter, Class<?> ... interfaces) {
        return this.createFilterProxy(targetFilter, Thread.currentThread().getContextClassLoader(), interfaces);
    }

    @Override
    public <F> F createFilterProxy(Object targetFilter, ClassLoader loader, Class<?> ... interfaces) {
        for (Class<?> i : interfaces) {
            if (i.isInstance(targetFilter)) continue;
            return (F)Proxy.newProxyInstance(loader, interfaces, (InvocationHandler)new FilterProxy(targetFilter, this.getFilterDescriptor(interfaces)));
        }
        return (F)targetFilter;
    }

    @Override
    public <F> F createCompositeFilter(Object ... filters) {
        return this.createCompositeFilter(Thread.currentThread().getContextClassLoader(), filters);
    }

    @Override
    public <F> F createCompositeFilter(ClassLoader loader, Object ... filters) {
        HashSet interfaces = new HashSet();
        for (Object filter : filters) {
            interfaces.addAll(ClassUtils.getAllInterfaces(filter.getClass()));
        }
        return (F)Proxy.newProxyInstance(loader, interfaces.toArray(CLASS_ARRAY), (InvocationHandler)new CompositeFilter(this, filters));
    }
}

