/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.core.jni;

import net.osmand.core.jni.OsmAndCoreJNI;
import net.osmand.core.jni.TileId;

public class TileIdVector {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected TileIdVector(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(TileIdVector tileIdVector) {
        return tileIdVector == null ? 0L : tileIdVector.swigCPtr;
    }

    protected static long swigRelease(TileIdVector tileIdVector) {
        long l = 0L;
        if (tileIdVector != null) {
            if (!tileIdVector.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = tileIdVector.swigCPtr;
            tileIdVector.swigCMemOwn = false;
            tileIdVector.delete();
        }
        return l;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                OsmAndCoreJNI.delete_TileIdVector(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public TileIdVector() {
        this(OsmAndCoreJNI.new_TileIdVector__SWIG_0(), true);
    }

    public TileIdVector(long l) {
        this(OsmAndCoreJNI.new_TileIdVector__SWIG_1(l), true);
    }

    public long size() {
        return OsmAndCoreJNI.TileIdVector_size(this.swigCPtr, this);
    }

    public long capacity() {
        return OsmAndCoreJNI.TileIdVector_capacity(this.swigCPtr, this);
    }

    public void reserve(long l) {
        OsmAndCoreJNI.TileIdVector_reserve(this.swigCPtr, this, l);
    }

    public boolean isEmpty() {
        return OsmAndCoreJNI.TileIdVector_isEmpty(this.swigCPtr, this);
    }

    public void clear() {
        OsmAndCoreJNI.TileIdVector_clear(this.swigCPtr, this);
    }

    public void add(TileId tileId) {
        OsmAndCoreJNI.TileIdVector_add(this.swigCPtr, this, TileId.getCPtr(tileId), tileId);
    }

    public TileId get(int n) {
        return new TileId(OsmAndCoreJNI.TileIdVector_get(this.swigCPtr, this, n), false);
    }

    public void set(int n, TileId tileId) {
        OsmAndCoreJNI.TileIdVector_set(this.swigCPtr, this, n, TileId.getCPtr(tileId), tileId);
    }
}

