/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.core.jni;

import net.osmand.core.jni.AreaI;
import net.osmand.core.jni.LanguageId;
import net.osmand.core.jni.MapSymbol;
import net.osmand.core.jni.OsmAndCoreJNI;
import net.osmand.core.jni.PointI;
import net.osmand.core.jni.SWIGTYPE_p_sk_spT_SkImage_const_t;

public class RasterMapSymbol
extends MapSymbol {
    private transient long swigCPtr;
    private transient boolean swigCMemOwnDerived;

    protected RasterMapSymbol(long l, boolean bl) {
        super(OsmAndCoreJNI.RasterMapSymbol_SWIGSmartPtrUpcast(l), true);
        this.swigCMemOwnDerived = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(RasterMapSymbol rasterMapSymbol) {
        return rasterMapSymbol == null ? 0L : rasterMapSymbol.swigCPtr;
    }

    @Override
    protected void swigSetCMemOwn(boolean bl) {
        this.swigCMemOwnDerived = bl;
        super.swigSetCMemOwn(bl);
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwnDerived) {
                this.swigCMemOwnDerived = false;
                OsmAndCoreJNI.delete_RasterMapSymbol(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public void setImage(SWIGTYPE_p_sk_spT_SkImage_const_t sWIGTYPE_p_sk_spT_SkImage_const_t) {
        OsmAndCoreJNI.RasterMapSymbol_image_set(this.swigCPtr, this, SWIGTYPE_p_sk_spT_SkImage_const_t.getCPtr(sWIGTYPE_p_sk_spT_SkImage_const_t));
    }

    public SWIGTYPE_p_sk_spT_SkImage_const_t getImage() {
        return new SWIGTYPE_p_sk_spT_SkImage_const_t(OsmAndCoreJNI.RasterMapSymbol_image_get(this.swigCPtr, this), true);
    }

    public void setSize(PointI pointI) {
        OsmAndCoreJNI.RasterMapSymbol_size_set(this.swigCPtr, this, PointI.getCPtr(pointI), pointI);
    }

    public PointI getSize() {
        long l = OsmAndCoreJNI.RasterMapSymbol_size_get(this.swigCPtr, this);
        return l == 0L ? null : new PointI(l, false);
    }

    public void setContent(String string) {
        OsmAndCoreJNI.RasterMapSymbol_content_set(this.swigCPtr, this, string);
    }

    public String getContent() {
        return OsmAndCoreJNI.RasterMapSymbol_content_get(this.swigCPtr, this);
    }

    public void setLanguageId(LanguageId languageId) {
        OsmAndCoreJNI.RasterMapSymbol_languageId_set(this.swigCPtr, this, languageId.swigValue());
    }

    public LanguageId getLanguageId() {
        return LanguageId.swigToEnum(OsmAndCoreJNI.RasterMapSymbol_languageId_get(this.swigCPtr, this));
    }

    public void setMinDistance(float f) {
        OsmAndCoreJNI.RasterMapSymbol_minDistance_set(this.swigCPtr, this, f);
    }

    public float getMinDistance() {
        return OsmAndCoreJNI.RasterMapSymbol_minDistance_get(this.swigCPtr, this);
    }

    public void setMargin(AreaI areaI) {
        OsmAndCoreJNI.RasterMapSymbol_margin_set(this.swigCPtr, this, AreaI.getCPtr(areaI), areaI);
    }

    public AreaI getMargin() {
        long l = OsmAndCoreJNI.RasterMapSymbol_margin_get(this.swigCPtr, this);
        return l == 0L ? null : new AreaI(l, false);
    }

    public static RasterMapSymbol dynamic_pointer_cast(MapSymbol mapSymbol) {
        long l = OsmAndCoreJNI.RasterMapSymbol_dynamic_pointer_cast(MapSymbol.getCPtr(mapSymbol), mapSymbol);
        return l == 0L ? null : new RasterMapSymbol(l, true);
    }
}

