/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.core.jni;

import java.math.BigInteger;
import net.osmand.core.jni.ObfSectionInfo;
import net.osmand.core.jni.OsmAndCoreJNI;

public class ObfObjectId {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected ObfObjectId(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(ObfObjectId obfObjectId) {
        return obfObjectId == null ? 0L : obfObjectId.swigCPtr;
    }

    protected static long swigRelease(ObfObjectId obfObjectId) {
        long l = 0L;
        if (obfObjectId != null) {
            if (!obfObjectId.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = obfObjectId.swigCPtr;
            obfObjectId.swigCMemOwn = false;
            obfObjectId.delete();
        }
        return l;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                OsmAndCoreJNI.delete_ObfObjectId(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public void setId(BigInteger bigInteger) {
        OsmAndCoreJNI.ObfObjectId_id_set(this.swigCPtr, this, bigInteger);
    }

    public BigInteger getId() {
        return OsmAndCoreJNI.ObfObjectId_id_get(this.swigCPtr, this);
    }

    public static ObfObjectId invalidId() {
        return new ObfObjectId(OsmAndCoreJNI.ObfObjectId_invalidId(), true);
    }

    public boolean isOsmId() {
        return OsmAndCoreJNI.ObfObjectId_isOsmId(this.swigCPtr, this);
    }

    public long getOsmId() {
        return OsmAndCoreJNI.ObfObjectId_getOsmId(this.swigCPtr, this);
    }

    public boolean isShiftedID() {
        return OsmAndCoreJNI.ObfObjectId_isShiftedID(this.swigCPtr, this);
    }

    public boolean isIdFromRelation() {
        return OsmAndCoreJNI.ObfObjectId_isIdFromRelation(this.swigCPtr, this);
    }

    public boolean isIdFromSplit() {
        return OsmAndCoreJNI.ObfObjectId_isIdFromSplit(this.swigCPtr, this);
    }

    public long makeAmenityRightShift() {
        return OsmAndCoreJNI.ObfObjectId_makeAmenityRightShift(this.swigCPtr, this);
    }

    public String toString() {
        return OsmAndCoreJNI.ObfObjectId_toString(this.swigCPtr, this);
    }

    public static ObfObjectId generateUniqueId(BigInteger bigInteger, long l, ObfSectionInfo obfSectionInfo) {
        return new ObfObjectId(OsmAndCoreJNI.ObfObjectId_generateUniqueId__SWIG_0(bigInteger, l, ObfSectionInfo.getCPtr(obfSectionInfo), obfSectionInfo), true);
    }

    public static ObfObjectId generateUniqueId(long l, ObfSectionInfo obfSectionInfo) {
        return new ObfObjectId(OsmAndCoreJNI.ObfObjectId_generateUniqueId__SWIG_1(l, ObfSectionInfo.getCPtr(obfSectionInfo), obfSectionInfo), true);
    }

    public static ObfObjectId fromRawId(BigInteger bigInteger) {
        return new ObfObjectId(OsmAndCoreJNI.ObfObjectId_fromRawId(bigInteger), true);
    }

    public ObfObjectId() {
        this(OsmAndCoreJNI.new_ObfObjectId(), true);
    }
}

