/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.template;

import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.template.AbstractTemplateFunction;
import info.bliki.wiki.template.Expr;
import info.bliki.wiki.template.ITemplateFunction;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;

public class Formatnum
extends AbstractTemplateFunction {
    public static final ITemplateFunction CONST = new Formatnum();

    @Override
    public String parseFunction(List<String> list, IWikiModel model, char[] src, int beginIndex, int endIndex, boolean isSubst) {
        if (list.size() > 0) {
            String result;
            String string = result = isSubst ? list.get(0) : Formatnum.parseTrim(list.get(0), model);
            if (result.length() > 0) {
                try {
                    NumberFormat nf = NumberFormat.getNumberInstance(model.getLocale());
                    if (list.size() > 1 && list.get(1).equalsIgnoreCase("r")) {
                        Number num = nf.parse(result);
                        result = num instanceof Double ? Expr.getWikiNumberFormat(num.doubleValue(), model) : num.toString();
                    } else {
                        Double dbl = new Double(result);
                        if (result.endsWith(".")) {
                            DecimalFormat df = (DecimalFormat)DecimalFormat.getInstance(model.getLocale());
                            result = nf.format(dbl) + df.getDecimalFormatSymbols().getDecimalSeparator();
                        } else if (dbl == (double)dbl.intValue()) {
                            int idx = result.indexOf(46);
                            if (idx != -1) {
                                nf.setMinimumFractionDigits(result.length() - 1 - idx);
                            }
                            result = nf.format(dbl);
                        } else {
                            result = nf.format(dbl);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return result;
        }
        return null;
    }
}

