/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.api;

import info.bliki.wiki.model.WikiModel;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;

public class Console {
    public static final char[] NO_CHAR = new char[0];
    private static final int DEFAULT_READING_SIZE = 8192;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            String image = "http://en.wikipedia.org/wiki/${image}";
            String link = "http://en.wikipedia.org/wiki/${title}";
            String encoding = StandardCharsets.UTF_8.name();
            String top = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\r\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\">\n";
            String header = "<head>\n</head>\n<body>\n";
            String bottom = "\n</body></html>";
            if (args.length >= 1) {
                Properties prop = new Properties();
                prop.load(new FileInputStream(args[0]));
                String temp = prop.getProperty("image");
                if (temp != null) {
                    image = temp;
                }
                if ((temp = prop.getProperty("link")) != null) {
                    link = temp;
                }
                if ((temp = prop.getProperty("encoding")) != null) {
                    encoding = temp;
                }
                if ((temp = prop.getProperty("top")) != null) {
                    top = temp;
                }
                if ((temp = prop.getProperty("header")) != null) {
                    header = temp;
                }
                if ((temp = prop.getProperty("bottom")) != null) {
                    bottom = temp;
                }
            }
            if (args.length >= 3) {
                FileInputStream inStream = new FileInputStream(args[1]);
                FileOutputStream outStream = new FileOutputStream(args[2]);
                char[] wikiChars = Console.getInputStreamAsCharArray(inStream, -1, encoding);
                String wikiText = new String(wikiChars);
                WikiModel wikiModel = new WikiModel(image, link);
                String htmlStr = wikiModel.render(wikiText, false);
                StringBuffer buff = new StringBuffer();
                buff.append(top);
                buff.append(header);
                buff.append(htmlStr);
                buff.append(bottom);
                byte[] buffer = buff.toString().getBytes();
                outStream.write(buffer);
                inStream.close();
                outStream.close();
            } else {
                String s;
                BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
                while ((s = in.readLine()) != null && !s.equalsIgnoreCase("exit")) {
                    WikiModel wikiModel = new WikiModel(image, link);
                    try {
                        wikiModel.setUp();
                        String htmlStr = wikiModel.render(s, false);
                        System.out.print(htmlStr);
                    }
                    finally {
                        wikiModel.tearDown();
                    }
                }
                in.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static char[] getInputStreamAsCharArray(InputStream stream, int length, String encoding) throws IOException {
        char[] contents;
        InputStreamReader reader = null;
        InputStreamReader inputStreamReader = reader = encoding == null ? new InputStreamReader(stream) : new InputStreamReader(stream, encoding);
        if (length == -1) {
            contents = NO_CHAR;
            int contentsLength = 0;
            int amountRead = -1;
            do {
                int amountRequested;
                if (contentsLength + (amountRequested = Math.max(stream.available(), 8192)) > contents.length) {
                    char[] cArray = contents;
                    contents = new char[contentsLength + amountRequested];
                    System.arraycopy(cArray, 0, contents, 0, contentsLength);
                }
                if ((amountRead = reader.read(contents, contentsLength, amountRequested)) <= 0) continue;
                contentsLength += amountRead;
            } while (amountRead != -1);
            if (contentsLength < contents.length) {
                char[] cArray = contents;
                contents = new char[contentsLength];
                System.arraycopy(cArray, 0, contents, 0, contentsLength);
            }
        } else {
            contents = new char[length];
            int len = 0;
            int readSize = 0;
            while (readSize != -1 && len != length) {
                readSize = reader.read(contents, len += readSize, length - len);
            }
            if (len != length) {
                char[] cArray = contents;
                contents = new char[len];
                System.arraycopy(cArray, 0, contents, 0, len);
            }
        }
        return contents;
    }
}

