/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.osm;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.osmand.osm.RenderingPropertyAttr;

public class OsmRouteType {
    private static final List<OsmRouteType> values = new ArrayList<OsmRouteType>();
    public static final String DEFAULT_ICON = "special_marker";
    public static final String DEFAULT_COLOR = "orange";
    public static final OsmRouteType WATER = OsmRouteType.createType("water").color("yellow").icon("special_kayak").renderingPropertyAttr(RenderingPropertyAttr.WHITE_WATER_SPORTS).reg();
    public static final OsmRouteType WINTER = OsmRouteType.createType("winter").color("yellow").icon("special_skiing").reg();
    public static final OsmRouteType SNOWMOBILE = OsmRouteType.createType("snowmobile").color("yellow").icon("special_snowmobile").reg();
    public static final OsmRouteType RIDING = OsmRouteType.createType("riding").color("yellow").icon("special_horse").reg();
    public static final OsmRouteType RACING = OsmRouteType.createType("racing").color("yellow").icon("raceway").reg();
    public static final OsmRouteType MOUNTAINBIKE = OsmRouteType.createType("mountainbike").color("blue").icon("sport_cycling").reg();
    public static final OsmRouteType BICYCLE = OsmRouteType.createType("bicycle").renderingPropertyAttr(RenderingPropertyAttr.CYCLE_ROUTES).reg();
    public static final OsmRouteType DIRTBIKE = OsmRouteType.createType("dirtbike").renderingPropertyAttr(RenderingPropertyAttr.DIRTBIKE_ROUTES).reg();
    public static final OsmRouteType MTB = OsmRouteType.createType("mtb").renderingPropertyAttr(RenderingPropertyAttr.MTB_ROUTES).reg();
    public static final OsmRouteType CYCLING = OsmRouteType.createType("cycling").color("blue").icon("special_bicycle").reg();
    public static final OsmRouteType HIKING = OsmRouteType.createType("hiking").color("orange").icon("special_trekking").renderingPropertyAttr(RenderingPropertyAttr.HIKING_ROUTES).reg();
    public static final OsmRouteType RUNNING = OsmRouteType.createType("running").color("orange").icon("running").renderingPropertyAttr(RenderingPropertyAttr.RUNNING_ROUTES).reg();
    public static final OsmRouteType WALKING = OsmRouteType.createType("walking").color("orange").icon("special_walking").reg();
    public static final OsmRouteType OFFROAD = OsmRouteType.createType("offroad").color("yellow").icon("special_offroad").reg();
    public static final OsmRouteType MOTORBIKE = OsmRouteType.createType("motorbike").color("green").icon("special_motorcycle").reg();
    public static final OsmRouteType CAR = OsmRouteType.createType("car").color("green").icon("shop_car").reg();
    public static final OsmRouteType HORSE = OsmRouteType.createType("horse").renderingPropertyAttr(RenderingPropertyAttr.HORSE_ROUTES).reg();
    public static final OsmRouteType ROAD = OsmRouteType.createType("road").reg();
    public static final OsmRouteType DETOUR = OsmRouteType.createType("detour").reg();
    public static final OsmRouteType BUS = OsmRouteType.createType("bus").reg();
    public static final OsmRouteType CANOE = OsmRouteType.createType("canoe").reg();
    public static final OsmRouteType FERRY = OsmRouteType.createType("ferry").reg();
    public static final OsmRouteType FOOT = OsmRouteType.createType("foot").reg();
    public static final OsmRouteType LIGHT_RAIL = OsmRouteType.createType("light_rail").reg();
    public static final OsmRouteType RAILWAY = OsmRouteType.createType("railway").reg();
    public static final OsmRouteType SKI_ROUTES = OsmRouteType.createType("piste").renderingPropertyAttr(RenderingPropertyAttr.PISTE_ROUTES).reg();
    public static final OsmRouteType ALPINE = OsmRouteType.createType("alpine").renderingPropertyAttr(RenderingPropertyAttr.ALPINE_HIKING).reg();
    public static final OsmRouteType FITNESS = OsmRouteType.createType("fitness_trail").renderingPropertyAttr(RenderingPropertyAttr.FITNESS_TRAILS).reg();
    public static final OsmRouteType INLINE_SKATES = OsmRouteType.createType("inline_skates").reg();
    public static final OsmRouteType SUBWAY = OsmRouteType.createType("subway").reg();
    public static final OsmRouteType TRAIN = OsmRouteType.createType("train").reg();
    public static final OsmRouteType TRACKS = OsmRouteType.createType("tracks").reg();
    public static final OsmRouteType TRAM = OsmRouteType.createType("tram").reg();
    public static final OsmRouteType TROLLEYBUS = OsmRouteType.createType("trolleybus").reg();
    public static final OsmRouteType CLIMBING = OsmRouteType.createType("climbing").renderingPropertyAttr(RenderingPropertyAttr.CLIMBING_ROUTES).reg();
    public static final OsmRouteType UNKNOWN = OsmRouteType.createType("unknown").reg();
    private final String name;
    private final String tagPrefix;
    private String color;
    private String icon;
    private String renderingPropertyAttr;

    OsmRouteType(String name) {
        this.name = name;
        this.tagPrefix = "route_" + name + "_";
    }

    public String getName() {
        return this.name;
    }

    public String getColor() {
        return this.color;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getRenderingPropertyAttr() {
        return this.renderingPropertyAttr;
    }

    public String getTagPrefix() {
        return this.tagPrefix;
    }

    public static List<OsmRouteType> getAllValues() {
        return values;
    }

    public static OsmRouteType getOrCreateTypeFromName(String name) {
        for (OsmRouteType rat : values) {
            if (!rat.name.equalsIgnoreCase(name)) continue;
            return rat;
        }
        return OsmRouteType.createType(name.toLowerCase()).color(DEFAULT_COLOR).icon(DEFAULT_ICON).reg();
    }

    private static RouteActivityTypeBuilder createType(String name) {
        RouteActivityTypeBuilder builder = new RouteActivityTypeBuilder();
        builder.osmRouteType = new OsmRouteType(name);
        return builder;
    }

    public static OsmRouteType getTypeFromTags(String[] tags) {
        OsmRouteType activityType = null;
        for (String tg : tags) {
            OsmRouteType rat = OsmRouteType.convertFromOsmGPXTag(tg);
            if (rat == null || activityType != null && values.indexOf(activityType) <= values.indexOf(rat)) continue;
            activityType = rat;
        }
        return activityType;
    }

    public static OsmRouteType getTypeFromOSMTags(Map<String, String> tags) {
        String rt = tags.get("route");
        if (rt != null) {
            return OsmRouteType.convertFromOsmGPXTag(rt);
        }
        return null;
    }

    public static OsmRouteType convertFromOsmGPXTag(String tg) {
        String t = tg.toLowerCase();
        if ("mountain hiking".equalsIgnoreCase(t)) {
            return HIKING;
        }
        if ("motorcar".equalsIgnoreCase(t)) {
            return CAR;
        }
        if ("laufen".equalsIgnoreCase(t)) {
            return RUNNING;
        }
        if ("pedestrian".equalsIgnoreCase(t)) {
            return WALKING;
        }
        switch (t) {
            case "mountainbiking": 
            case "mtb": 
            case "mountainbike": 
            case "mountain bike": 
            case "mountain biking": 
            case "mountbarker": 
            case "mtb-tour": 
            case "ciclismo-mtb-gravel": 
            case "vtt": 
            case "btt": 
            case "vth": 
            case "mtb ride": 
            case "disused:mtb": 
            case "abandoned:mtb": 
            case "mtb:scale": {
                return MTB;
            }
            case "hiking": 
            case "route=hiking": 
            case "mountain hiking": 
            case "hiking trail": 
            case "wandern": 
            case "hike": 
            case "randonn\u00e9e": 
            case "trekking": 
            case "climbing": 
            case "ferrata": 
            case "via_ferrata": 
            case "proposed:hiking": 
            case "deprecated:hiking": 
            case "abandoned:hiking": 
            case "old_hiking": 
            case "canyoning": {
                return HIKING;
            }
            case "bike": 
            case "biking": 
            case "bicycling": 
            case "bicycle": 
            case "cycling": 
            case "cycle": 
            case "cycleway": 
            case "cykel": 
            case "handcycle": 
            case "cyclotourisme": 
            case "route=bicycle": 
            case "cyclotourism": 
            case "fietsen": 
            case "\u0432\u0435\u043b\u043e": 
            case "\u0432\u0435\u043b\u043e\u0441\u0438\u043f\u0435\u0434": 
            case "rower": 
            case "trasa rowerem": 
            case "v\u00e9lo": 
            case "velo": 
            case "radtour": 
            case "bici": 
            case "fiets": 
            case "fahrrad": 
            case "ncn": 
            case "icn": 
            case "lcn": 
            case "network=ncn": 
            case "network=icn": 
            case "network=lcn": 
            case "proposed:bicycle": 
            case "old_bicycle": {
                return CYCLING;
            }
            case "car": 
            case "motorcar": 
            case "by car": 
            case "auto": 
            case "\u0430\u0432\u0442\u043e\u043c\u043e\u0431\u0438\u043b\u044c": 
            case "automobile": 
            case "aut\u00f3s": 
            case "driving": 
            case "drive": 
            case "van": 
            case "\u0430\u0432\u0442\u043e": 
            case "\u043d\u0430 \u0430\u0432\u0442\u043e\u043c\u043e\u0431\u0438\u043b\u0435": 
            case "bus": 
            case "truck": 
            case "taxi": {
                return CAR;
            }
            case "running": 
            case "run": 
            case "rungis": 
            case "trail running": 
            case "trailrunning": 
            case "\u0431\u0435\u0433": 
            case "laufen": 
            case "langlauf": 
            case "lauf": 
            case "course": 
            case "jogging": 
            case "fitotrack": {
                return RUNNING;
            }
            case "wanderung": 
            case "walking": 
            case "walk": 
            case "nightwalk": 
            case "walkway": 
            case "\u043f\u0435\u0448\u043a\u043e\u043c": 
            case "\u043f\u0435\u0448\u0438\u0439": 
            case "p\u011b\u0161ky": 
            case "marche": 
            case "pedestrian": 
            case "foot": 
            case "footing": 
            case "on_foot": 
            case "byfoot": 
            case "onfoot": 
            case "sightseeing": 
            case "geocaching": 
            case "etnanatura": 
            case "etna": 
            case "iwn": 
            case "lwn": 
            case "rwn": 
            case "network=iwn": 
            case "network=lwn": 
            case "network=rwn": 
            case "unmarked:foot": 
            case "nordic_walking": {
                return WALKING;
            }
            case "ling-moto": 
            case "motorbiking": 
            case "motorcycle": 
            case "motorrad": 
            case "motorbike": 
            case "motor bike": 
            case "fvbike": {
                return MOTORBIKE;
            }
            case "offroad": 
            case "off-road": 
            case "off road": 
            case "4x4": 
            case "terrain": 
            case "quad": 
            case "enduro": 
            case "feldwege": 
            case "feldweg": 
            case "rally": {
                return OFFROAD;
            }
            case "boat": 
            case "water": 
            case "boating": 
            case "kayak": 
            case "river": 
            case "lake": 
            case "lakes": 
            case "canal": 
            case "waterway": 
            case "motorboat": 
            case "canoe": {
                return WATER;
            }
            case "ski": 
            case "skiing": 
            case "skating": 
            case "skitour": 
            case "winter": 
            case "wintersports": 
            case "snowboard": 
            case "\u043b\u044b\u0436\u0438": 
            case "\u043b\u044b\u0436\u043d\u044f": 
            case "nordic": 
            case "piste": 
            case "piste:type": 
            case "piste:difficulty": {
                return SKI_ROUTES;
            }
            case "snowmobile=designated": 
            case "snowmobile=permissive": 
            case "snowmobile=yes": 
            case "snowmobile": {
                return SNOWMOBILE;
            }
            case "ride": 
            case "horse": 
            case "horse trail": {
                return RIDING;
            }
            case "racing": {
                return RACING;
            }
            case "inline_skates": {
                return INLINE_SKATES;
            }
            case "fitness_trail": {
                return FITNESS;
            }
            case "dirtbike": 
            case "dirtbike:scale": {
                return DIRTBIKE;
            }
        }
        return null;
    }

    public static OsmRouteType getByTag(String tag) {
        for (OsmRouteType routeType : values) {
            if (!routeType.name.equals(tag)) continue;
            return routeType;
        }
        return null;
    }

    public static OsmRouteType getByRenderingProperty(String renderingProperty) {
        for (OsmRouteType routeType : values) {
            if (routeType.renderingPropertyAttr == null || !routeType.renderingPropertyAttr.equals(renderingProperty)) continue;
            return routeType;
        }
        return null;
    }

    public static class RouteActivityTypeBuilder {
        private OsmRouteType osmRouteType;

        public RouteActivityTypeBuilder color(String color) {
            this.osmRouteType.color = color;
            return this;
        }

        public RouteActivityTypeBuilder icon(String icon) {
            this.osmRouteType.icon = icon;
            return this;
        }

        public RouteActivityTypeBuilder renderingPropertyAttr(String propertyAttr) {
            this.osmRouteType.renderingPropertyAttr = propertyAttr;
            return this;
        }

        public RouteActivityTypeBuilder renderingPropertyAttr(RenderingPropertyAttr propertyAttr) {
            this.renderingPropertyAttr(propertyAttr.getAttrName());
            return this;
        }

        private OsmRouteType reg() {
            values.add(this.osmRouteType);
            return this.osmRouteType;
        }
    }
}

