/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.data;

import java.util.ArrayList;
import java.util.List;
import net.osmand.data.QuadRect;

public class QuadTree<T> {
    private float ratio;
    private int maxDepth;
    private Node<T> root;

    public QuadTree(QuadRect r, int depth, float ratio) {
        this.ratio = ratio;
        this.root = new Node(r);
        this.maxDepth = depth;
    }

    public void insert(T data, QuadRect box) {
        int depth = 0;
        this.doInsertData(data, box, this.root, depth);
    }

    public void clear() {
        this.clear(this.root);
    }

    private void clear(Node<T> rt) {
        if (rt != null) {
            if (rt.data != null) {
                rt.data.clear();
            }
            if (rt.children != null) {
                for (Node c : rt.children) {
                    this.clear(c);
                }
            }
        }
    }

    public void insert(T data, float x, float y) {
        this.insert(data, new QuadRect(x, y, x, y));
    }

    public List<T> queryInBox(QuadRect box, List<T> result) {
        result.clear();
        this.queryNode(box, result, this.root);
        return result;
    }

    private void queryNode(QuadRect box, List<T> result, Node<T> node) {
        if (node != null && QuadRect.intersects(box, node.bounds)) {
            if (node.data != null) {
                result.addAll(node.data);
            }
            for (int k = 0; k < 4; ++k) {
                this.queryNode(box, result, node.children[k]);
            }
        }
    }

    private void doInsertData(T data, QuadRect box, Node<T> n, int depth) {
        if (++depth >= this.maxDepth) {
            if (n.data == null) {
                n.data = new ArrayList();
            }
            n.data.add(data);
        } else {
            QuadRect[] ext = new QuadRect[4];
            this.splitBox(n.bounds, ext);
            for (int i = 0; i < 4; ++i) {
                if (!ext[i].contains(box)) continue;
                if (n.children[i] == null) {
                    n.children[i] = new Node(ext[i]);
                }
                this.doInsertData(data, box, n.children[i], depth);
                return;
            }
            if (n.data == null) {
                n.data = new ArrayList();
            }
            n.data.add(data);
        }
    }

    void splitBox(QuadRect node_extent, QuadRect[] n) {
        double lx = node_extent.left;
        double ly = node_extent.top;
        double hx = node_extent.right;
        double hy = node_extent.bottom;
        n[0] = new QuadRect(lx, ly, lx + (hx - lx) * (double)this.ratio, ly + (hy - ly) * (double)this.ratio);
        n[1] = new QuadRect(lx + (hx - lx) * (double)(1.0f - this.ratio), ly, hx, ly + (hy - ly) * (double)this.ratio);
        n[2] = new QuadRect(lx, ly + (hy - ly) * (double)(1.0f - this.ratio), lx + (hx - lx) * (double)this.ratio, hy);
        n[3] = new QuadRect(lx + (hx - lx) * (double)(1.0f - this.ratio), ly + (hy - ly) * (double)(1.0f - this.ratio), hx, hy);
    }

    public boolean checkIntersection(QuadRect bbox, int hintDepth, QuadTreeItemInQuadRect<T> contains) {
        if (hintDepth != -1 && hintDepth > this.maxDepth) {
            hintDepth = -1;
        }
        return this.checkIntersectionRecursive(bbox, this.root, 0, hintDepth, contains);
    }

    private boolean checkIntersectionRecursive(QuadRect bbox, Node<T> node, int currentDepth, int targetDepth, QuadTreeItemInQuadRect<T> contains) {
        if (node == null || !QuadRect.intersects(bbox, node.bounds)) {
            return false;
        }
        if (targetDepth != -1) {
            if (currentDepth == targetDepth) {
                return true;
            }
            if (currentDepth > targetDepth) {
                return false;
            }
        }
        if (node.data != null) {
            for (Object item : node.data) {
                if (!contains.contains(bbox, item)) continue;
                return true;
            }
        }
        for (int i = 0; i < 4; ++i) {
            if (!this.checkIntersectionRecursive(bbox, node.children[i], currentDepth + 1, targetDepth, contains)) continue;
            return true;
        }
        return false;
    }

    private static class Node<T> {
        List<T> data = null;
        Node<T>[] children = null;
        QuadRect bounds;

        private Node(QuadRect b) {
            this.bounds = new QuadRect(b.left, b.top, b.right, b.bottom);
            this.children = new Node[4];
        }
    }

    public static interface QuadTreeItemInQuadRect<T> {
        public boolean contains(QuadRect var1, T var2);
    }
}

