/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.binary;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.osmand.binary.BinaryIndexPart;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.util.Algorithms;

public class BinaryMapIndexReaderStats {

    public static class MapObjectStat {
        public int lastStringNamesSize;
        public int lastObjectIdSize;
        public int lastObjectHeaderInfo;
        public int lastObjectAdditionalTypes;
        public int lastObjectTypes;
        public int lastObjectCoordinates;
        public int lastObjectLabelCoordinates;
        public int lastObjectSize;
        public int lastBlockStringTableSize;
        public int lastBlockHeaderInfo;

        public void addBlockHeader(int typesFieldNumber, int sizeL) {
            this.lastBlockHeaderInfo += CodedOutputStream.computeTagSize(typesFieldNumber) + CodedOutputStream.computeRawVarint32Size(sizeL);
        }

        public void addTagHeader(int typesFieldNumber, int sizeL) {
            this.lastObjectHeaderInfo += CodedOutputStream.computeTagSize(typesFieldNumber) + CodedOutputStream.computeRawVarint32Size(sizeL);
        }

        public void clearObjectStats() {
            this.lastStringNamesSize = 0;
            this.lastObjectIdSize = 0;
            this.lastObjectHeaderInfo = 0;
            this.lastObjectAdditionalTypes = 0;
            this.lastObjectTypes = 0;
            this.lastObjectCoordinates = 0;
            this.lastObjectLabelCoordinates = 0;
        }
    }

    public static class SearchStat {
        long lastReq = 0L;
        public long totalTime = 0L;
        public long totalBytes = 0L;
        public int prevResultsSize = 0;
        public String requestWord = "";
        Map<BinaryMapIndexReaderApiName, StatByAPI> byApis = new HashMap<BinaryMapIndexReaderApiName, StatByAPI>();
        Map<String, Map<String, Integer>> wordByTypeCounts = new HashMap<String, Map<String, Integer>>();

        public long beginSearchStats(BinaryMapIndexReaderApiName api, BinaryMapIndexReader.SearchRequest<?> req, BinaryIndexPart part, CodedInputStream codedIS, String extraInfo) {
            this.lastReq = System.nanoTime();
            codedIS.resetBytesCounter();
            this.prevResultsSize = req != null && req.getSearchResults() != null ? req.getSearchResults().size() : 0;
            this.requestWord = req != null && !Algorithms.isEmpty(req.nameQuery) ? req.nameQuery : "";
            return this.lastReq;
        }

        public void endSearchStats(long statReq, BinaryMapIndexReaderApiName api, List<?> objects, BinaryIndexPart part, CodedInputStream codedIS, String extraInfo) {
            if (statReq != this.lastReq) {
                System.err.println("ERROR: in stats counting to fix ! " + statReq + " != " + this.lastReq);
            }
            if (!Algorithms.isEmpty(this.requestWord)) {
                Map mapByType = this.wordByTypeCounts.computeIfAbsent(this.requestWord, k -> new HashMap());
                for (Object o : objects) {
                    mapByType.compute(o.getClass().getSimpleName(), (k, cnt) -> cnt == null ? 1 : cnt + 1);
                }
            }
            long timeCall = System.nanoTime() - statReq;
            long bytes = codedIS.getBytesCounter();
            this.totalTime += timeCall;
            this.totalBytes += bytes;
            StatByAPI statByAPI = this.byApis.get((Object)api);
            if (statByAPI == null) {
                statByAPI = new StatByAPI();
                statByAPI.api = api;
                this.byApis.put(api, statByAPI);
            }
            statByAPI.bytes += bytes;
            ++statByAPI.calls;
            statByAPI.time += timeCall;
        }

        public String toString() {
            return String.format("Search stat: time %.3f, bytes %,d KB, by apis - %s", (double)this.totalTime / 1.0E9, this.totalBytes / 1024L, this.byApis.values());
        }
    }

    private static class StatByAPI {
        BinaryMapIndexReaderApiName api;
        int calls;
        long time;
        long bytes;

        private StatByAPI() {
        }

        public String toString() {
            return String.format("API %s [call %d, time %.2f, %,d KB]", new Object[]{this.api, this.calls, (double)this.time / 1.0E9, this.bytes / 1024L});
        }
    }

    public static enum BinaryMapIndexReaderApiName {
        ADDRESS_BY_NAME,
        POI_BY_NAME,
        LOAD_STREETS,
        LOAD_CITIES,
        LOAD_BUILDINGS,
        POI_BY_TYPE;

    }
}

