/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.io;

import java.io.IOException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lnet/osmand/shared/io/SourceInputStream;", "Ljava/io/InputStream;", "source", "Lokio/Source;", "<init>", "(Lokio/Source;)V", "bufferedSource", "Lokio/BufferedSource;", "read", "", "b", "", "off", "len", "close", "", "OsmAnd-shared"})
public final class SourceInputStream
extends InputStream {
    @NotNull
    private final BufferedSource bufferedSource;

    public SourceInputStream(@NotNull Source source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.bufferedSource = Okio.buffer((Source)source);
    }

    @Override
    public int read() throws IOException {
        return this.bufferedSource.exhausted() ? -1 : this.bufferedSource.readByte() & 0xFF;
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) throws IOException {
        int bytesRead;
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return this.bufferedSource.exhausted() ? -1 : ((bytesRead = this.bufferedSource.read(b, off, len)) != 0 ? bytesRead : -1);
    }

    @Override
    public void close() throws IOException {
        this.bufferedSource.close();
    }
}

