/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.gpx.filters;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import net.osmand.shared.settings.enums.AltitudeMetrics;
import net.osmand.shared.settings.enums.MetricsConstants;
import net.osmand.shared.util.Localization;
import net.osmand.shared.util.OsmAndFormatter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\r\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0015\u001a\u00020\u000fH\u0002J\b\u0010\u0016\u001a\u00020\u000fH\u0002J\b\u0010\u0017\u001a\u00020\u000fH\u0002J\b\u0010\u0018\u001a\u00020\u000fH\u0002J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000fj\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u001e"}, d2={"Lnet/osmand/shared/gpx/filters/MeasureUnitType;", "", "<init>", "(Ljava/lang/String;I)V", "TIME_DURATION", "DATE", "SPEED", "ALTITUDE", "DISTANCE", "ROTATIONS", "POWER", "TEMPERATURE", "BPM", "NONE", "getFilterUnitText", "", "mc", "Lnet/osmand/shared/settings/enums/MetricsConstants;", "am", "Lnet/osmand/shared/settings/enums/AltitudeMetrics;", "getDistanceUnits", "getPowerUnits", "getTemperatureUnits", "getBPMUnits", "getRotationUnits", "getSpeedUnits", "getAltitudeUnits", "getBaseValueFromFormatted", "", "value", "OsmAnd-shared"})
public final class MeasureUnitType
extends Enum<MeasureUnitType> {
    public static final /* enum */ MeasureUnitType TIME_DURATION = new MeasureUnitType();
    public static final /* enum */ MeasureUnitType DATE = new MeasureUnitType();
    public static final /* enum */ MeasureUnitType SPEED = new MeasureUnitType();
    public static final /* enum */ MeasureUnitType ALTITUDE = new MeasureUnitType();
    public static final /* enum */ MeasureUnitType DISTANCE = new MeasureUnitType();
    public static final /* enum */ MeasureUnitType ROTATIONS = new MeasureUnitType();
    public static final /* enum */ MeasureUnitType POWER = new MeasureUnitType();
    public static final /* enum */ MeasureUnitType TEMPERATURE = new MeasureUnitType();
    public static final /* enum */ MeasureUnitType BPM = new MeasureUnitType();
    public static final /* enum */ MeasureUnitType NONE = new MeasureUnitType();
    private static final /* synthetic */ MeasureUnitType[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    @NotNull
    public final String getFilterUnitText(@NotNull MetricsConstants mc, @NotNull AltitudeMetrics am) {
        Intrinsics.checkNotNullParameter((Object)((Object)mc), (String)"mc");
        Intrinsics.checkNotNullParameter((Object)((Object)am), (String)"am");
        String unitResId = switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 1 -> Localization.INSTANCE.getString("shared_string_minute_lowercase");
            case 2 -> this.getDistanceUnits(mc);
            case 3 -> this.getAltitudeUnits(am);
            case 4 -> this.getSpeedUnits(mc);
            case 5 -> this.getTemperatureUnits();
            case 6 -> this.getRotationUnits();
            case 7 -> this.getBPMUnits();
            case 8 -> this.getPowerUnits();
            default -> "";
        };
        return unitResId;
    }

    private final String getDistanceUnits(MetricsConstants mc) {
        return switch (WhenMappings.$EnumSwitchMapping$1[mc.ordinal()]) {
            case 1, 2, 3 -> Localization.INSTANCE.getString("mile");
            case 4, 5 -> Localization.INSTANCE.getString("nm");
            case 6 -> Localization.INSTANCE.getString("km");
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final String getPowerUnits() {
        return Localization.INSTANCE.getString("power_watts_unit");
    }

    private final String getTemperatureUnits() {
        return Localization.INSTANCE.getString("degree_celsius");
    }

    private final String getBPMUnits() {
        return Localization.INSTANCE.getString("beats_per_minute_short");
    }

    private final String getRotationUnits() {
        return Localization.INSTANCE.getString("revolutions_per_minute_unit");
    }

    private final String getSpeedUnits(MetricsConstants mc) {
        return switch (WhenMappings.$EnumSwitchMapping$1[mc.ordinal()]) {
            case 1, 2, 3 -> Localization.INSTANCE.getString("mile_per_hour");
            case 4, 5 -> Localization.INSTANCE.getString("nm_h");
            case 6 -> Localization.INSTANCE.getString("km_h");
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final String getAltitudeUnits(AltitudeMetrics am) {
        boolean useFeet = am.shouldUseFeet();
        return useFeet ? Localization.INSTANCE.getString("foot") : Localization.INSTANCE.getString("m");
    }

    public final float getBaseValueFromFormatted(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 4 -> OsmAndFormatter.INSTANCE.convertSpeedToMetersPerSecond(Float.parseFloat(value));
            case 3 -> OsmAndFormatter.INSTANCE.getMetersFromFormattedAltitudeValue(Float.parseFloat(value));
            case 2 -> OsmAndFormatter.INSTANCE.convertToMeters(Float.parseFloat(value));
            case 1 -> Float.parseFloat(value) * (float)1000 * (float)60;
            default -> Float.parseFloat(value);
        };
    }

    public static MeasureUnitType[] values() {
        return (MeasureUnitType[])$VALUES.clone();
    }

    public static MeasureUnitType valueOf(String value) {
        return Enum.valueOf(MeasureUnitType.class, value);
    }

    @NotNull
    public static EnumEntries<MeasureUnitType> getEntries() {
        return $ENTRIES;
    }

    static {
        $VALUES = measureUnitTypeArray = new MeasureUnitType[]{MeasureUnitType.TIME_DURATION, MeasureUnitType.DATE, MeasureUnitType.SPEED, MeasureUnitType.ALTITUDE, MeasureUnitType.DISTANCE, MeasureUnitType.ROTATIONS, MeasureUnitType.POWER, MeasureUnitType.TEMPERATURE, MeasureUnitType.BPM, MeasureUnitType.NONE};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[MeasureUnitType.values().length];
            try {
                nArray[MeasureUnitType.TIME_DURATION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MeasureUnitType.DISTANCE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MeasureUnitType.ALTITUDE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MeasureUnitType.SPEED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MeasureUnitType.TEMPERATURE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MeasureUnitType.ROTATIONS.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MeasureUnitType.BPM.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MeasureUnitType.POWER.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[MetricsConstants.values().length];
            try {
                nArray[MetricsConstants.MILES_AND_METERS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetricsConstants.MILES_AND_FEET.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetricsConstants.MILES_AND_YARDS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetricsConstants.NAUTICAL_MILES_AND_FEET.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetricsConstants.NAUTICAL_MILES_AND_METERS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetricsConstants.KILOMETERS_AND_METERS.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

