/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.gpx;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.osmand.shared.gpx.GpxDataItem;
import net.osmand.shared.gpx.GpxFile;
import net.osmand.shared.gpx.GpxHelper;
import net.osmand.shared.io.KFile;
import net.osmand.shared.util.Localization;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ\b\u0010\u0019\u001a\u0004\u0018\u00010\u0003J\b\u0010\u001d\u001a\u00020\nH\u0016J\u0013\u0010\u001e\u001a\u00020\u001b2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010 \u001a\u00020!H\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001c\u00a8\u0006\""}, d2={"Lnet/osmand/shared/gpx/TrackItem;", "", "file", "Lnet/osmand/shared/io/KFile;", "<init>", "(Lnet/osmand/shared/io/KFile;)V", "gpxFile", "Lnet/osmand/shared/gpx/GpxFile;", "(Lnet/osmand/shared/gpx/GpxFile;)V", "name", "", "getName", "()Ljava/lang/String;", "path", "getPath", "lastModified", "", "getLastModified", "()J", "dataItem", "Lnet/osmand/shared/gpx/GpxDataItem;", "getDataItem", "()Lnet/osmand/shared/gpx/GpxDataItem;", "setDataItem", "(Lnet/osmand/shared/gpx/GpxDataItem;)V", "getFile", "isShowCurrentTrack", "", "()Z", "toString", "equals", "other", "hashCode", "", "OsmAnd-shared"})
public final class TrackItem {
    @NotNull
    private final String name;
    @NotNull
    private final String path;
    @Nullable
    private final KFile file;
    private final long lastModified;
    @Nullable
    private GpxDataItem dataItem;

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    public final long getLastModified() {
        return this.lastModified;
    }

    @Nullable
    public final GpxDataItem getDataItem() {
        return this.dataItem;
    }

    public final void setDataItem(@Nullable GpxDataItem gpxDataItem) {
        this.dataItem = gpxDataItem;
    }

    public TrackItem(@NotNull KFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.file = file;
        this.path = file.absolutePath();
        this.name = GpxHelper.INSTANCE.getGpxTitle(file.name());
        this.lastModified = file.lastModified();
    }

    public TrackItem(@NotNull GpxFile gpxFile) {
        Intrinsics.checkNotNullParameter((Object)gpxFile, (String)"gpxFile");
        if (gpxFile.getShowCurrentTrack()) {
            this.file = null;
            this.path = gpxFile.getPath();
            this.name = Localization.INSTANCE.getString("shared_string_currently_recording_track");
            this.lastModified = gpxFile.getModifiedTime();
        } else {
            this.file = new KFile(gpxFile.getPath());
            this.path = this.file.absolutePath();
            this.name = GpxHelper.INSTANCE.getGpxTitle(this.file.name());
            this.lastModified = this.file.lastModified();
        }
    }

    @Nullable
    public final KFile getFile() {
        return this.file;
    }

    public final boolean isShowCurrentTrack() {
        return this.file == null;
    }

    @NotNull
    public String toString() {
        return this.name;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        TrackItem trackItem = (TrackItem)other;
        KFile kFile = this.file;
        return kFile != null ? kFile.equals(trackItem.file) : false;
    }

    public int hashCode() {
        KFile kFile = this.file;
        return kFile != null ? kFile.hashCode() : super.hashCode();
    }
}

