/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.gpx;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.osmand.shared.api.OsmAndContext;
import net.osmand.shared.io.KFile;
import net.osmand.shared.util.KAlgorithms;
import net.osmand.shared.util.Localization;
import net.osmand.shared.util.PlatformUtil;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005J\u0016\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\n\u00a8\u0006\u000f"}, d2={"Lnet/osmand/shared/gpx/GpxHelper;", "", "<init>", "()V", "getGpxTitle", "", "name", "getGpxDirTitle", "getFolderName", "dir", "Lnet/osmand/shared/io/KFile;", "includeParentDir", "", "isGpxFile", "file", "OsmAnd-shared"})
public final class GpxHelper {
    @NotNull
    public static final GpxHelper INSTANCE = new GpxHelper();

    private GpxHelper() {
    }

    @NotNull
    public final String getGpxTitle(@Nullable String name) {
        String string = KFile.Companion.getFileNameWithoutExtension(name);
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Nullable
    public final String getGpxDirTitle(@Nullable String name) {
        return KAlgorithms.INSTANCE.isEmpty(name) ? "" : KAlgorithms.INSTANCE.capitalizeFirstLetter(KFile.Companion.getFileNameWithoutExtension(name));
    }

    @NotNull
    public final String getFolderName(@NotNull KFile dir, boolean includeParentDir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Object name = dir.name();
        OsmAndContext osmandCtx = PlatformUtil.INSTANCE.getOsmAndContext();
        if (Intrinsics.areEqual((Object)osmandCtx.getGpxDir().name(), (Object)((String)name + Path.DIRECTORY_SEPARATOR))) {
            return Localization.INSTANCE.getString("shared_string_tracks");
        }
        String dirPath = dir.path() + Path.DIRECTORY_SEPARATOR;
        if (StringsKt.endsWith$default((String)dirPath, (String)osmandCtx.getGpxImportDir().name(), (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)dirPath, (String)osmandCtx.getGpxRecordedDir().name(), (boolean)false, (int)2, null)) {
            String string = KAlgorithms.INSTANCE.capitalizeFirstLetter((String)name);
            if (string == null) {
                string = "";
            }
            return string;
        }
        if (includeParentDir) {
            Object parentName;
            KFile parent = dir.getParentFile();
            Object object = parent;
            if (object == null || (object = ((KFile)object).name()) == null) {
                object = "";
            }
            if (!KAlgorithms.INSTANCE.isEmpty((CharSequence)(parentName = object)) && !Intrinsics.areEqual((Object)osmandCtx.getGpxDir().name(), (Object)((String)parentName + Path.DIRECTORY_SEPARATOR))) {
                name = (String)parentName + Path.DIRECTORY_SEPARATOR + (String)name;
            }
            return name;
        }
        return name;
    }

    public final boolean isGpxFile(@NotNull KFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return StringsKt.endsWith$default((String)string, (String)".gpx", (boolean)false, (int)2, null);
    }
}

