/*
 * Decompiled with CFR 0.152.
 */
package io.github.cosinekitty.astronomy;

import io.github.cosinekitty.astronomy.Astronomy;
import io.github.cosinekitty.astronomy.Refraction;
import io.github.cosinekitty.astronomy.Time;
import io.github.cosinekitty.astronomy.Vector;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u001e"}, d2={"Lio/github/cosinekitty/astronomy/Spherical;", "", "lat", "", "lon", "dist", "<init>", "(DDD)V", "getLat", "()D", "getLon", "getDist", "toVector", "Lio/github/cosinekitty/astronomy/Vector;", "time", "Lio/github/cosinekitty/astronomy/Time;", "toVectorFromHorizon", "refraction", "Lio/github/cosinekitty/astronomy/Refraction;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "OsmAnd-shared"})
public final class Spherical {
    private final double lat;
    private final double lon;
    private final double dist;

    public Spherical(double lat, double lon, double dist) {
        this.lat = lat;
        this.lon = lon;
        this.dist = dist;
    }

    public final double getLat() {
        return this.lat;
    }

    public final double getLon() {
        return this.lon;
    }

    public final double getDist() {
        return this.dist;
    }

    @NotNull
    public final Vector toVector(@NotNull Time time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        double radlat = Astronomy.degreesToRadians(this.lat);
        double radlon = Astronomy.degreesToRadians(this.lon);
        double rcoslat = this.dist * Math.cos(radlat);
        return new Vector(rcoslat * Math.cos(radlon), rcoslat * Math.sin(radlon), this.dist * Math.sin(radlat), time);
    }

    @NotNull
    public final Vector toVectorFromHorizon(@NotNull Time time, @NotNull Refraction refraction) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Intrinsics.checkNotNullParameter((Object)((Object)refraction), (String)"refraction");
        return new Spherical(this.lat + Astronomy.inverseRefractionAngle(refraction, this.lat), Astronomy.access$toggleAzimuthDirection(this.lon), this.dist).toVector(time);
    }

    public final double component1() {
        return this.lat;
    }

    public final double component2() {
        return this.lon;
    }

    public final double component3() {
        return this.dist;
    }

    @NotNull
    public final Spherical copy(double lat, double lon, double dist) {
        return new Spherical(lat, lon, dist);
    }

    public static /* synthetic */ Spherical copy$default(Spherical spherical, double d, double d2, double d3, int n, Object object) {
        if ((n & 1) != 0) {
            d = spherical.lat;
        }
        if ((n & 2) != 0) {
            d2 = spherical.lon;
        }
        if ((n & 4) != 0) {
            d3 = spherical.dist;
        }
        return spherical.copy(d, d2, d3);
    }

    @NotNull
    public String toString() {
        return "Spherical(lat=" + this.lat + ", lon=" + this.lon + ", dist=" + this.dist + ")";
    }

    public int hashCode() {
        int result = Double.hashCode(this.lat);
        result = result * 31 + Double.hashCode(this.lon);
        result = result * 31 + Double.hashCode(this.dist);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Spherical)) {
            return false;
        }
        Spherical spherical = (Spherical)other;
        if (Double.compare(this.lat, spherical.lat) != 0) {
            return false;
        }
        if (Double.compare(this.lon, spherical.lon) != 0) {
            return false;
        }
        return Double.compare(this.dist, spherical.dist) == 0;
    }
}

