/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.osmand.PlatformUtil;
import net.osmand.map.TileSourceManager;
import net.osmand.swing.DataExtractionSettings;
import net.osmand.swing.Messages;
import net.osmand.util.Algorithms;
import org.apache.commons.logging.Log;

public class NewTileSourceDialog
extends JDialog {
    private static final long serialVersionUID = -4862884032977071296L;
    private static final Log log = PlatformUtil.getLog(NewTileSourceDialog.class);
    private JButton okButton;
    private JButton cancelButton;
    private JTextField templateName;
    private JTextField templateUrl;
    private TileSourceManager.TileSourceTemplate tileSourceTemplate;

    public NewTileSourceDialog(Component parent) {
        super(JOptionPane.getFrameForComponent(parent), true);
        this.setTitle(Messages.getString("NewTileSourceDialog.CREATE.NEW.TILE"));
        this.initDialog();
    }

    public void showDialog() {
        this.setSize(800, 200);
        double x = this.getParent().getBounds().getCenterX();
        double y = this.getParent().getBounds().getCenterY();
        this.setLocation((int)x - this.getWidth() / 2, (int)y - this.getHeight() / 2);
        this.setVisible(true);
    }

    private void initDialog() {
        JPanel pane = new JPanel();
        pane.setLayout(new BoxLayout(pane, 1));
        pane.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        this.add(pane);
        this.createInputSourceSection(pane);
        pane.add(Box.createVerticalGlue());
        FlowLayout l = new FlowLayout(2);
        JPanel buttonsPane = new JPanel(l);
        this.okButton = new JButton("OK");
        buttonsPane.add(this.okButton);
        this.cancelButton = new JButton(Messages.getString("NewTileSourceDialog.CANCEL"));
        buttonsPane.add(this.cancelButton);
        buttonsPane.setMaximumSize(new Dimension(Short.MAX_VALUE, (int)l.preferredLayoutSize(buttonsPane).getHeight()));
        pane.add(buttonsPane);
        this.addListeners();
    }

    private void createInputSourceSection(JPanel root) {
        JPanel panel = new JPanel();
        GridBagLayout l = new GridBagLayout();
        panel.setLayout(l);
        panel.setBorder(BorderFactory.createTitledBorder(Messages.getString("NewTileSourceDialog.INPUT.SOURCE")));
        root.add(panel);
        JLabel label = new JLabel(Messages.getString("NewTileSourceDialog.NAME"));
        panel.add(label);
        GridBagConstraints constr = new GridBagConstraints();
        constr.anchor = 17;
        constr.ipadx = 5;
        constr.gridx = 0;
        constr.gridy = 0;
        l.setConstraints(label, constr);
        this.templateName = new JTextField();
        this.templateName.setText(Messages.getString("NewTileSourceDialog.MAPNIK.EXAMPLE"));
        panel.add(this.templateName);
        constr = new GridBagConstraints();
        constr.fill = 2;
        constr.ipadx = 5;
        constr.gridx = 1;
        constr.gridy = 0;
        l.setConstraints(this.templateName, constr);
        label = new JLabel(Messages.getString("NewTileSourceDialog.URL.TEMPLATE"));
        panel.add(label);
        constr = new GridBagConstraints();
        constr.ipadx = 5;
        constr.ipady = 10;
        constr.gridx = 0;
        constr.gridy = 1;
        constr.anchor = 17;
        l.setConstraints(label, constr);
        this.templateUrl = new JTextField();
        this.templateUrl.setText("http://tile.openstreetmap.org/{$z}/{$x}/{$y}.png");
        panel.add(this.templateUrl);
        constr = new GridBagConstraints();
        constr.weightx = 1.0;
        constr.fill = 2;
        constr.ipadx = 5;
        constr.gridx = 1;
        constr.gridy = 1;
        l.setConstraints(this.templateUrl, constr);
        label = new JLabel(Messages.getString("NewTileSourceDialog.ADD.WMS.SERVICE"));
        panel.add(label);
        constr = new GridBagConstraints();
        constr.ipadx = 5;
        constr.ipady = 10;
        constr.gridx = 0;
        constr.gridy = 2;
        constr.anchor = 17;
        l.setConstraints(label, constr);
        label = new JLabel();
        label.setText("http://whoots.mapwarper.net/tms/{$z}/{$x}/{$y}/{layer}/http://path.to.wms.server");
        panel.add(label);
        constr = new GridBagConstraints();
        constr.weightx = 1.0;
        constr.fill = 2;
        constr.ipadx = 5;
        constr.gridx = 1;
        constr.gridy = 2;
        l.setConstraints(label, constr);
        panel.setMaximumSize(new Dimension(Short.MAX_VALUE, panel.getPreferredSize().height));
    }

    private void addListeners() {
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (NewTileSourceDialog.this.okPressed()) {
                    NewTileSourceDialog.this.setVisible(false);
                }
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewTileSourceDialog.this.setVisible(false);
            }
        });
    }

    public boolean okPressed() {
        File dir;
        if (Algorithms.isEmpty((CharSequence)this.templateName.getText())) {
            JOptionPane.showMessageDialog(this, Messages.getString("NewTileSourceDialog.SPECIFY.TEMPLATE.NAME"), Messages.getString("NewTileSourceDialog.ERROR.CREATING.NEW.TILE.SRC"), 0);
            return false;
        }
        if (Algorithms.isEmpty((CharSequence)this.templateUrl.getText())) {
            JOptionPane.showMessageDialog(this, Messages.getString("NewTileSourceDialog.SPECIFY.TEMPLATE.URL"), Messages.getString("NewTileSourceDialog.ERROR.CREATING.NEW.TILE.SRC"), 0);
            return false;
        }
        String url = this.templateUrl.getText();
        if (!(url.contains("{bbox}") || url.contains("{$x}") && url.contains("{$y}") && url.contains("{$z}"))) {
            JOptionPane.showMessageDialog(this, Messages.getString("NewTileSourceDialog.SPECIFY.ALL.PLACEHLDRS"), Messages.getString("NewTileSourceDialog.ERROR.CREATING.NEW.TILE.SRC"), 0);
            return false;
        }
        File tilesDirectory = DataExtractionSettings.getSettings().getTilesDirectory();
        if (tilesDirectory != null && (dir = new File(tilesDirectory, this.templateName.getText())).mkdirs()) {
            try {
                url = url.replace("{$x}", "{1}").replace("{$y}", "{2}").replace("{$z}", "{0}");
                this.tileSourceTemplate = new TileSourceManager.TileSourceTemplate(this.templateName.getText(), url, ".jpg", 18, 1, 256, 16, 20000);
                TileSourceManager.createMetaInfoFile((File)dir, (TileSourceManager.TileSourceTemplate)this.tileSourceTemplate, (boolean)true);
            }
            catch (IOException e) {
                log.error((Object)(Messages.getString("NewTileSourceDialog.ERROR.CREATING.NEW.TILE.SRC") + " " + url), (Throwable)e);
            }
        }
        return true;
    }

    public TileSourceManager.TileSourceTemplate getTileSourceTemplate() {
        return this.tileSourceTemplate;
    }
}

