/*
 * Decompiled with CFR 0.152.
 */
package com.atilika.kuromoji.dict;

import com.atilika.kuromoji.dict.DictionaryEntryBase;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class GenericDictionaryEntry
extends DictionaryEntryBase
implements Serializable {
    private final List<String> posFeatures;
    private final List<String> features;

    public GenericDictionaryEntry(Builder builder) {
        super(builder.surface, builder.leftId, builder.rightId, builder.wordCost);
        this.posFeatures = builder.pos;
        this.features = builder.features;
    }

    public List<String> getPosFeatures() {
        return this.posFeatures;
    }

    public List<String> getFeatures() {
        return this.features;
    }

    public static class Builder {
        private String surface;
        private short leftId;
        private short rightId;
        private short wordCost;
        private List<String> pos = new ArrayList<String>();
        private List<String> features = new ArrayList<String>();

        public Builder surface(String surface) {
            this.surface = surface;
            return this;
        }

        public Builder leftId(short leftId) {
            this.leftId = leftId;
            return this;
        }

        public Builder rightId(short rightId) {
            this.rightId = rightId;
            return this;
        }

        public Builder wordCost(short wordCost) {
            this.wordCost = wordCost;
            return this;
        }

        public Builder pos(List<String> pos) {
            this.pos = pos;
            return this;
        }

        public Builder features(List<String> features) {
            this.features = features;
            return this;
        }

        public GenericDictionaryEntry build() {
            return new GenericDictionaryEntry(this);
        }
    }
}

