/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.osmand.data.Amenity;
import net.osmand.data.MapObject;
import net.osmand.data.TransportRoute;
import net.osmand.data.TransportStopAggregated;
import net.osmand.data.TransportStopExit;
import net.osmand.util.Algorithms;
import net.osmand.util.CollectionUtils;
import net.osmand.util.MapUtils;

public class TransportStop
extends MapObject {
    private static final int DELETED_STOP = -1;
    public static final String MISSING_STOP_NAME = "#Missing Stop";
    private long[] referencesToRoutes = null;
    private long[] deletedRoutesIds;
    private long[] routesIds;
    public int distance;
    public int x31;
    public int y31;
    private List<TransportStopExit> exits;
    private List<TransportRoute> routes = null;
    private TransportStopAggregated transportStopAggregated;

    public List<TransportRoute> getRoutes() {
        return this.routes;
    }

    public boolean isMissingStop() {
        return MISSING_STOP_NAME.equals(this.getName());
    }

    public void setRoutes(List<TransportRoute> routes) {
        this.routes = routes;
    }

    public void addRoute(TransportRoute rt) {
        if (this.routes == null) {
            this.routes = new ArrayList<TransportRoute>();
        }
        this.routes.add(rt);
    }

    public long[] getReferencesToRoutes() {
        return this.referencesToRoutes;
    }

    public void setReferencesToRoutes(long[] referencesToRoutes) {
        this.referencesToRoutes = referencesToRoutes;
    }

    public long[] getRoutesIds() {
        return this.routesIds;
    }

    public void setRoutesIds(long[] routesIds) {
        this.routesIds = routesIds;
    }

    public boolean hasRoute(long routeId) {
        return this.routesIds != null && Arrays.binarySearch(this.routesIds, routeId) >= 0;
    }

    public boolean isDeleted() {
        return this.referencesToRoutes != null && this.referencesToRoutes.length == 1 && this.referencesToRoutes[0] == -1L;
    }

    public void setDeleted() {
        this.referencesToRoutes = new long[]{-1L};
    }

    public long[] getDeletedRoutesIds() {
        return this.deletedRoutesIds;
    }

    public void setDeletedRoutesIds(long[] deletedRoutesIds) {
        this.deletedRoutesIds = deletedRoutesIds;
    }

    public void addRouteId(long routeId) {
        this.routesIds = CollectionUtils.addToArrayL(this.routesIds, routeId, true);
    }

    public void addDeletedRouteId(long routeId) {
        this.deletedRoutesIds = CollectionUtils.addToArrayL(this.deletedRoutesIds, routeId, true);
    }

    public boolean isRouteDeleted(long routeId) {
        return this.deletedRoutesIds != null && Arrays.binarySearch(this.deletedRoutesIds, routeId) >= 0;
    }

    public boolean hasReferencesToRoutes() {
        return !this.isDeleted() && this.referencesToRoutes != null && this.referencesToRoutes.length > 0;
    }

    public Amenity getAmenity() {
        if (this.transportStopAggregated != null) {
            return this.transportStopAggregated.getAmenity();
        }
        return null;
    }

    public void setAmenity(Amenity amenity) {
        if (this.transportStopAggregated == null) {
            this.transportStopAggregated = new TransportStopAggregated();
        }
        this.transportStopAggregated.setAmenity(amenity);
    }

    public List<TransportStop> getLocalTransportStops() {
        if (this.transportStopAggregated != null) {
            return this.transportStopAggregated.getLocalTransportStops();
        }
        return Collections.emptyList();
    }

    public void addLocalTransportStop(TransportStop stop) {
        if (this.transportStopAggregated == null) {
            this.transportStopAggregated = new TransportStopAggregated();
        }
        this.transportStopAggregated.addLocalTransportStop(stop);
    }

    public List<TransportStop> getNearbyTransportStops() {
        if (this.transportStopAggregated != null) {
            return this.transportStopAggregated.getNearbyTransportStops();
        }
        return Collections.emptyList();
    }

    public void addNearbyTransportStop(TransportStop stop) {
        if (this.transportStopAggregated == null) {
            this.transportStopAggregated = new TransportStopAggregated();
        }
        this.transportStopAggregated.addNearbyTransportStop(stop);
    }

    public TransportStopAggregated getTransportStopAggregated() {
        return this.transportStopAggregated;
    }

    public void setTransportStopAggregated(TransportStopAggregated stopAggregated) {
        this.transportStopAggregated = stopAggregated;
    }

    @Override
    public void setLocation(double latitude, double longitude) {
        super.setLocation(latitude, longitude);
    }

    public void setLocation(int zoom, int dx, int dy) {
        this.x31 = dx << 31 - zoom;
        this.y31 = dy << 31 - zoom;
        this.setLocation(MapUtils.getLatitudeFromTile(zoom, dy), MapUtils.getLongitudeFromTile(zoom, dx));
    }

    public void addExit(TransportStopExit transportStopExit) {
        if (this.exits == null) {
            this.exits = new ArrayList<TransportStopExit>();
        }
        this.exits.add(transportStopExit);
    }

    public List<TransportStopExit> getExits() {
        if (this.exits == null) {
            return Collections.emptyList();
        }
        return this.exits;
    }

    public String getExitsString() {
        Object exitsString = "";
        Object refString = "";
        if (this.exits != null) {
            int i = 1;
            exitsString = (String)exitsString + " Exits: [";
            for (TransportStopExit e : this.exits) {
                if (e.getRef() != null) {
                    refString = " [ref:" + e.getRef() + "] ";
                }
                exitsString = (String)exitsString + " " + i + ")" + (String)refString + e.getName() + " " + String.valueOf(e.getLocation()) + " ]";
                ++i;
            }
        }
        return exitsString;
    }

    public boolean compareStop(TransportStop thatObj) {
        if (this.compareObject(thatObj) && (this.exits == null && thatObj.exits == null || this.exits != null && thatObj.exits != null && this.exits.size() == thatObj.exits.size())) {
            if (this.exits != null) {
                for (TransportStopExit exit1 : this.exits) {
                    if (exit1 == null) {
                        return false;
                    }
                    boolean contains = false;
                    for (TransportStopExit exit2 : thatObj.exits) {
                        if (!Algorithms.objectEquals(exit1, exit2)) continue;
                        contains = true;
                        if (exit1.compareExit(exit2)) break;
                        return false;
                    }
                    if (contains) continue;
                    return false;
                }
            }
        } else {
            return false;
        }
        return true;
    }
}

