/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.router.tester;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.osmand.ResultMatcher;
import net.osmand.binary.BinaryIndexPart;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.binary.BinaryMapRouteReaderAdapter;
import net.osmand.binary.RouteDataObject;
import net.osmand.data.LatLon;
import net.osmand.router.tester.RandomRouteEntry;
import net.osmand.router.tester.RandomRouteTester;
import net.osmand.util.MapUtils;

class RandomRouteGenerator {
    private final RandomRouteTester.GeneratorConfig config;
    private final List<RandomRouteEntry> testList = new ArrayList<RandomRouteEntry>();
    private List<BinaryMapIndexReader> obfReaders = new ArrayList<BinaryMapIndexReader>();

    RandomRouteGenerator(RandomRouteTester.GeneratorConfig config) {
        this.config = config;
    }

    List<RandomRouteEntry> generateTestList(List<BinaryMapIndexReader> obfReaders) {
        this.obfReaders = obfReaders;
        if (this.config.PREDEFINED_TESTS.length > 0) {
            this.parsePredefinedTests();
        } else {
            try {
                this.generateRandomTests();
            }
            catch (IOException e) {
                throw new IllegalStateException("generateRandomTests() failed");
            }
        }
        return this.testList;
    }

    private void parsePredefinedTests() {
        for (String url : this.config.PREDEFINED_TESTS) {
            RandomRouteEntry entry = new RandomRouteEntry();
            String opts = url.replaceAll(".*\\?", "").replaceAll("#.*", "");
            if (opts.contains("&")) {
                for (String keyval : opts.split("&")) {
                    if (!keyval.contains("=")) continue;
                    String k = keyval.split("=")[0];
                    String v = keyval.split("=")[1];
                    if ("profile".equals(k)) {
                        entry.profile = v;
                        continue;
                    }
                    if ("start".equals(k) && v.contains(",")) {
                        double lat = Double.parseDouble(v.split(",")[0]);
                        double lon = Double.parseDouble(v.split(",")[1]);
                        entry.start = new LatLon(lat, lon);
                        continue;
                    }
                    if (("finish".equals(k) || "end".equals(k)) && v.contains(",")) {
                        double lat = Double.parseDouble(v.split(",")[0]);
                        double lon = Double.parseDouble(v.split(",")[1]);
                        entry.finish = new LatLon(lat, lon);
                        continue;
                    }
                    if ("via".equals(k)) {
                        for (String ll : v.split(";")) {
                            if (!ll.contains(",")) continue;
                            double lat = Double.parseDouble(ll.split(",")[0]);
                            double lon = Double.parseDouble(ll.split(",")[1]);
                            entry.via.add(new LatLon(lat, lon));
                        }
                        continue;
                    }
                    if (!"params".equals(k)) continue;
                    for (String param : v.split(",")) {
                        if (entry.profile.equals(param) || param.startsWith("hhoff") || param.startsWith("hhonly") || param.startsWith("nativerouting") || param.startsWith("calcmode") || param.startsWith("noglobalfile") || param.startsWith("routing")) continue;
                        entry.params.add(param);
                    }
                }
            }
            if (entry.start == null || entry.finish == null) continue;
            this.testList.add(entry);
        }
    }

    private int fixedRandom(int bound, RandomActions action, long i, long j) {
        long week = Calendar.getInstance().get(3);
        long seed = (week << 56) + ((long)action.ordinal() << 48) + (i << 1) + j;
        return bound > 0 ? Math.abs(new Random(seed).nextInt()) % bound : 0;
    }

    private void getObfHighwayRoadRandomPoints(BinaryMapIndexReader index, final List<LatLon> randomPoints, final int limit, final int seed) throws IOException {
        class Counter {
            private int value;

            Counter() {
            }
        }
        final Counter added = new Counter();
        final int pointSkipDivisor = 1 + this.fixedRandom(100, RandomActions.HIGHWAY_SKIP_DIV, 0L, seed);
        for (BinaryIndexPart p : index.getIndexes()) {
            if (!(p instanceof BinaryMapRouteReaderAdapter.RouteRegion)) continue;
            List regions = index.searchRouteIndexTree(BinaryMapIndexReader.buildSearchRequest((int)0, (int)Integer.MAX_VALUE, (int)0, (int)Integer.MAX_VALUE, (int)15, null), ((BinaryMapRouteReaderAdapter.RouteRegion)p).getSubregions());
            index.loadRouteIndexData(regions, (ResultMatcher)new ResultMatcher<RouteDataObject>(){
                {
                }

                public boolean publish(RouteDataObject obj) {
                    for (int i = 0; i < obj.getTypes().length; ++i) {
                        BinaryMapRouteReaderAdapter.RouteTypeRule rr = obj.region.quickGetEncodingRule(obj.getTypes()[i]);
                        if (!"highway".equals(rr.getTag()) || !"primary".equals(rr.getValue()) && !"secondary".equals(rr.getValue())) continue;
                        int SHIFT_ID = 6;
                        long osmId = obj.getId() >> 6;
                        if (osmId % (long)pointSkipDivisor != 0L) continue;
                        int nPoints = obj.pointsX.length;
                        int pointIndex = RandomRouteGenerator.this.fixedRandom(nPoints, RandomActions.HIGHWAY_TO_POINT, osmId, seed);
                        double lat = MapUtils.get31LatitudeY((int)obj.pointsY[pointIndex]);
                        double lon = MapUtils.get31LongitudeX((int)obj.pointsX[pointIndex]);
                        randomPoints.add(new LatLon(lat, lon));
                        ++added.value;
                        break;
                    }
                    return true;
                }

                public boolean isCancelled() {
                    return added.value > limit;
                }
            });
        }
    }

    private void replenishRandomPoints(List<LatLon> randomPoints) throws IOException {
        if (this.obfReaders.isEmpty()) {
            throw new IllegalStateException("OBF files not initialized (replenishRandomPoints)");
        }
        int seed = randomPoints.size();
        int pointsToRead = 30 * Math.min(this.config.ITERATIONS, 10);
        int pointsPerObf = pointsToRead / this.obfReaders.size();
        pointsPerObf = Math.max(pointsPerObf, 10);
        for (BinaryMapIndexReader obfReader : this.obfReaders) {
            this.getObfHighwayRoadRandomPoints(obfReader, randomPoints, pointsPerObf, seed);
        }
    }

    private LatLon roundLatLonViaString(LatLon ll) {
        String str = String.format("%f,%f", ll.getLatitude(), ll.getLongitude());
        double lat = Double.parseDouble(str.split(",")[0]);
        double lon = Double.parseDouble(str.split(",")[1]);
        return new LatLon(lat, lon);
    }

    private void generateRandomTests() throws IOException {
        ArrayList<LatLon> randomPoints = new ArrayList<LatLon>();
        HashSet<LatLon> avoidDupes = new HashSet<LatLon>();
        int replenishCounter = 0;
        int REPLENISH_LIMIT = 10;
        this.replenishRandomPoints(randomPoints);
        for (int i = 0; i < this.config.ITERATIONS; ++i) {
            int j;
            RandomRouteEntry entry = new RandomRouteEntry();
            if (this.config.RANDOM_PROFILES.length > 0) {
                boolean isProfileName = true;
                int profileIndex = this.fixedRandom(this.config.RANDOM_PROFILES.length, RandomActions.GET_PROFILE, i, 0L);
                for (String param : this.config.RANDOM_PROFILES[profileIndex].split(",")) {
                    if (isProfileName) {
                        entry.profile = param;
                        isProfileName = false;
                        continue;
                    }
                    entry.params.add(param);
                }
            }
            for (int j2 = 0; j2 < randomPoints.size(); ++j2) {
                int startIndex = this.fixedRandom(randomPoints.size(), RandomActions.GET_START, i, j2);
                entry.start = this.roundLatLonViaString((LatLon)randomPoints.get(startIndex));
                if (!avoidDupes.contains(entry.start)) break;
            }
            avoidDupes.add(entry.start);
            int nInterpoints = this.fixedRandom(this.config.MAX_INTER_POINTS + 1, RandomActions.N_INTER_POINTS, i, 0L);
            int nNextPoints = 1 + nInterpoints;
            int minDistanceKm = this.config.MIN_DISTANCE_KM / nNextPoints;
            int maxDistanceKm = this.config.MAX_DISTANCE_KM / nNextPoints;
            LatLon prevPoint = entry.start;
            boolean restart = false;
            while (nNextPoints-- > 0) {
                LatLon point = null;
                boolean pointFound = false;
                for (j = 0; j < randomPoints.size(); ++j) {
                    int pointIndex = this.fixedRandom(randomPoints.size(), RandomActions.GET_POINTS, i, nNextPoints + j);
                    point = this.roundLatLonViaString((LatLon)randomPoints.get(pointIndex));
                    double km = MapUtils.getDistance((LatLon)prevPoint, (LatLon)point) / 1000.0;
                    if (!(km >= (double)minDistanceKm) || !(km <= (double)maxDistanceKm) || avoidDupes.contains(point)) continue;
                    pointFound = true;
                    break;
                }
                if (!pointFound) {
                    restart = true;
                    break;
                }
                prevPoint = point;
                avoidDupes.add(point);
                if (nNextPoints > 0) {
                    entry.via.add(point);
                    continue;
                }
                entry.finish = point;
            }
            if (restart) {
                if (replenishCounter++ >= 10) {
                    throw new IllegalStateException("Random routes not generated. Check min/max dist, region size, and OBF connectivity.");
                }
                this.replenishRandomPoints(randomPoints);
                --i;
                continue;
            }
            if (this.config.MAX_SHIFT_ALL_POINTS_M > 0) {
                int n = 0;
                class Shifter {
                    Shifter() {
                    }

                    LatLon shiftLatLon(LatLon ll, int i, int j) {
                        int meters = RandomRouteGenerator.this.fixedRandom(RandomRouteGenerator.this.config.MAX_SHIFT_ALL_POINTS_M, RandomActions.SHIFT_METERS, i, j);
                        double shift = (float)meters / 111000.0f;
                        double lat = ll.getLatitude() + shift;
                        double lon = ll.getLongitude() + shift;
                        return RandomRouteGenerator.this.roundLatLonViaString(new LatLon(lat, lon));
                    }
                }
                Shifter shifter = new Shifter();
                entry.start = shifter.shiftLatLon(entry.start, i, n++);
                entry.finish = shifter.shiftLatLon(entry.finish, i, n++);
                for (j = 0; j < entry.via.size(); ++j) {
                    entry.via.set(j, shifter.shiftLatLon(entry.via.get(j), i, n++));
                }
            }
            if (entry.start == null || entry.finish == null) continue;
            replenishCounter = 0;
            this.testList.add(entry);
        }
    }

    private static enum RandomActions {
        HIGHWAY_SKIP_DIV,
        HIGHWAY_TO_POINT,
        N_INTER_POINTS,
        GET_START,
        GET_POINTS,
        GET_PROFILE,
        SHIFT_METERS;

    }
}

