/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filter.internal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.xwiki.filter.FilterDescriptor;
import org.xwiki.filter.FilterDescriptorManager;
import org.xwiki.filter.internal.FilterProxy;

public class CompositeFilter
implements InvocationHandler {
    private FilterDescriptorManager filterManager;
    private List<SubFilter> filters;

    public CompositeFilter(FilterDescriptorManager filterManager, Object ... filters) {
        this.filterManager = filterManager;
        this.filters = new ArrayList<SubFilter>(filters.length);
        for (Object filter : filters) {
            this.filters.add(new SubFilter(filter, this.filterManager.getFilterDescriptor(filter.getClass())));
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        for (SubFilter filter : this.filters) {
            try {
                FilterProxy.invoke(filter.filter, filter.descriptor, method, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
        return null;
    }

    private static class SubFilter {
        public final Object filter;
        public final FilterDescriptor descriptor;

        public SubFilter(Object filter, FilterDescriptor descriptor) {
            this.filter = filter;
            this.descriptor = descriptor;
        }
    }
}

