/*
 * Decompiled with CFR 0.152.
 */
package com.atilika.kuromoji.viterbi;

import com.atilika.kuromoji.TokenizerBase;
import com.atilika.kuromoji.dict.ConnectionCosts;
import com.atilika.kuromoji.dict.UnknownDictionary;
import com.atilika.kuromoji.viterbi.ViterbiLattice;
import com.atilika.kuromoji.viterbi.ViterbiNode;
import java.util.LinkedList;
import java.util.List;

public class ViterbiSearcher {
    private static final int DEFAULT_COST = Integer.MAX_VALUE;
    private final ConnectionCosts costs;
    private final UnknownDictionary unknownDictionary;
    private int kanjiPenaltyLengthTreshold;
    private int otherPenaltyLengthThreshold;
    private int kanjiPenalty;
    private int otherPenalty;
    private final TokenizerBase.Mode mode;

    public ViterbiSearcher(TokenizerBase.Mode mode, ConnectionCosts costs, UnknownDictionary unknownDictionary, List<Integer> penalties) {
        if (!penalties.isEmpty()) {
            this.kanjiPenaltyLengthTreshold = penalties.get(0);
            this.kanjiPenalty = penalties.get(1);
            this.otherPenaltyLengthThreshold = penalties.get(2);
            this.otherPenalty = penalties.get(3);
        }
        this.mode = mode;
        this.costs = costs;
        this.unknownDictionary = unknownDictionary;
    }

    public List<ViterbiNode> search(ViterbiLattice lattice) {
        ViterbiNode[][] endIndexArr = this.calculatePathCosts(lattice);
        LinkedList<ViterbiNode> result = this.backtrackBestPath(endIndexArr[0][0]);
        return result;
    }

    private ViterbiNode[][] calculatePathCosts(ViterbiLattice lattice) {
        ViterbiNode[][] startIndexArr = lattice.getStartIndexArr();
        ViterbiNode[][] endIndexArr = lattice.getEndIndexArr();
        for (int i = 1; i < startIndexArr.length; ++i) {
            if (startIndexArr[i] == null || endIndexArr[i] == null) continue;
            for (ViterbiNode node : startIndexArr[i]) {
                if (node == null) break;
                this.updateNode(endIndexArr[i], node);
            }
        }
        return endIndexArr;
    }

    private void updateNode(ViterbiNode[] viterbiNodes, ViterbiNode node) {
        int backwardConnectionId = node.getLeftId();
        int wordCost = node.getWordCost();
        int leastPathCost = Integer.MAX_VALUE;
        for (ViterbiNode leftNode : viterbiNodes) {
            if (leftNode == null) {
                return;
            }
            int pathCost = leftNode.getPathCost() + this.costs.get(leftNode.getRightId(), backwardConnectionId) + wordCost;
            if (this.mode == TokenizerBase.Mode.SEARCH || this.mode == TokenizerBase.Mode.EXTENDED) {
                pathCost += this.getPenaltyCost(node);
            }
            if (pathCost >= leastPathCost) continue;
            leastPathCost = pathCost;
            node.setPathCost(leastPathCost);
            node.setLeftNode(leftNode);
        }
    }

    private int getPenaltyCost(ViterbiNode node) {
        int pathCost = 0;
        String surface = node.getSurface();
        int length = surface.length();
        if (length > this.kanjiPenaltyLengthTreshold) {
            if (this.isKanjiOnly(surface)) {
                pathCost += (length - this.kanjiPenaltyLengthTreshold) * this.kanjiPenalty;
            } else if (length > this.otherPenaltyLengthThreshold) {
                pathCost += (length - this.otherPenaltyLengthThreshold) * this.otherPenalty;
            }
        }
        return pathCost;
    }

    private boolean isKanjiOnly(String surface) {
        for (int i = 0; i < surface.length(); ++i) {
            char c = surface.charAt(i);
            if (Character.UnicodeBlock.of(c) == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS) continue;
            return false;
        }
        return true;
    }

    private LinkedList<ViterbiNode> backtrackBestPath(ViterbiNode eos) {
        ViterbiNode leftNode;
        ViterbiNode node = eos;
        LinkedList<ViterbiNode> result = new LinkedList<ViterbiNode>();
        result.add(node);
        while ((leftNode = node.getLeftNode()) != null) {
            if (this.mode == TokenizerBase.Mode.EXTENDED && leftNode.getType() == ViterbiNode.Type.UNKNOWN) {
                LinkedList<ViterbiNode> uniGramNodes = this.convertUnknownWordToUnigramNode(leftNode);
                result.addAll(uniGramNodes);
            } else {
                result.addFirst(leftNode);
            }
            node = leftNode;
        }
        return result;
    }

    private LinkedList<ViterbiNode> convertUnknownWordToUnigramNode(ViterbiNode node) {
        LinkedList<ViterbiNode> uniGramNodes = new LinkedList<ViterbiNode>();
        int unigramWordId = 0;
        String surface = node.getSurface();
        for (int i = surface.length(); i > 0; --i) {
            String word = surface.substring(i - 1, i);
            int startIndex = node.getStartIndex() + i - 1;
            ViterbiNode uniGramNode = new ViterbiNode(unigramWordId, word, this.unknownDictionary, startIndex, ViterbiNode.Type.UNKNOWN);
            uniGramNodes.addFirst(uniGramNode);
        }
        return uniGramNodes;
    }
}

