/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.gpx.primitives;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.osmand.shared.extensions.ClockExtensionsKt;
import net.osmand.shared.gpx.GpxFormatter;
import net.osmand.shared.gpx.PointAttributes;
import net.osmand.shared.gpx.primitives.GpxExtensions;
import net.osmand.shared.gpx.primitives.Link;
import net.osmand.shared.routing.RouteColorize;
import net.osmand.shared.util.KAlgorithms;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b \n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u0000\n\u0002\b\u0007\u0018\u0000 \u0091\u00012\u00020\u0001:\u0002\u0091\u0001B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0005B\u0019\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0002\u0010\tB9\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u0007\u0012\u0006\u0010\r\u001a\u00020\u0007\u0012\u0006\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0002\u0010\u000fBA\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u0007\u0012\u0006\u0010\r\u001a\u00020\u0007\u0012\u0006\u0010\u000e\u001a\u00020\u0007\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0002\u0010\u0012BU\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u0012\b\u0010\u0015\u001a\u0004\u0018\u00010\u0014\u0012\b\u0010\u0016\u001a\u0004\u0018\u00010\u0014\u0012\b\u0010\u0017\u001a\u0004\u0018\u00010\u0014\u0012\b\u0010\u0018\u001a\u0004\u0018\u00010\u0014\u0012\b\u0010\u0019\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\u0004\b\u0002\u0010\u001aJ\u0006\u0010g\u001a\u00020PJ\u0006\u0010h\u001a\u00020\u0007J\u0006\u0010i\u001a\u00020\u0007J\b\u0010j\u001a\u0004\u0018\u00010\u0014J\u0006\u0010k\u001a\u00020\u001cJ\u0006\u0010l\u001a\u00020\u0014J\u0010\u0010m\u001a\u00020n2\b\u0010o\u001a\u0004\u0018\u00010\u0014J\b\u0010p\u001a\u0004\u0018\u00010\u0014J\u000e\u0010q\u001a\u00020n2\u0006\u0010r\u001a\u00020\u0014J\u0010\u0010g\u001a\u00020P2\b\u0010s\u001a\u0004\u0018\u00010tJ\u0016\u0010u\u001a\u00020n2\u0006\u0010s\u001a\u00020t2\u0006\u0010\u0017\u001a\u00020PJ\b\u0010v\u001a\u0004\u0018\u00010\u0014J\u0010\u0010w\u001a\u00020n2\b\u0010x\u001a\u0004\u0018\u00010\u0014J\b\u0010y\u001a\u0004\u0018\u00010\u0014J\b\u0010z\u001a\u0004\u0018\u00010\u0014J\u0010\u0010{\u001a\u00020n2\b\u0010|\u001a\u0004\u0018\u00010\u0014J\u0010\u0010}\u001a\u00020n2\b\u0010~\u001a\u0004\u0018\u00010\u0014J\u000f\u0010\u007f\u001a\u00020n2\u0007\u0010\u0080\u0001\u001a\u00020\u0014J\u0007\u0010\u0081\u0001\u001a\u00020\u001cJ\u0007\u0010\u0082\u0001\u001a\u00020\u001cJ\u0007\u0010\u0083\u0001\u001a\u00020nJ\u0007\u0010\u0084\u0001\u001a\u00020nJ\u0007\u0010\u0085\u0001\u001a\u00020PJ\u0010\u0010\u0086\u0001\u001a\u00020n2\u0007\u0010\u0087\u0001\u001a\u00020PJ\t\u0010\u0088\u0001\u001a\u00020PH\u0016J\u0016\u0010\u0089\u0001\u001a\u00020\u001c2\n\u0010\u008a\u0001\u001a\u0005\u0018\u00010\u008b\u0001H\u0096\u0002J\u0007\u0010\u008c\u0001\u001a\u00020\u001cJ\u0010\u0010\u008d\u0001\u001a\u00020n2\u0007\u0010\u008e\u0001\u001a\u00020\u0000J\t\u0010\u008f\u0001\u001a\u0004\u0018\u00010\u0014J\u0011\u0010\u0090\u0001\u001a\u00020n2\b\u0010s\u001a\u0004\u0018\u00010\u0014R\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001e\"\u0004\b#\u0010 R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010\b\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010%\"\u0004\b)\u0010'R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001c\u0010.\u001a\u0004\u0018\u00010/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010+\"\u0004\b5\u0010-R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010+\"\u0004\b7\u0010-R\u001c\u00108\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010+\"\u0004\b:\u0010-R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R\u001a\u0010\f\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010%\"\u0004\b@\u0010'R\u001a\u0010\r\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010%\"\u0004\bB\u0010'R\u001a\u0010\u000e\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u0010%\"\u0004\bD\u0010'R\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010F\"\u0004\bG\u0010HR\u001a\u0010I\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u0010F\"\u0004\bK\u0010HR\u001a\u0010L\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bM\u0010\u001e\"\u0004\bN\u0010 R\u001a\u0010O\u001a\u00020PX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bQ\u0010R\"\u0004\bS\u0010TR\u001a\u0010U\u001a\u00020PX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bV\u0010R\"\u0004\bW\u0010TR\u001a\u0010X\u001a\u00020PX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bY\u0010R\"\u0004\bZ\u0010TR\u001a\u0010[\u001a\u00020PX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\\\u0010R\"\u0004\b]\u0010TR\u001a\u0010^\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b_\u0010%\"\u0004\b`\u0010'R\u001c\u0010a\u001a\u0004\u0018\u00010bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bc\u0010d\"\u0004\be\u0010f\u00a8\u0006\u0092\u0001"}, d2={"Lnet/osmand/shared/gpx/primitives/WptPt;", "Lnet/osmand/shared/gpx/primitives/GpxExtensions;", "<init>", "()V", "wptPt", "(Lnet/osmand/shared/gpx/primitives/WptPt;)V", "lat", "", "lon", "(DD)V", "time", "", "ele", "speed", "hdop", "(DDJDDD)V", "heading", "", "(DDJDDDF)V", "desc", "", "name", "category", "color", "icon", "background", "(DDLjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "firstPoint", "", "getFirstPoint", "()Z", "setFirstPoint", "(Z)V", "lastPoint", "getLastPoint", "setLastPoint", "getLat", "()D", "setLat", "(D)V", "getLon", "setLon", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "link", "Lnet/osmand/shared/gpx/primitives/Link;", "getLink", "()Lnet/osmand/shared/gpx/primitives/Link;", "setLink", "(Lnet/osmand/shared/gpx/primitives/Link;)V", "getCategory", "setCategory", "getDesc", "setDesc", "comment", "getComment", "setComment", "getTime", "()J", "setTime", "(J)V", "getEle", "setEle", "getSpeed", "setSpeed", "getHdop", "setHdop", "getHeading", "()F", "setHeading", "(F)V", "bearing", "getBearing", "setBearing", "deleted", "getDeleted", "setDeleted", "speedColor", "", "getSpeedColor", "()I", "setSpeedColor", "(I)V", "altitudeColor", "getAltitudeColor", "setAltitudeColor", "slopeColor", "getSlopeColor", "setSlopeColor", "colourARGB", "getColourARGB", "setColourARGB", "distance", "getDistance", "setDistance", "attributes", "Lnet/osmand/shared/gpx/PointAttributes;", "getAttributes", "()Lnet/osmand/shared/gpx/PointAttributes;", "setAttributes", "(Lnet/osmand/shared/gpx/PointAttributes;)V", "getColor", "getLatitude", "getLongitude", "getIconName", "isHidden", "getIconNameOrDefault", "setIconName", "", "iconName", "getAmenityOriginName", "setAmenityOriginName", "originName", "type", "Lnet/osmand/shared/routing/RouteColorize$ColorizationType;", "setColor", "getBackgroundType", "setBackgroundType", "backType", "getProfileType", "getAddress", "setAddress", "address", "setHidden", "hidden", "setProfileType", "profileType", "hasProfile", "isGap", "setGap", "removeProfileType", "getTrkPtIndex", "setTrkPtIndex", "index", "hashCode", "equals", "other", "", "hasLocation", "updatePoint", "pt", "getSpecialPointType", "setSpecialPointType", "Companion", "OsmAnd-shared"})
@SourceDebugExtension(value={"SMAP\nWptPt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WptPt.kt\nnet/osmand/shared/gpx/primitives/WptPt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,349:1\n1#2:350\n*E\n"})
public final class WptPt
extends GpxExtensions {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean firstPoint;
    private boolean lastPoint;
    private double lat;
    private double lon;
    @Nullable
    private String name;
    @Nullable
    private Link link;
    @Nullable
    private String category;
    @Nullable
    private String desc;
    @Nullable
    private String comment;
    private long time;
    private double ele;
    private double speed;
    private double hdop;
    private float heading;
    private float bearing;
    private boolean deleted;
    private int speedColor;
    private int altitudeColor;
    private int slopeColor;
    private int colourARGB;
    private double distance;
    @Nullable
    private PointAttributes attributes;

    public final boolean getFirstPoint() {
        return this.firstPoint;
    }

    public final void setFirstPoint(boolean bl) {
        this.firstPoint = bl;
    }

    public final boolean getLastPoint() {
        return this.lastPoint;
    }

    public final void setLastPoint(boolean bl) {
        this.lastPoint = bl;
    }

    public final double getLat() {
        return this.lat;
    }

    public final void setLat(double d) {
        this.lat = d;
    }

    public final double getLon() {
        return this.lon;
    }

    public final void setLon(double d) {
        this.lon = d;
    }

    @Nullable
    public final String getName() {
        return this.name;
    }

    public final void setName(@Nullable String string) {
        this.name = string;
    }

    @Nullable
    public final Link getLink() {
        return this.link;
    }

    public final void setLink(@Nullable Link link) {
        this.link = link;
    }

    @Nullable
    public final String getCategory() {
        return this.category;
    }

    public final void setCategory(@Nullable String string) {
        this.category = string;
    }

    @Nullable
    public final String getDesc() {
        return this.desc;
    }

    public final void setDesc(@Nullable String string) {
        this.desc = string;
    }

    @Nullable
    public final String getComment() {
        return this.comment;
    }

    public final void setComment(@Nullable String string) {
        this.comment = string;
    }

    public final long getTime() {
        return this.time;
    }

    public final void setTime(long l) {
        this.time = l;
    }

    public final double getEle() {
        return this.ele;
    }

    public final void setEle(double d) {
        this.ele = d;
    }

    public final double getSpeed() {
        return this.speed;
    }

    public final void setSpeed(double d) {
        this.speed = d;
    }

    public final double getHdop() {
        return this.hdop;
    }

    public final void setHdop(double d) {
        this.hdop = d;
    }

    public final float getHeading() {
        return this.heading;
    }

    public final void setHeading(float f) {
        this.heading = f;
    }

    public final float getBearing() {
        return this.bearing;
    }

    public final void setBearing(float f) {
        this.bearing = f;
    }

    public final boolean getDeleted() {
        return this.deleted;
    }

    public final void setDeleted(boolean bl) {
        this.deleted = bl;
    }

    public final int getSpeedColor() {
        return this.speedColor;
    }

    public final void setSpeedColor(int n) {
        this.speedColor = n;
    }

    public final int getAltitudeColor() {
        return this.altitudeColor;
    }

    public final void setAltitudeColor(int n) {
        this.altitudeColor = n;
    }

    public final int getSlopeColor() {
        return this.slopeColor;
    }

    public final void setSlopeColor(int n) {
        this.slopeColor = n;
    }

    public final int getColourARGB() {
        return this.colourARGB;
    }

    public final void setColourARGB(int n) {
        this.colourARGB = n;
    }

    public final double getDistance() {
        return this.distance;
    }

    public final void setDistance(double d) {
        this.distance = d;
    }

    @Nullable
    public final PointAttributes getAttributes() {
        return this.attributes;
    }

    public final void setAttributes(@Nullable PointAttributes pointAttributes) {
        this.attributes = pointAttributes;
    }

    public WptPt() {
        this.ele = Double.NaN;
        this.hdop = Double.NaN;
        this.heading = Float.NaN;
        this.bearing = Float.NaN;
    }

    /*
     * WARNING - void declaration
     */
    public WptPt(@NotNull WptPt wptPt) {
        Link link;
        Intrinsics.checkNotNullParameter((Object)wptPt, (String)"wptPt");
        this.ele = Double.NaN;
        this.hdop = Double.NaN;
        this.heading = Float.NaN;
        this.bearing = Float.NaN;
        this.lat = wptPt.lat;
        this.lon = wptPt.lon;
        this.name = wptPt.name;
        this.category = wptPt.category;
        this.desc = wptPt.desc;
        this.comment = wptPt.comment;
        this.time = wptPt.time;
        this.ele = wptPt.ele;
        this.speed = wptPt.speed;
        this.hdop = wptPt.hdop;
        this.heading = wptPt.heading;
        this.deleted = wptPt.deleted;
        this.speedColor = wptPt.speedColor;
        this.altitudeColor = wptPt.altitudeColor;
        this.slopeColor = wptPt.slopeColor;
        this.colourARGB = wptPt.colourARGB;
        this.distance = wptPt.distance;
        WptPt wptPt2 = this;
        Link link2 = wptPt.link;
        if (link2 != null) {
            void it;
            Link link3 = link2;
            WptPt wptPt3 = wptPt2;
            boolean bl = false;
            link = new Link((Link)it);
            wptPt2 = wptPt3;
        } else {
            link = null;
        }
        wptPt2.link = link;
        this.getExtensionsToWrite().putAll(wptPt.getExtensionsToWrite());
    }

    public final int getColor() {
        Integer n = this.getColor(0);
        Intrinsics.checkNotNull((Object)n);
        return n;
    }

    public final double getLatitude() {
        return this.lat;
    }

    public final double getLongitude() {
        return this.lon;
    }

    public WptPt(double lat, double lon) {
        this.ele = Double.NaN;
        this.hdop = Double.NaN;
        this.heading = Float.NaN;
        this.bearing = Float.NaN;
        this.lat = lat;
        this.lon = lon;
    }

    public WptPt(double lat, double lon, long time, double ele, double speed, double hdop) {
        this(lat, lon, time, ele, speed, hdop, Float.NaN);
    }

    public WptPt(double lat, double lon, long time, double ele, double speed, double hdop, float heading) {
        this.ele = Double.NaN;
        this.hdop = Double.NaN;
        this.heading = Float.NaN;
        this.bearing = Float.NaN;
        this.lat = lat;
        this.lon = lon;
        this.time = time;
        this.ele = ele;
        this.speed = speed;
        this.hdop = hdop;
        this.heading = heading;
    }

    public WptPt(double lat, double lon, @Nullable String desc, @Nullable String name, @Nullable String category, @Nullable String color, @Nullable String icon, @Nullable String background) {
        this.ele = Double.NaN;
        this.hdop = Double.NaN;
        this.heading = Float.NaN;
        this.bearing = Float.NaN;
        this.lat = lat;
        this.lon = lon;
        this.desc = desc;
        this.name = name;
        this.category = category;
        this.setColor(color);
        this.setIconName(icon);
        this.setBackgroundType(background);
    }

    @Nullable
    public final String getIconName() {
        return this.getExtensionsToRead().get("icon");
    }

    public final boolean isHidden() {
        String string = this.getExtensionsToRead().get("hidden");
        return string != null ? Boolean.parseBoolean(string) : false;
    }

    @NotNull
    public final String getIconNameOrDefault() {
        String iconName = this.getIconName();
        if (iconName == null) {
            iconName = "special_star";
        }
        return iconName;
    }

    public final void setIconName(@Nullable String iconName) {
        Map<String, String> extensionsToWrite = this.getExtensionsToWrite();
        if (iconName == null) {
            extensionsToWrite.remove("icon");
        } else {
            extensionsToWrite.put("icon", iconName);
        }
    }

    @Nullable
    public final String getAmenityOriginName() {
        Map<String, String> extensionsToRead = this.getExtensionsToRead();
        String amenityOrigin = extensionsToRead.get("amenity_origin");
        String comment = this.comment;
        if (amenityOrigin == null && comment != null && StringsKt.startsWith$default((String)comment, (String)"Amenity", (boolean)false, (int)2, null)) {
            amenityOrigin = comment;
        }
        return amenityOrigin;
    }

    public final void setAmenityOriginName(@NotNull String originName) {
        Intrinsics.checkNotNullParameter((Object)originName, (String)"originName");
        this.getExtensionsToWrite().put("amenity_origin", originName);
    }

    public final int getColor(@Nullable RouteColorize.ColorizationType type) {
        RouteColorize.ColorizationType colorizationType = type;
        return switch (colorizationType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[colorizationType.ordinal()]) {
            case 1 -> this.speedColor;
            case 2 -> this.altitudeColor;
            default -> this.slopeColor;
        };
    }

    public final void setColor(@NotNull RouteColorize.ColorizationType type, int color) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                this.speedColor = color;
                break;
            }
            case 2: {
                this.altitudeColor = color;
                break;
            }
            case 3: {
                this.slopeColor = color;
            }
        }
    }

    @Nullable
    public final String getBackgroundType() {
        return this.getExtensionsToRead().get("background");
    }

    public final void setBackgroundType(@Nullable String backType) {
        Map<String, String> extensionsToWrite = this.getExtensionsToWrite();
        if (backType == null) {
            extensionsToWrite.remove("background");
        } else {
            extensionsToWrite.put("background", backType);
        }
    }

    @Nullable
    public final String getProfileType() {
        return this.getExtensionsToRead().get("profile");
    }

    @Nullable
    public final String getAddress() {
        return this.getExtensionsToRead().get("address");
    }

    public final void setAddress(@Nullable String address) {
        CharSequence charSequence = address;
        if (charSequence == null || charSequence.length() == 0) {
            this.getExtensionsToWrite().remove("address");
        } else {
            this.getExtensionsToWrite().put("address", address);
        }
    }

    public final void setHidden(@Nullable String hidden) {
        Map<String, String> extensionsToWrite = this.getExtensionsToWrite();
        if (Intrinsics.areEqual((Object)hidden, (Object)"true")) {
            extensionsToWrite.put("hidden", hidden);
        } else {
            extensionsToWrite.remove("hidden");
        }
    }

    public final void setProfileType(@NotNull String profileType) {
        Intrinsics.checkNotNullParameter((Object)profileType, (String)"profileType");
        this.getExtensionsToWrite().put("profile", profileType);
    }

    public final boolean hasProfile() {
        String profileType = this.getProfileType();
        return profileType != null && !Intrinsics.areEqual((Object)"gap", (Object)profileType);
    }

    public final boolean isGap() {
        String profileType = this.getProfileType();
        return Intrinsics.areEqual((Object)"gap", (Object)profileType);
    }

    public final void setGap() {
        this.setProfileType("gap");
    }

    public final void removeProfileType() {
        this.getExtensionsToWrite().remove("profile");
    }

    public final int getTrkPtIndex() {
        int n;
        try {
            String string = this.getExtensionsToRead().get("trkpt_idx");
            n = string != null ? Integer.parseInt(string) : -1;
        }
        catch (NumberFormatException e) {
            n = -1;
        }
        return n;
    }

    public final void setTrkPtIndex(int index) {
        this.getExtensionsToWrite().put("trkpt_idx", String.valueOf(index));
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.name, this.category, this.desc, this.comment, this.lat, this.lon};
        return KAlgorithms.INSTANCE.hash(objectArray);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof WptPt)) {
            return false;
        }
        return Intrinsics.areEqual((Object)((WptPt)other).name, (Object)this.name) && Intrinsics.areEqual((Object)((WptPt)other).category, (Object)this.category) && ((WptPt)other).lat == this.lat && ((WptPt)other).lon == this.lon && Intrinsics.areEqual((Object)((WptPt)other).desc, (Object)this.desc);
    }

    public final boolean hasLocation() {
        return !(this.lat == 0.0) && !(this.lon == 0.0);
    }

    public final void updatePoint(@NotNull WptPt pt) {
        Intrinsics.checkNotNullParameter((Object)pt, (String)"pt");
        this.lat = Double.parseDouble(GpxFormatter.INSTANCE.formatLatLon(pt.lat));
        this.lon = Double.parseDouble(GpxFormatter.INSTANCE.formatLatLon(pt.lon));
        this.time = ClockExtensionsKt.currentTimeMillis();
        this.desc = pt.desc;
        this.name = pt.name;
        this.category = pt.category;
        Map<String, String> extensions = pt.getExtensionsToRead();
        String color = extensions.get("color");
        this.setColor(color);
        String iconName = extensions.get("icon");
        this.setIconName(iconName);
        String backgroundType = extensions.get("background");
        this.setBackgroundType(backgroundType);
        String address = extensions.get("address");
        this.setAddress(address);
        String hidden = extensions.get("hidden");
        this.setHidden(hidden);
    }

    @Nullable
    public final String getSpecialPointType() {
        return this.getExtensionsToRead().get("point_type");
    }

    public final void setSpecialPointType(@Nullable String type) {
        if (type != null) {
            this.getExtensionsToWrite().put("point_type", type);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003Jp\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0013\u00a8\u0006\u0014"}, d2={"Lnet/osmand/shared/gpx/primitives/WptPt$Companion;", "", "<init>", "()V", "createAdjustedPoint", "Lnet/osmand/shared/gpx/primitives/WptPt;", "lat", "", "lon", "description", "", "name", "category", "color", "", "iconName", "backgroundType", "amenityOriginName", "amenityExtensions", "", "OsmAnd-shared"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final WptPt createAdjustedPoint(double lat, double lon, @Nullable String description, @Nullable String name, @Nullable String category, int color, @Nullable String iconName, @Nullable String backgroundType, @Nullable String amenityOriginName, @Nullable Map<String, String> amenityExtensions) {
            double latAdjusted = Double.parseDouble(GpxFormatter.INSTANCE.formatLatLon(lat));
            double lonAdjusted = Double.parseDouble(GpxFormatter.INSTANCE.formatLatLon(lon));
            WptPt point = new WptPt(latAdjusted, lonAdjusted, ClockExtensionsKt.currentTimeMillis(), Double.NaN, 0.0, Double.NaN);
            point.setName(name);
            point.setCategory(category);
            point.setDesc(description);
            if (color != 0) {
                point.setColor(color);
            }
            if (iconName != null) {
                point.setIconName(iconName);
            }
            if (backgroundType != null) {
                point.setBackgroundType(backgroundType);
            }
            if (amenityOriginName != null) {
                point.setAmenityOriginName(amenityOriginName);
            }
            if (amenityExtensions != null) {
                point.getExtensionsToWrite().putAll(amenityExtensions);
            }
            return point;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RouteColorize.ColorizationType.values().length];
            try {
                nArray[RouteColorize.ColorizationType.SPEED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RouteColorize.ColorizationType.ELEVATION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RouteColorize.ColorizationType.SLOPE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

