/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.router;

import java.util.ArrayList;
import java.util.List;
import net.osmand.router.RoadSplitStructure;
import net.osmand.router.RouteSegmentResult;
import net.osmand.router.TurnType;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;

public class RoundaboutTurn {
    private final List<RouteSegmentResult> routeSegmentResults;
    private final RouteSegmentResult current;
    private final RouteSegmentResult prev;
    private final int iteration;
    private final boolean roundabout;
    private final boolean miniRoundabout;
    private final boolean prevRoundabout;
    private final boolean leftSide;

    public RoundaboutTurn(List<RouteSegmentResult> routeSegmentResults, int i, boolean leftSide) {
        this.routeSegmentResults = routeSegmentResults;
        this.leftSide = leftSide;
        this.iteration = i;
        this.current = routeSegmentResults.size() > i ? routeSegmentResults.get(i) : null;
        this.prev = i > 0 && routeSegmentResults.size() > i ? routeSegmentResults.get(i - 1) : null;
        this.roundabout = this.current != null && this.current.getObject().roundabout();
        this.prevRoundabout = this.prev != null && this.prev.getObject().roundabout();
        this.miniRoundabout = this.isMiniRoundabout(this.prev, this.current);
    }

    public boolean isRoundaboutExist() {
        return this.roundabout || this.miniRoundabout || this.prevRoundabout;
    }

    public TurnType getRoundaboutType() {
        if (this.prev == null || this.current == null) {
            return null;
        }
        if (this.prevRoundabout) {
            return null;
        }
        if (this.roundabout) {
            return this.processRoundaboutTurn();
        }
        if (this.miniRoundabout) {
            return this.processMiniRoundaboutTurn();
        }
        return null;
    }

    private boolean isMiniRoundabout(RouteSegmentResult prev, RouteSegmentResult current) {
        if (prev == null || current == null) {
            return false;
        }
        int[] prevTypes = prev.getObject().getPointTypes(prev.getEndPointIndex());
        int[] currentTypes = current.getObject().getPointTypes(current.getStartPointIndex());
        if (prevTypes != null && currentTypes != null) {
            int miniType = prev.getObject().region.searchRouteEncodingRule("highway", "mini_roundabout");
            if (miniType < 0) {
                return false;
            }
            boolean p = false;
            boolean c = false;
            for (int t : prevTypes) {
                if (t != miniType) continue;
                p = true;
                break;
            }
            for (int t : currentTypes) {
                if (t != miniType) continue;
                c = true;
                break;
            }
            return p && c;
        }
        return false;
    }

    private TurnType processRoundaboutTurn() {
        int exit = 1;
        RouteSegmentResult last = this.current;
        RouteSegmentResult firstRoundabout = this.current;
        RouteSegmentResult lastRoundabout = this.current;
        ArrayList<Float> turnAngles = new ArrayList<Float>();
        for (int j = this.iteration; j < this.routeSegmentResults.size(); ++j) {
            RouteSegmentResult rnext;
            last = rnext = this.routeSegmentResults.get(j);
            if (!rnext.getObject().roundabout()) break;
            lastRoundabout = rnext;
            boolean plus = rnext.getStartPointIndex() < rnext.getEndPointIndex();
            int k = rnext.getStartPointIndex();
            if (j == this.iteration) {
                // empty if block
            }
            while (k != rnext.getEndPointIndex()) {
                int attachedRoads = rnext.getAttachedRoutes(k).size();
                if (attachedRoads > 0) {
                    ++exit;
                    float turnAngle = this.calculateRoundaboutTurnAngle(rnext, firstRoundabout, rnext, k);
                    turnAngles.add(Float.valueOf(turnAngle));
                }
                k = plus ? k + 1 : k - 1;
            }
        }
        TurnType t = TurnType.getExitTurn(exit, 0.0f, this.leftSide);
        float turnAngle = this.calculateRoundaboutTurnAngle(last, firstRoundabout, lastRoundabout, -1);
        t.setTurnAngle(turnAngle);
        t.setOtherTurnAngles(turnAngles);
        return t;
    }

    private float calculateRoundaboutTurnAngle(RouteSegmentResult last, RouteSegmentResult firstRoundabout, RouteSegmentResult lastRoundabout, int ind) {
        float turnAngleBasedOnOutRoads = (float)MapUtils.degreesDiff(ind < 0 ? (double)last.getBearingBegin() : (double)last.getBearingBegin(ind, 10.0f), this.prev.getBearingEnd());
        float turnAngleBasedOnCircle = (float)(-MapUtils.degreesDiff(firstRoundabout.getBearingBegin(), ind < 0 ? (double)last.getBearingEnd() : (double)(lastRoundabout.getBearingEnd(ind, 10.0f) + 180.0f)));
        float turnAngle = Math.abs(turnAngleBasedOnOutRoads) > 120.0f ? turnAngleBasedOnCircle : turnAngleBasedOnOutRoads;
        return turnAngle;
    }

    private TurnType processMiniRoundaboutTurn() {
        List<RouteSegmentResult> attachedRoutes = this.current.getAttachedRoutes(this.current.getStartPointIndex());
        boolean clockwise = this.current.getObject().isClockwise(this.leftSide);
        if (!Algorithms.isEmpty(attachedRoutes)) {
            RoadSplitStructure rs = this.calculateSimpleRoadSplitStructure(attachedRoutes);
            int rightAttaches = rs.roadsOnRight;
            int leftAttaches = rs.roadsOnLeft;
            int exit = 1;
            exit = clockwise ? (exit += leftAttaches) : (exit += rightAttaches);
            TurnType t = TurnType.getExitTurn(exit, 0.0f, this.leftSide);
            float turnAngleBasedOnOutRoads = (float)MapUtils.degreesDiff(this.current.getBearingBegin(), this.prev.getBearingEnd());
            float turnAngleBasedOnCircle = (float)(-MapUtils.degreesDiff(this.current.getBearingBegin(), this.prev.getBearingEnd() + 180.0f));
            if (Math.abs(turnAngleBasedOnOutRoads) > 120.0f) {
                t.setTurnAngle(turnAngleBasedOnCircle);
            } else {
                t.setTurnAngle(turnAngleBasedOnOutRoads);
            }
            return t;
        }
        return null;
    }

    private RoadSplitStructure calculateSimpleRoadSplitStructure(List<RouteSegmentResult> attachedRoutes) {
        double prevAngle = MapUtils.normalizeDegrees360(this.prev.getBearingBegin() - 180.0f);
        double currentAngle = MapUtils.normalizeDegrees360(this.current.getBearingBegin());
        RoadSplitStructure rs = new RoadSplitStructure();
        for (RouteSegmentResult attached : attachedRoutes) {
            boolean rightSide;
            double attachedAngle = MapUtils.normalizeDegrees360(attached.getBearingBegin());
            if (prevAngle > currentAngle) {
                rightSide = attachedAngle > currentAngle && attachedAngle < prevAngle;
            } else {
                boolean leftSide = attachedAngle > prevAngle && attachedAngle < currentAngle;
                boolean bl = rightSide = !leftSide;
            }
            if (rightSide) {
                ++rs.roadsOnRight;
                continue;
            }
            ++rs.roadsOnLeft;
        }
        return rs;
    }
}

