/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.map;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.osmand.PlatformUtil;
import net.osmand.map.ITileSource;
import net.osmand.map.ParameterType;
import net.osmand.osm.io.NetworkUtils;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class TileSourceManager {
    private static final Log log = PlatformUtil.getLog(TileSourceManager.class);
    public static final String RULE_YANDEX_TRAFFIC = "yandex_traffic";
    public static final String MAPILLARY_VECTOR_TILE_EXT = ".pbf";
    public static final String MAPILLARY_ACCESS_TOKEN = "MLY|4444816185556934|29475a355616c979409a5adc377a00fa";
    private static final String RULE_WMS = "wms_tile";
    private static final String RULE_TEMPLATE_1 = "template:1";
    private static final String RND_ALG_WIKIMAPIA = "wikimapia";
    private static final String MAPNIK_URL = "https://tile.osmand.net/hd/{0}/{1}/{2}.png";
    private static final String MAPILLARY_VECTOR_URL = "https://tiles.mapillary.com/maps/vtp/mly1_public/2/{0}/{1}/{2}/?access_token=MLY|4444816185556934|29475a355616c979409a5adc377a00fa";
    private static final TileSourceTemplate MAPNIK_SOURCE = new TileSourceTemplate("OsmAnd (online tiles)", "https://tile.osmand.net/hd/{0}/{1}/{2}.png", ".png", 19, 1, 512, 8, 18000);
    private static final TileSourceTemplate MAPILLARY_VECTOR_SOURCE = new TileSourceTemplate("Mapillary (vector tiles)", "https://tiles.mapillary.com/maps/vtp/mly1_public/2/{0}/{1}/{2}/?access_token=MLY|4444816185556934|29475a355616c979409a5adc377a00fa", ".pbf", 22, 13, 256, 16, 3200);
    private static final TileSourceTemplate MAPILLARY_CACHE_SOURCE = new TileSourceTemplate("Mapillary (raster tiles)", "", ".png", 22, 13, 256, 32, 18000);
    public static final String PARAM_BING_QUAD_KEY = "{q}";
    private static final String PARAM_RND = "{rnd}";
    private static final String PARAM_BOUNDING_BOX = "{bbox}";
    public static final String PARAMETER_NAME = "{PARAM}";

    private static int parseInt(Map<String, String> attributes, String value, int def) {
        String val = attributes.get(value);
        if (val == null) {
            return def;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public static void createMetaInfoFile(File dir, TileSourceTemplate template, boolean override) throws IOException {
        File metainfo = new File(dir, ".metainfo");
        Map<String, String> properties = template.getProperties();
        if (override || !metainfo.exists()) {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(metainfo)));
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                writer.write("[" + entry.getKey() + "]\n" + entry.getValue() + "\n");
            }
            writer.close();
        }
    }

    public static boolean isTileSourceMetaInfoExist(File dir) {
        return new File(dir, ".metainfo").exists() || new File(dir, "url").exists();
    }

    public static TileSourceTemplate createTileSourceTemplate(File dir) {
        String ext;
        Map<String, String> metaInfo = TileSourceManager.readMetaInfoFile(dir);
        boolean ruleAcceptable = true;
        if (!metaInfo.isEmpty()) {
            metaInfo.put("name", dir.getName());
            TileSourceTemplate template = TileSourceManager.createTileSourceTemplate(metaInfo);
            if (template != null) {
                return template;
            }
            ruleAcceptable = false;
        }
        ext = (ext = TileSourceManager.findOneTile(dir)) == null ? ".jpg" : ext;
        String url = null;
        File readUrl = new File(dir, "url");
        try {
            if (readUrl.exists()) {
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(readUrl), "UTF-8"));
                url = reader.readLine();
                url = TileSourceTemplate.normalizeUrl(url);
                reader.close();
            }
        }
        catch (IOException e) {
            log.debug((Object)("Error reading url " + dir.getName()), (Throwable)e);
        }
        TileSourceTemplate template = new TileSourceTemplate(dir.getName(), url, ext, 18, 1, 256, 16, 20000);
        template.setRuleAcceptable(ruleAcceptable);
        return template;
    }

    private static Map<String, String> readMetaInfoFile(File dir) {
        LinkedHashMap<String, String> keyValueMap = new LinkedHashMap<String, String>();
        try {
            File metainfo = new File(dir, ".metainfo");
            if (metainfo.exists()) {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(metainfo), StandardCharsets.UTF_8));
                String key = null;
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).startsWith("[")) {
                        key = line.substring(1, line.length() - 1).toLowerCase();
                        continue;
                    }
                    if (key == null || line.length() <= 0) continue;
                    keyValueMap.put(key, line);
                    key = null;
                }
                reader.close();
            }
        }
        catch (IOException e) {
            log.error((Object)("Error reading metainfo file " + dir.getAbsolutePath()), (Throwable)e);
        }
        return keyValueMap;
    }

    private static String findOneTile(File dir) {
        if (dir.isDirectory()) {
            File[] files = dir.listFiles();
            if (files == null) {
                return null;
            }
            for (File file : files) {
                String substring;
                int extInt;
                if (file.isDirectory()) {
                    String ext = TileSourceManager.findOneTile(file);
                    if (ext == null) continue;
                    return ext;
                }
                String fileName = file.getName();
                if (!fileName.endsWith(".tile") || (extInt = (substring = fileName.substring(0, fileName.length() - ".tile".length())).lastIndexOf(46)) == -1) continue;
                return substring.substring(extInt, substring.length());
            }
        }
        return null;
    }

    public static List<TileSourceTemplate> getKnownSourceTemplates() {
        ArrayList<TileSourceTemplate> list = new ArrayList<TileSourceTemplate>();
        list.add(TileSourceManager.getMapnikSource());
        list.add(TileSourceManager.getMapillaryVectorSource());
        list.add(TileSourceManager.getMapillaryCacheSource());
        return list;
    }

    public static TileSourceTemplate getMapnikSource() {
        return MAPNIK_SOURCE;
    }

    public static TileSourceTemplate getMapillaryVectorSource() {
        return MAPILLARY_VECTOR_SOURCE;
    }

    public static TileSourceTemplate getMapillaryCacheSource() {
        return MAPILLARY_CACHE_SOURCE;
    }

    public static List<TileSourceTemplate> downloadTileSourceTemplates(String versionAsUrl, boolean https) {
        ArrayList<TileSourceTemplate> templates = new ArrayList<TileSourceTemplate>();
        try {
            int tok;
            HttpURLConnection connection = NetworkUtils.getHttpURLConnection((https ? "https" : "http") + "://download.osmand.net/tile_sources?" + versionAsUrl);
            XmlPullParser parser = PlatformUtil.newXMLPullParser();
            parser.setInput(connection.getInputStream(), "UTF-8");
            while ((tok = parser.next()) != 1) {
                String name;
                if (tok != 2 || !(name = parser.getName()).equals("tile_source")) continue;
                LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
                for (int i = 0; i < parser.getAttributeCount(); ++i) {
                    attrs.put(parser.getAttributeName(i), parser.getAttributeValue(i));
                }
                TileSourceTemplate template = TileSourceManager.createTileSourceTemplate(attrs);
                if (template == null) continue;
                templates.add(template);
            }
        }
        catch (IOException | XmlPullParserException e) {
            log.error((Object)"Exception while downloading tile sources", e);
            return null;
        }
        return templates;
    }

    public static TileSourceTemplate createTileSourceTemplate(Map<String, String> attrs) {
        TileSourceTemplate template;
        String rule = attrs.get("rule");
        if (rule == null) {
            template = TileSourceManager.createSimpleTileSourceTemplate(attrs, false);
        } else if (RULE_TEMPLATE_1.equalsIgnoreCase(rule)) {
            template = TileSourceManager.createSimpleTileSourceTemplate(attrs, false);
        } else if (RULE_WMS.equalsIgnoreCase(rule)) {
            template = TileSourceManager.createWmsTileSourceTemplate(attrs);
        } else if (RULE_YANDEX_TRAFFIC.equalsIgnoreCase(rule)) {
            template = TileSourceManager.createSimpleTileSourceTemplate(attrs, true);
        } else {
            return null;
        }
        if (template != null) {
            template.setRule(rule);
        }
        return template;
    }

    private static TileSourceTemplate createWmsTileSourceTemplate(Map<String, String> attributes) {
        String name = attributes.get("name");
        String layer = attributes.get("layer");
        Object urlTemplate = attributes.get("url_template");
        if (name == null || urlTemplate == null || layer == null) {
            return null;
        }
        int maxZoom = TileSourceManager.parseInt(attributes, "max_zoom", 18);
        int minZoom = TileSourceManager.parseInt(attributes, "min_zoom", 5);
        int tileSize = TileSourceManager.parseInt(attributes, "tile_size", 256);
        String ext = attributes.get("ext") == null ? ".jpg" : attributes.get("ext");
        int bitDensity = TileSourceManager.parseInt(attributes, "img_density", 16);
        int avgTileSize = TileSourceManager.parseInt(attributes, "avg_img_size", 18000);
        String randoms = attributes.get("randoms");
        urlTemplate = "http://whoots.mapwarper.net/tms/{0}/{1}/{2}/" + layer + "/" + (String)urlTemplate;
        TileSourceTemplate templ = new TileSourceTemplate(name, (String)urlTemplate, ext, maxZoom, minZoom, tileSize, bitDensity, avgTileSize);
        templ.setRandoms(randoms);
        return templ;
    }

    private static TileSourceTemplate createSimpleTileSourceTemplate(Map<String, String> attributes, boolean ignoreTemplate) {
        String name = attributes.get("name");
        String urlTemplate = attributes.get("url_template");
        if (name == null || urlTemplate == null && !ignoreTemplate) {
            return null;
        }
        urlTemplate = TileSourceTemplate.normalizeUrl(urlTemplate);
        int maxZoom = TileSourceManager.parseInt(attributes, "max_zoom", 18);
        int minZoom = TileSourceManager.parseInt(attributes, "min_zoom", 5);
        int tileSize = TileSourceManager.parseInt(attributes, "tile_size", 256);
        int expirationTime = TileSourceManager.parseInt(attributes, "expiration_time_minutes", -1);
        String ext = attributes.get("ext") == null ? ".jpg" : attributes.get("ext");
        int bitDensity = TileSourceManager.parseInt(attributes, "img_density", 16);
        int avgTileSize = TileSourceManager.parseInt(attributes, "avg_img_size", 18000);
        boolean ellipsoid = false;
        if (Boolean.parseBoolean(attributes.get("ellipsoid"))) {
            ellipsoid = true;
        }
        boolean invertedY = false;
        if (Boolean.parseBoolean(attributes.get("inverted_y"))) {
            invertedY = true;
        }
        String randoms = attributes.get("randoms");
        TileSourceTemplate templ = new TileSourceTemplate(name, urlTemplate, ext, maxZoom, minZoom, tileSize, bitDensity, avgTileSize);
        if (attributes.get("referer") != null) {
            templ.setReferer(attributes.get("referer"));
        }
        if (attributes.get("user_agent") != null) {
            templ.setUserAgent(attributes.get("user_agent"));
        }
        if (expirationTime >= 0) {
            templ.setExpirationTimeMinutes(expirationTime);
        }
        templ.setEllipticYTile(ellipsoid);
        templ.setInvertedYTile(invertedY);
        templ.setRandoms(randoms);
        if (attributes.get("param_type") != null && attributes.get("param_min") != null && attributes.get("param_step") != null && attributes.get("param_max") != null) {
            templ.setParamType(ParameterType.fromName(attributes.get("param_type")));
            try {
                templ.setParamMin(Long.parseLong(attributes.get("param_min")));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                templ.setParamStep(Long.parseLong(attributes.get("param_step")));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                templ.setParamMax(Long.parseLong(attributes.get("param_max")));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return templ;
    }

    static {
        int oneDayMinutes = 1440;
        MAPILLARY_VECTOR_SOURCE.setExpirationTimeMinutes(oneDayMinutes);
        MAPILLARY_VECTOR_SOURCE.setHidden(true);
        MAPILLARY_CACHE_SOURCE.setExpirationTimeMinutes(oneDayMinutes);
        MAPILLARY_CACHE_SOURCE.setHidden(true);
    }

    public static class TileSourceTemplate
    implements ITileSource,
    Cloneable {
        private int maxZoom;
        private int minZoom;
        private String name;
        protected int tileSize;
        protected String urlToLoad;
        private final Map<String, String> urlParameters = new ConcurrentHashMap<String, String>();
        protected String ext;
        private int avgSize;
        private int bitDensity;
        private long expirationTimeMillis = -1L;
        private boolean ellipticYTile;
        private boolean invertedYTile;
        private String randoms;
        private String[] randomsArray;
        private String rule;
        private String referer;
        private String userAgent;
        private boolean hidden;
        private ParameterType paramType = ParameterType.UNDEFINED;
        private long paramMin;
        private long paramStep;
        private long paramMax;
        private boolean isRuleAcceptable = true;

        public TileSourceTemplate(String name, String urlToLoad, String ext, int maxZoom, int minZoom, int tileSize, int bitDensity, int avgSize) {
            this.maxZoom = maxZoom;
            this.minZoom = minZoom;
            this.name = name;
            this.tileSize = tileSize;
            this.urlToLoad = urlToLoad;
            this.ext = ext;
            this.avgSize = avgSize;
            this.bitDensity = bitDensity;
        }

        public TileSourceTemplate(String name, String urlToLoad, String ext, int maxZoom, int minZoom, int tileSize, int bitDensity, int avgSize, ParameterType paramType, long paramMin, long paramStep, long paramMax) {
            this(name, urlToLoad, ext, maxZoom, minZoom, tileSize, bitDensity, avgSize);
            this.paramType = paramType;
            this.paramMin = paramMin;
            this.paramStep = paramStep;
            this.paramMax = paramMax;
        }

        public static String normalizeUrl(String url) {
            if (url != null) {
                url = url.replaceAll("\\{\\$z\\}", "{0}");
                url = url.replaceAll("\\{\\$x\\}", "{1}");
                url = url.replaceAll("\\{\\$y\\}", "{2}");
                url = url.replaceAll("\\{z\\}", "{0}");
                url = url.replaceAll("\\{x\\}", "{1}");
                url = url.replaceAll("\\{y\\}", "{2}");
            }
            return url;
        }

        public static String[] buildRandomsArray(String randomsStr) {
            ArrayList<String> randoms = new ArrayList<String>();
            if (!Algorithms.isEmpty(randomsStr)) {
                String[] valuesArray;
                if (randomsStr.equals(TileSourceManager.RND_ALG_WIKIMAPIA)) {
                    return new String[]{TileSourceManager.RND_ALG_WIKIMAPIA};
                }
                for (String s : valuesArray = randomsStr.split(",")) {
                    String[] rangeArray = s.split("-");
                    if (rangeArray.length == 2) {
                        boolean rangeValid;
                        String s2;
                        String s1;
                        block9: {
                            s1 = rangeArray[0];
                            s2 = rangeArray[1];
                            rangeValid = false;
                            try {
                                int a = Integer.parseInt(s1);
                                int b = Integer.parseInt(s2);
                                if (b > a) {
                                    for (int i = a; i <= b; ++i) {
                                        randoms.add(String.valueOf(i));
                                    }
                                    rangeValid = true;
                                }
                            }
                            catch (NumberFormatException e) {
                                if (s1.length() != 1 || s2.length() != 1) break block9;
                                char a = s1.charAt(0);
                                char b = s2.charAt(0);
                                if (b <= a) break block9;
                                for (char i = a; i <= b; i = (char)(i + '\u0001')) {
                                    randoms.add(String.valueOf(i));
                                }
                                rangeValid = true;
                            }
                        }
                        if (rangeValid) continue;
                        randoms.add(s1);
                        randoms.add(s2);
                        continue;
                    }
                    randoms.add(s);
                }
            }
            return randoms.toArray(new String[0]);
        }

        public void setMinZoom(int minZoom) {
            this.minZoom = minZoom;
        }

        public void setMaxZoom(int maxZoom) {
            this.maxZoom = maxZoom;
        }

        public boolean isHidden() {
            return this.hidden;
        }

        public void setHidden(boolean hidden) {
            this.hidden = hidden;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setEllipticYTile(boolean ellipticYTile) {
            this.ellipticYTile = ellipticYTile;
        }

        @Override
        public boolean isEllipticYTile() {
            return this.ellipticYTile;
        }

        @Override
        public boolean isInvertedYTile() {
            return this.invertedYTile;
        }

        @Override
        public boolean isTimeSupported() {
            return this.expirationTimeMillis != -1L;
        }

        @Override
        public boolean getInversiveZoom() {
            return false;
        }

        public void setInvertedYTile(boolean invertedYTile) {
            this.invertedYTile = invertedYTile;
        }

        @Override
        public String getRandoms() {
            return this.randoms;
        }

        public void setRandoms(String randoms) {
            this.randoms = randoms;
            this.randomsArray = TileSourceTemplate.buildRandomsArray(randoms);
        }

        public String[] getRandomsArray() {
            return this.randomsArray;
        }

        public void setRandomsArray(String[] randomsArray) {
            this.randomsArray = randomsArray;
        }

        @Override
        public int getBitDensity() {
            return this.bitDensity;
        }

        public int getAverageSize() {
            return this.avgSize;
        }

        @Override
        public int getMaximumZoomSupported() {
            return this.maxZoom;
        }

        @Override
        public int getMinimumZoomSupported() {
            return this.minZoom;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public void setExpirationTimeMillis(long timeMillis) {
            this.expirationTimeMillis = timeMillis;
        }

        public void setExpirationTimeMinutes(int minutes) {
            this.expirationTimeMillis = minutes < 0 ? -1L : (long)(minutes * 60) * 1000L;
        }

        @Override
        public int getExpirationTimeMinutes() {
            if (this.expirationTimeMillis < 0L) {
                return -1;
            }
            return (int)(this.expirationTimeMillis / 60000L);
        }

        @Override
        public long getExpirationTimeMillis() {
            return this.expirationTimeMillis;
        }

        @Override
        public String getReferer() {
            return this.referer;
        }

        public void setReferer(String referer) {
            this.referer = referer;
        }

        @Override
        public String getUserAgent() {
            return this.userAgent;
        }

        public void setUserAgent(String userAgent) {
            this.userAgent = userAgent;
        }

        @Override
        public int getTileSize() {
            return this.tileSize;
        }

        @Override
        public String getTileFormat() {
            return this.ext;
        }

        public void setTileFormat(String ext) {
            this.ext = ext;
        }

        public void setUrlToLoad(String urlToLoad) {
            this.urlToLoad = urlToLoad;
        }

        public boolean isRuleAcceptable() {
            return this.isRuleAcceptable;
        }

        public void setRuleAcceptable(boolean isRuleAcceptable) {
            this.isRuleAcceptable = isRuleAcceptable;
        }

        @Override
        public ParameterType getParamType() {
            return this.paramType;
        }

        @Override
        public long getParamMin() {
            return this.paramMin;
        }

        @Override
        public long getParamStep() {
            return this.paramStep;
        }

        @Override
        public long getParamMax() {
            return this.paramMax;
        }

        public void setParamType(ParameterType paramType) {
            this.paramType = paramType;
        }

        public void setParamMin(long paramMin) {
            this.paramMin = paramMin;
        }

        public void setParamStep(long paramStep) {
            this.paramStep = paramStep;
        }

        public void setParamMax(long paramMax) {
            this.paramMax = paramMax;
        }

        @Override
        public Map<String, String> getUrlParameters() {
            return Collections.unmodifiableMap(this.urlParameters);
        }

        @Override
        public String getUrlParameter(String name) {
            return this.urlParameters.get(name);
        }

        @Override
        public void setUrlParameter(String name, String value) {
            this.urlParameters.put(name, value);
        }

        @Override
        public void resetUrlParameter(String name) {
            this.urlParameters.remove(name);
        }

        @Override
        public void resetUrlParameters() {
            this.urlParameters.clear();
        }

        public TileSourceTemplate copy() {
            try {
                return (TileSourceTemplate)this.clone();
            }
            catch (CloneNotSupportedException e) {
                return this;
            }
        }

        @Override
        public String getUrlToLoad(int x, int y, int zoom) {
            if (this.urlToLoad == null) {
                return null;
            }
            if (this.isInvertedYTile()) {
                y = (1 << zoom) - 1 - y;
            }
            return TileSourceTemplate.buildUrlToLoad(this.urlToLoad, this.randomsArray, x, y, zoom, this.urlParameters);
        }

        public static String eqtBingQuadKey(int z, int x, int y) {
            char[] NUM_CHAR = new char[]{'0', '1', '2', '3'};
            char[] tn = new char[z];
            for (int i = z - 1; i >= 0; --i) {
                int num = x % 2 | y % 2 << 1;
                tn[i] = NUM_CHAR[num];
                x >>= 1;
                y >>= 1;
            }
            return new String(tn);
        }

        private static String calcBoundingBoxForTile(int zoom, int x, int y) {
            double xmin = MapUtils.getLongitudeFromTile(zoom, x);
            double xmax = MapUtils.getLongitudeFromTile(zoom, x + 1);
            double ymin = MapUtils.getLatitudeFromTile(zoom, y + 1);
            double ymax = MapUtils.getLatitudeFromTile(zoom, y);
            return String.format(Locale.US, "%.8f,%.8f,%.8f,%.8f", xmin, ymin, xmax, ymax);
        }

        public static String buildUrlToLoad(String urlTemplate, String[] randomsArray, int x, int y, int zoom, Map<String, String> params) {
            try {
                if (randomsArray != null && randomsArray.length > 0) {
                    String rand = TileSourceManager.RND_ALG_WIKIMAPIA.equals(randomsArray[0]) ? String.valueOf(x % 4 + y % 4 * 4) : randomsArray[(x + y) % randomsArray.length];
                    urlTemplate = urlTemplate.replace(TileSourceManager.PARAM_RND, rand);
                } else if (urlTemplate.contains(TileSourceManager.PARAM_RND)) {
                    log.error((Object)("Cannot resolve randoms for template: " + urlTemplate));
                    return null;
                }
                int bingQuadKeyParamIndex = urlTemplate.indexOf(TileSourceManager.PARAM_BING_QUAD_KEY);
                if (bingQuadKeyParamIndex != -1) {
                    return urlTemplate.replace(TileSourceManager.PARAM_BING_QUAD_KEY, TileSourceTemplate.eqtBingQuadKey(zoom, x, y));
                }
                int bbKeyParamIndex = urlTemplate.indexOf(TileSourceManager.PARAM_BOUNDING_BOX);
                if (bbKeyParamIndex != -1) {
                    return urlTemplate.replace(TileSourceManager.PARAM_BOUNDING_BOX, TileSourceTemplate.calcBoundingBoxForTile(zoom, x, y));
                }
                if (!Algorithms.isEmpty(params)) {
                    for (Map.Entry<String, String> pv : params.entrySet()) {
                        String name = pv.getKey();
                        int paramIndex = urlTemplate.indexOf(name);
                        if (paramIndex == -1) continue;
                        urlTemplate = urlTemplate.replace(name, pv.getValue());
                    }
                }
                return MessageFormat.format(urlTemplate, "" + zoom, "" + x, "" + y);
            }
            catch (IllegalArgumentException e) {
                log.error((Object)("Cannot build url for template: " + urlTemplate), (Throwable)e);
                return null;
            }
        }

        @Override
        public String getUrlTemplate() {
            return this.urlToLoad;
        }

        @Override
        public boolean couldBeDownloadedFromInternet() {
            return this.urlToLoad != null;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TileSourceTemplate other = (TileSourceTemplate)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public void setRule(String rule) {
            this.rule = rule;
        }

        @Override
        public String getRule() {
            return this.rule;
        }

        public String calculateTileId(int x, int y, int zoom) {
            StringBuilder builder = new StringBuilder(this.getName());
            builder.append('/');
            builder.append(zoom).append('/').append(x).append('/').append(y).append(this.getTileFormat()).append(".tile");
            return builder.toString();
        }

        @Override
        public long getTileModifyTime(int x, int y, int zoom, String dirWithTiles) {
            File en = new File(dirWithTiles, this.calculateTileId(x, y, zoom));
            if (en.exists()) {
                return en.lastModified();
            }
            return System.currentTimeMillis();
        }

        @Override
        public byte[] getBytes(int x, int y, int zoom, String dirWithTiles) throws IOException {
            File f = new File(dirWithTiles, this.calculateTileId(x, y, zoom));
            if (!f.exists()) {
                return null;
            }
            ByteArrayOutputStream bous = new ByteArrayOutputStream();
            FileInputStream fis = new FileInputStream(f);
            Algorithms.streamCopy(fis, bous);
            fis.close();
            bous.close();
            return bous.toByteArray();
        }

        @Override
        public void deleteTiles(String path) {
            File pf = new File(path);
            File[] list = pf.listFiles();
            if (list != null) {
                for (File l : list) {
                    if (!l.isDirectory()) continue;
                    Algorithms.removeAllFiles(l);
                }
            }
        }

        @Override
        public int getAvgSize() {
            return this.avgSize;
        }

        public Map<String, String> getProperties() {
            LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
            if (!Algorithms.isEmpty(this.getRule())) {
                properties.put("rule", this.getRule());
            }
            if (this.getUrlTemplate() != null) {
                properties.put("url_template", this.getUrlTemplate());
            }
            if (!Algorithms.isEmpty(this.getReferer())) {
                properties.put("referer", this.getReferer());
            }
            if (!Algorithms.isEmpty(this.getUserAgent())) {
                properties.put("user_agent", this.getUserAgent());
            }
            properties.put("ext", this.getTileFormat());
            properties.put("min_zoom", "" + this.getMinimumZoomSupported());
            properties.put("max_zoom", "" + this.getMaximumZoomSupported());
            properties.put("tile_size", "" + this.getTileSize());
            properties.put("img_density", "" + this.getBitDensity());
            properties.put("avg_img_size", "" + this.getAverageSize());
            if (this.isEllipticYTile()) {
                properties.put("ellipsoid", "" + this.isEllipticYTile());
            }
            if (this.isInvertedYTile()) {
                properties.put("inverted_y", "" + this.isInvertedYTile());
            }
            if (this.getRandoms() != null) {
                properties.put("randoms", this.getRandoms());
            }
            if (this.getExpirationTimeMinutes() != -1) {
                properties.put("expiration_time_minutes", "" + this.getExpirationTimeMinutes());
            }
            if (this.paramType != ParameterType.UNDEFINED) {
                properties.put("param_type", this.paramType.getParamName());
                properties.put("param_min", "" + this.paramMin);
                properties.put("param_step", "" + this.paramStep);
                properties.put("param_max", "" + this.paramMax);
            }
            return properties;
        }
    }
}

