/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.wiki.commonswiki;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.osmand.MainUtilities;
import net.osmand.PlatformUtil;
import net.osmand.impl.FileProgressImplementation;
import net.osmand.obf.preparation.DBDialect;
import net.osmand.travel.WikivoyageLangPreparation;
import net.osmand.wiki.AbstractWikiFilesDownloader;
import net.osmand.wiki.WikiDatabasePreparation;
import net.osmand.wiki.commonswiki.CommonsWikiFilesDownloader;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CommonsWikimediaPreparation {
    private static final Log log = PlatformUtil.getLog(CommonsWikimediaPreparation.class);
    private static final int DEFAULT_THREADS = 8;
    public static final int BATCH_SIZE = 5000;
    private static final BlockingQueue<Article> QUEUE = new LinkedBlockingQueue<Article>(10000);
    private static final Article END_SIGNAL = new Article(-1L, "", "", "", "", "");
    private static final AtomicLong articlesCount = new AtomicLong(0L);
    private static final AtomicLong writtenToDatabaseCount = new AtomicLong(0L);
    private static final AtomicLong totalPagesCount = new AtomicLong(0L);
    private static final AtomicLong errorContentBracesCount = new AtomicLong(0L);
    private static final AtomicLong otherErrorsCount = new AtomicLong(0L);
    public static final String RESULT_SQLITE = "meta_commonswiki.sqlite";
    public static final String FILE_NAMESPACE = "6";
    public static final String FILE = "File:";

    public static void main(String[] args) {
        CommonsWikimediaPreparation.applyCommandLineOpts(new MainUtilities.CommandLineOpts(args));
    }

    private static void applyCommandLineOpts(MainUtilities.CommandLineOpts opts) {
        if (opts.getBoolean("--help")) {
            CommonsWikimediaPreparation.printHelp();
            System.exit(0);
        }
        String folder = opts.getOrDefault("--dir", "");
        String mode = opts.getOrDefault("--mode", "");
        String database = opts.getOrDefault("--result_db", "");
        boolean recreateDb = opts.getBoolean("--recreate_db");
        boolean keepFiles = opts.getBoolean("--keep_files");
        int threads = opts.getIntOrDefault("--threads", 8);
        if (mode.isEmpty() || folder.isEmpty()) {
            CommonsWikimediaPreparation.printHelp();
            throw new RuntimeException("Correct arguments weren't supplied");
        }
        File commonsWikiDB = database.isEmpty() ? new File(folder, RESULT_SQLITE) : new File(database);
        CommonsWikimediaPreparation p = new CommonsWikimediaPreparation();
        try {
            switch (mode) {
                case "parse-img-meta": {
                    p.updateCommonsWiki(commonsWikiDB, true, false, keepFiles, threads);
                    break;
                }
                case "update-img-meta": {
                    p.updateCommonsWiki(commonsWikiDB, recreateDb, false, keepFiles, threads);
                    break;
                }
                case "update-img-meta-daily": {
                    p.updateCommonsWiki(commonsWikiDB, false, true, keepFiles, threads);
                    break;
                }
                default: {
                    CommonsWikimediaPreparation.printHelp();
                    throw new RuntimeException("Unknown mode: " + mode);
                }
            }
        }
        catch (IOException | InterruptedException | SQLException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException("Error during parsing: " + e.getMessage(), e);
        }
    }

    private static void printHelp() {
        System.out.println("Usage: process-commonswiki [--options]\n\n<dir> and <mode> are mandatory options\n\n--help print this help\n--dir=/path/to/wiki_files/*.xml.gz\n--result_db=/path/to/result_db/meta_commonswiki.sqlite\n--recreate_db recreate meta_commonswiki.sqlite\n--keep_files keep downloaded files instead of deleting them\n--threads=8 number of parsing threads\n\n--mode=parse-img-meta\n  Recreates the RESULT_SQLITE database and downloads, then parses commonswiki-latest-pages-articles.xml.gz\n  from https://dumps.wikimedia.org/commonswiki/latest/ in parts.\n\n--mode=update-img-meta\n  Downloads and parses commonswiki-latest-pages-articles.xml.gz\n  from https://dumps.wikimedia.org/commonswiki/latest/ in parts.\n  If a part is already downloaded, it is not re-downloaded. Parsing starts immediately.\n\n--mode=update-img-meta-daily\n  Downloads and parses commonswiki-[date]-pages-meta-hist-incr.xml.bz2\n  from https://dumps.wikimedia.org/other/incr/commonswiki/[date]/,\n  starting from the date after the one recorded in timestamp.txt.\n");
    }

    private void updateCommonsWiki(File commonsWikiDB, boolean recreateDb, boolean dailyUpdate, boolean keepFiles, int threads) throws ParserConfigurationException, SAXException, IOException, SQLException, InterruptedException {
        long start = System.currentTimeMillis();
        String commonsWikiDBPath = commonsWikiDB.getAbsolutePath();
        CommonsWikimediaPreparation.initDatabase(commonsWikiDBPath, recreateDb);
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        Thread writerThread = new Thread(() -> CommonsWikimediaPreparation.writeToDatabase(commonsWikiDBPath));
        writerThread.start();
        log.info((Object)"Updating wikidata...");
        AbstractWikiFilesDownloader.DownloadHandler dh = fileName -> {
            log.info((Object)("Updating from " + fileName));
            executor.submit(() -> this.parseCommonArticles(fileName));
        };
        CommonsWikiFilesDownloader wfd = new CommonsWikiFilesDownloader(commonsWikiDB, dailyUpdate, dh);
        executor.shutdown();
        while (!executor.awaitTermination(1L, TimeUnit.DAYS)) {
        }
        if (!keepFiles) {
            wfd.removeDownloadedPages();
        }
        QUEUE.put(END_SIGNAL);
        writerThread.join();
        this.createIndex(commonsWikiDBPath);
        log.info((Object)"========= All tasks done in %.0fs =========".formatted((double)(System.currentTimeMillis() - start) / 1000.0));
        log.info((Object)"========= Statistics =========");
        log.info((Object)("Total pages with namespace=6: " + totalPagesCount.get()));
        log.info((Object)("Added to queue: " + articlesCount.get()));
        log.info((Object)("Written to database: " + writtenToDatabaseCount.get()));
        log.info((Object)("Errors 'Error content braces': " + errorContentBracesCount.get()));
        log.info((Object)("Other errors: " + otherErrorsCount.get()));
        log.info((Object)"========= End Statistics =========");
    }

    private static void initDatabase(String sqliteFileName, boolean recreateDb) throws SQLException {
        try (Connection conn = DBDialect.SQLITE.getDatabaseConnection(sqliteFileName, log);
             Statement stmt = conn.createStatement();){
            stmt.execute("PRAGMA journal_mode = WAL;");
            stmt.execute("PRAGMA synchronous = OFF;");
            stmt.execute("PRAGMA busy_timeout = 5000;");
            if (recreateDb) {
                log.info((Object)"========= DROP old TABLE common_meta =========");
                stmt.execute("DROP TABLE IF EXISTS common_meta");
            }
            log.info((Object)"========= CREATE TABLE common_meta =========");
            stmt.execute("CREATE TABLE IF NOT EXISTS common_meta(id long PRIMARY KEY, name text, author text, date text, license text, description text)");
        }
    }

    private static void writeToDatabase(String sqliteFileName) {
        System.out.println("Writer started...");
        try (Connection conn = DBDialect.SQLITE.getDatabaseConnection(sqliteFileName, log);){
            conn.setAutoCommit(false);
            try (PreparedStatement insertStatement = conn.prepareStatement("INSERT INTO common_meta(id, name, author, date, license, description) VALUES (?, ?, ?, ?, ?, ?) ON CONFLICT(id) DO UPDATE SET name = excluded.name, author = excluded.author, date = excluded.date, license = excluded.license, description = excluded.description;");){
                Article a;
                int counter = 0;
                while ((a = QUEUE.take()) != END_SIGNAL) {
                    insertStatement.setLong(1, a.id);
                    insertStatement.setString(2, a.title);
                    insertStatement.setString(3, a.author);
                    insertStatement.setString(4, a.date);
                    insertStatement.setString(5, a.license);
                    insertStatement.setString(6, a.description);
                    insertStatement.addBatch();
                    if (++counter % 5000 != 0) continue;
                    insertStatement.executeBatch();
                    conn.commit();
                    writtenToDatabaseCount.addAndGet(counter);
                    counter = 0;
                }
                if (counter > 0) {
                    insertStatement.executeBatch();
                    conn.commit();
                    writtenToDatabaseCount.addAndGet(counter);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Writer finished (queue empty).");
    }

    public void createIndex(String sqliteFileName) {
        log.info((Object)"========= DONE =========");
        log.info((Object)"Create indexes");
        try (Connection conn = DBDialect.SQLITE.getDatabaseConnection(sqliteFileName, log);
             Statement stmt = conn.createStatement();){
            stmt.execute("CREATE INDEX IF NOT EXISTS name_common_meta_index ON common_meta(name)");
        }
        catch (SQLException e) {
            System.err.println("Failed to create index: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void parseCommonArticles(String articles) {
        try {
            SAXParser sx = SAXParserFactory.newInstance().newSAXParser();
            FileProgressImplementation progress = new FileProgressImplementation("Read commonswiki articles file", new File(articles));
            InputStream streamFile = progress.openFileInputStream();
            InputSource is = CommonsWikimediaPreparation.getInputSource(streamFile);
            CommonsWikiHandler handler = new CommonsWikiHandler(sx, progress);
            sx.parse(is, (DefaultHandler)handler);
        }
        catch (IOException | SQLException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e);
        }
    }

    private static InputSource getInputSource(InputStream streamFile) throws IOException {
        GZIPInputStream zis = new GZIPInputStream(streamFile);
        InputStreamReader reader = new InputStreamReader((InputStream)zis, StandardCharsets.UTF_8);
        return new InputSource(reader);
    }

    private record Article(Long id, String title, String author, String date, String license, String description) {
    }

    private static class CommonsWikiHandler
    extends DefaultHandler {
        private final SAXParser saxParser;
        private boolean pageTag = false;
        private boolean pageIdParsed = false;
        private boolean pageTextParsed = false;
        private StringBuilder ctext = null;
        private final StringBuilder title = new StringBuilder();
        private final StringBuilder ns = new StringBuilder();
        private final StringBuilder id = new StringBuilder();
        private final FileProgressImplementation progress;
        private final StringBuilder textContent = new StringBuilder();

        CommonsWikiHandler(SAXParser saxParser, FileProgressImplementation progress) throws SQLException {
            this.saxParser = saxParser;
            this.progress = progress;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            String name;
            String string = name = this.saxParser.isNamespaceAware() ? localName : qName;
            if (!this.pageTag) {
                this.pageTag = name.equals("page");
            } else {
                switch (name) {
                    case "title": {
                        this.title.setLength(0);
                        this.ctext = this.title;
                        break;
                    }
                    case "ns": {
                        this.ns.setLength(0);
                        this.ctext = this.ns;
                        break;
                    }
                    case "id": {
                        if (this.pageIdParsed) break;
                        this.id.setLength(0);
                        this.ctext = this.id;
                        this.pageIdParsed = true;
                        break;
                    }
                    case "text": {
                        if (this.pageTextParsed) break;
                        this.textContent.setLength(0);
                        this.ctext = this.textContent;
                    }
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.pageTag && this.ctext != null) {
                this.ctext.append(ch, start, length);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            String name;
            String string = name = this.saxParser.isNamespaceAware() ? localName : qName;
            if (this.pageTag) {
                switch (name) {
                    case "page": {
                        this.pageTag = false;
                        this.pageIdParsed = false;
                        this.pageTextParsed = false;
                        this.progress.update();
                        break;
                    }
                    case "title": 
                    case "ns": 
                    case "id": {
                        this.ctext = null;
                        break;
                    }
                    case "text": {
                        if (this.pageTextParsed) break;
                        this.parseMeta();
                        this.pageTextParsed = true;
                    }
                }
            }
        }

        private void parseMeta() {
            block6: {
                try {
                    String imageTitle;
                    if (!CommonsWikimediaPreparation.FILE_NAMESPACE.contentEquals(this.ns)) break block6;
                    String string = imageTitle = this.title.toString().startsWith(CommonsWikimediaPreparation.FILE) ? this.title.substring(CommonsWikimediaPreparation.FILE.length()) : null;
                    if (imageTitle == null) {
                        return;
                    }
                    totalPagesCount.incrementAndGet();
                    HashMap<String, String> meta = new HashMap<String, String>();
                    WikiDatabasePreparation.removeMacroBlocks(this.textContent, meta, new HashMap<WikivoyageLangPreparation.WikivoyageTemplates, List<String>>(), null, "en", imageTitle, null, true, errorContentBracesCount, false);
                    WikiDatabasePreparation.prepareMetaData(meta);
                    String author = (String)meta.get("author");
                    String license = (String)meta.get("license");
                    String description = (String)meta.get("description");
                    String date = (String)meta.get("date");
                    try {
                        QUEUE.put(new Article(Long.parseLong(this.id.toString()), imageTitle.replace(" ", "_"), author, date, license, description));
                        if (articlesCount.incrementAndGet() % 100000L == 0L) {
                            System.out.println(articlesCount.get() + " Articles processed");
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                catch (Exception exception) {
                    otherErrorsCount.incrementAndGet();
                    log.error((Object)(exception.getMessage() + " on page id : " + String.valueOf(this.id) + " title : " + String.valueOf(this.title)), (Throwable)exception);
                }
            }
        }
    }
}

