/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.obd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.osmand.shared.api.SettingsAPI;
import net.osmand.shared.data.KLatLon;
import net.osmand.shared.extensions.ClockExtensionsKt;
import net.osmand.shared.extensions.StringExtensionsKt;
import net.osmand.shared.obd.OBDCommand;
import net.osmand.shared.obd.OBDDataField;
import net.osmand.shared.obd.OBDDispatcher;
import net.osmand.shared.obd.OBDFuelTypeFormatter;
import net.osmand.shared.util.KCollectionUtils;
import net.osmand.shared.util.KMapUtils;
import net.osmand.shared.util.Localization;
import net.osmand.shared.util.Logger;
import net.osmand.shared.util.LoggerFactory;
import net.osmand.shared.util.PlatformUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004=>?@B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010'\u001a\u00020(2\u001a\u0010\u0018\u001a\u0016\u0012\u0004\u0012\u00020*\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010+0)J\u0006\u0010,\u001a\u00020(J\u000e\u0010-\u001a\u00020(2\u0006\u0010.\u001a\u00020\u0013J\u0006\u0010/\u001a\u00020(J\b\u00100\u001a\u00020(H\u0002J\u0016\u00101\u001a\u00020\u00192\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u0005J\u000e\u00105\u001a\u00020(2\u0006\u00106\u001a\u00020\u0019J\b\u00107\u001a\u00020(H\u0002J#\u00108\u001a\u0004\u0018\u0001092\u0012\u0010:\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010+0\u0012H\u0002\u00a2\u0006\u0002\u0010;J\b\u0010<\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000R \u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R*\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u00122\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0015R\u001a\u0010\u001c\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R(\u0010\"\u001a\u0004\u0018\u00010!2\b\u0010\u0018\u001a\u0004\u0018\u00010!@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&\u00a8\u0006A"}, d2={"Lnet/osmand/shared/obd/OBDDataComputer;", "", "<init>", "()V", "LITER_KM_CONSUMPTION_LIMIT", "", "M_LITER_CONSUMPTION_LIMIT", "LITER_HOUR_CONSUMPTION_LIMIT", "log", "Lnet/osmand/shared/util/Logger;", "osmAndSettings", "Lnet/osmand/shared/api/SettingsAPI;", "DEFAULT_FUEL_TANK_CAPACITY", "", "SAME_FUEL_LVL_SEQUENCE_LENGTH", "FUEL_TANK_CAPACITY_SETTING_ID", "", "locations", "", "Lnet/osmand/shared/obd/OBDDataComputer$OBDLocation;", "getLocations", "()Ljava/util/List;", "setLocations", "(Ljava/util/List;)V", "value", "Lnet/osmand/shared/obd/OBDDataComputer$OBDComputerWidget;", "widgets", "getWidgets", "timeoutForInstantValuesSeconds", "getTimeoutForInstantValuesSeconds", "()I", "setTimeoutForInstantValuesSeconds", "(I)V", "Lnet/osmand/shared/obd/OBDDispatcher;", "obdDispatcher", "getObdDispatcher", "()Lnet/osmand/shared/obd/OBDDispatcher;", "setObdDispatcher", "(Lnet/osmand/shared/obd/OBDDispatcher;)V", "acceptValue", "", "", "Lnet/osmand/shared/obd/OBDCommand;", "Lnet/osmand/shared/obd/OBDDataField;", "clearCache", "registerLocation", "l", "compute", "cleanupLocations", "registerWidget", "type", "Lnet/osmand/shared/obd/OBDDataComputer$OBDTypeWidget;", "averageTimeSeconds", "removeWidget", "w", "updateRequiredCommands", "averageNumber", "", "values", "(Ljava/util/List;)Ljava/lang/Double;", "getFuelTank", "OBDLocation", "OBDTypeWidget", "OBDComputerWidgetFormatter", "OBDComputerWidget", "OsmAnd-shared"})
@SourceDebugExtension(value={"SMAP\nOBDDataComputer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OBDDataComputer.kt\nnet/osmand/shared/obd/OBDDataComputer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,552:1\n1863#2,2:553\n774#2:555\n865#2,2:556\n1557#2:558\n1628#2,3:559\n1#3:562\n*S KotlinDebug\n*F\n+ 1 OBDDataComputer.kt\nnet/osmand/shared/obd/OBDDataComputer\n*L\n117#1:553,2\n243#1:555\n243#1:556,2\n244#1:558\n244#1:559,3\n*E\n"})
public final class OBDDataComputer {
    @NotNull
    public static final OBDDataComputer INSTANCE = new OBDDataComputer();
    private static final int LITER_KM_CONSUMPTION_LIMIT = 100;
    private static final int M_LITER_CONSUMPTION_LIMIT = 1000;
    private static final int LITER_HOUR_CONSUMPTION_LIMIT = 100;
    @NotNull
    private static final Logger log = LoggerFactory.INSTANCE.getLogger("OBDDataComputer");
    @NotNull
    private static final SettingsAPI osmAndSettings = PlatformUtil.INSTANCE.getOsmAndContext().getSettings();
    public static final float DEFAULT_FUEL_TANK_CAPACITY = 52.0f;
    private static final int SAME_FUEL_LVL_SEQUENCE_LENGTH = 5;
    @NotNull
    private static final String FUEL_TANK_CAPACITY_SETTING_ID = "fuel_tank_capacity";
    @NotNull
    private static List<OBDLocation> locations = CollectionsKt.emptyList();
    @NotNull
    private static List<OBDComputerWidget> widgets = new ArrayList();
    private static int timeoutForInstantValuesSeconds;
    @Nullable
    private static OBDDispatcher obdDispatcher;

    private OBDDataComputer() {
    }

    @NotNull
    public final List<OBDLocation> getLocations() {
        return locations;
    }

    public final void setLocations(@NotNull List<OBDLocation> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        locations = list;
    }

    @NotNull
    public final List<OBDComputerWidget> getWidgets() {
        return widgets;
    }

    public final int getTimeoutForInstantValuesSeconds() {
        return timeoutForInstantValuesSeconds;
    }

    public final void setTimeoutForInstantValuesSeconds(int n) {
        timeoutForInstantValuesSeconds = n;
    }

    @Nullable
    public final OBDDispatcher getObdDispatcher() {
        return obdDispatcher;
    }

    public final void setObdDispatcher(@Nullable OBDDispatcher value) {
        obdDispatcher = value;
        this.updateRequiredCommands();
    }

    public final void acceptValue(@NotNull Map<OBDCommand, ? extends OBDDataField<Object>> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        for (OBDComputerWidget widget : widgets) {
            widget.acceptValue(value);
        }
        this.compute();
    }

    public final void clearCache() {
        for (OBDComputerWidget widget : widgets) {
            widget.clearData();
        }
    }

    public final void registerLocation(@NotNull OBDLocation l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        if (!((Collection)widgets).isEmpty()) {
            locations = KCollectionUtils.INSTANCE.addToList((Collection)locations, l);
            this.cleanupLocations();
        }
    }

    public final void compute() {
        long now = ClockExtensionsKt.currentTimeMillis();
        for (OBDComputerWidget widget : widgets) {
            widget.cleanup(now);
            widget.computeValue();
        }
    }

    private final void cleanupLocations() {
        int inWindow;
        long now = ClockExtensionsKt.currentTimeMillis();
        int window = timeoutForInstantValuesSeconds;
        for (OBDComputerWidget widget : widgets) {
            if (!widget.getType().getLocationNeeded()) continue;
            window = Math.max(window, widget.getAverageTimeSeconds());
        }
        for (inWindow = 0; inWindow < locations.size() && locations.get(inWindow).getTime() < now - (long)(window * 1000); ++inWindow) {
        }
        if (inWindow - 1 > 0) {
            locations = locations.subList(inWindow - 1, locations.size());
        }
    }

    @NotNull
    public final OBDComputerWidget registerWidget(@NotNull OBDTypeWidget type, int averageTimeSeconds) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        for (OBDComputerWidget widget : widgets) {
            if (widget.getType() != type || widget.getAverageTimeSeconds() != averageTimeSeconds) continue;
            return widget;
        }
        OBDComputerWidget widget = new OBDComputerWidget(type, averageTimeSeconds);
        widgets = KCollectionUtils.INSTANCE.addToList((Collection)widgets, widget);
        this.updateRequiredCommands();
        return widget;
    }

    public final void removeWidget(@NotNull OBDComputerWidget w) {
        Intrinsics.checkNotNullParameter((Object)w, (String)"w");
        widgets = KCollectionUtils.INSTANCE.removeFromList((Collection)widgets, w);
        this.updateRequiredCommands();
    }

    private final void updateRequiredCommands() {
        block1: {
            OBDDispatcher oBDDispatcher;
            OBDDispatcher oBDDispatcher2 = obdDispatcher;
            if (oBDDispatcher2 == null) break block1;
            OBDDispatcher $this$updateRequiredCommands_u24lambda_u241 = oBDDispatcher = oBDDispatcher2;
            boolean bl = false;
            $this$updateRequiredCommands_u24lambda_u241.clearCommands();
            Iterable $this$forEach$iv = widgets;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                OBDComputerWidget widget = (OBDComputerWidget)element$iv;
                boolean bl2 = false;
                $this$updateRequiredCommands_u24lambda_u241.addCommand(widget.getType().getRequiredCommand());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Double averageNumber(List<? extends OBDDataField<Object>> values) {
        Double d;
        if (!((Collection)values).isEmpty()) {
            void $this$mapTo$iv$iv;
            OBDDataField it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = values;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (OBDDataField)element$iv$iv;
                boolean bl = false;
                if (!(it.getValue() instanceof Number)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (OBDDataField)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Object t = it.getValue();
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.Number");
                collection.add(((Number)t).doubleValue());
            }
            Iterable iterable2 = (List)destination$iv$iv;
            double d2 = 0.0;
            for (Object t : iterable2) {
                void it2;
                double d3 = ((Number)t).doubleValue();
                double d4 = d2;
                boolean bl = false;
                void var13_17 = it2;
                d2 = d4 + var13_17;
            }
            d = d2 / (double)values.size();
        } else {
            d = null;
        }
        return d;
    }

    private final float getFuelTank() {
        Float fuelTank;
        Float f = fuelTank = osmAndSettings.getFloatPreference(FUEL_TANK_CAPACITY_SETTING_ID);
        return f != null ? f.floatValue() : 52.0f;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002J1\u0010\u001e\u001a\u00020\u001f2\"\u0010 \u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00100\"j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u0010`!H\u0002\u00a2\u0006\u0002\u0010#J\"\u0010$\u001a\u00020\u00162\u001a\u0010\u0012\u001a\u0016\u0012\u0004\u0012\u00020&\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00100%J\u0006\u0010'\u001a\u00020\u0016J\u000e\u0010(\u001a\u00020\u00162\u0006\u0010)\u001a\u00020\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00100\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00100\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lnet/osmand/shared/obd/OBDDataComputer$OBDComputerWidget;", "", "type", "Lnet/osmand/shared/obd/OBDDataComputer$OBDTypeWidget;", "averageTimeSeconds", "", "<init>", "(Lnet/osmand/shared/obd/OBDDataComputer$OBDTypeWidget;I)V", "getType", "()Lnet/osmand/shared/obd/OBDDataComputer$OBDTypeWidget;", "getAverageTimeSeconds", "()I", "setAverageTimeSeconds", "(I)V", "values", "", "Lnet/osmand/shared/obd/OBDDataField;", "tmpValues", "value", "cachedVersion", "version", "clearData", "", "computeValue", "compute", "getDistanceForTimePeriod", "", "startTime", "", "endTime", "calculateFuelConsumption", "", "locValues", "Lkotlin/collections/ArrayList;", "Ljava/util/ArrayList;", "(Ljava/util/ArrayList;)F", "acceptValue", "", "Lnet/osmand/shared/obd/OBDCommand;", "resetLocations", "cleanup", "now", "OsmAnd-shared"})
    public static final class OBDComputerWidget {
        @NotNull
        private final OBDTypeWidget type;
        private int averageTimeSeconds;
        @NotNull
        private List<? extends OBDDataField<Object>> values;
        @NotNull
        private List<? extends OBDDataField<Object>> tmpValues;
        @Nullable
        private Object value;
        private int cachedVersion;
        private int version;

        public OBDComputerWidget(@NotNull OBDTypeWidget type, int averageTimeSeconds) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this.type = type;
            this.averageTimeSeconds = averageTimeSeconds;
            this.values = new ArrayList();
            this.tmpValues = new ArrayList();
        }

        @NotNull
        public final OBDTypeWidget getType() {
            return this.type;
        }

        public final int getAverageTimeSeconds() {
            return this.averageTimeSeconds;
        }

        public final void setAverageTimeSeconds(int n) {
            this.averageTimeSeconds = n;
        }

        public final void clearData() {
            this.values = new ArrayList();
            this.value = null;
            this.cachedVersion = 0;
            this.version = 0;
        }

        @Nullable
        public final Object computeValue() {
            if (this.cachedVersion != this.version) {
                int v = this.version;
                this.value = this.compute();
                this.cachedVersion = v;
            }
            return this.value;
        }

        private final Object compute() {
            Object object;
            ArrayList<OBDDataField<Object>> locValues = new ArrayList<OBDDataField<Object>>((Collection)this.values);
            if (locValues.size() > 0 && Intrinsics.areEqual(locValues.get(locValues.size() - 1), OBDDataField.Companion.getNO_DATA())) {
                return "N/A";
            }
            switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    if (this.averageTimeSeconds == 0 && locValues.size() > 0) {
                        object = locValues.get(locValues.size() - 1).getValue();
                        break;
                    }
                    object = INSTANCE.averageNumber(locValues);
                    break;
                }
                case 13: {
                    if (locValues.size() >= 2) {
                        object = Float.valueOf(this.calculateFuelConsumption(locValues));
                        break;
                    }
                    if (locValues.size() == 1) {
                        object = Float.valueOf(Float.NaN);
                        break;
                    }
                    object = null;
                    break;
                }
                case 14: {
                    if (locValues.size() >= 2) {
                        float result = INSTANCE.getFuelTank() * this.calculateFuelConsumption(locValues) / (float)100;
                        object = Float.valueOf(result > 100.0f ? Float.NaN : result);
                        break;
                    }
                    if (locValues.size() == 1) {
                        object = Float.valueOf(Float.NaN);
                        break;
                    }
                    object = null;
                    break;
                }
                case 15: {
                    if (locValues.size() >= 2) {
                        OBDDataField<Object> first = locValues.get(locValues.size() - 2);
                        OBDDataField<Object> last = locValues.get(locValues.size() - 1);
                        Object object2 = first.getValue();
                        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Number");
                        float f = ((Number)object2).floatValue();
                        Object object3 = last.getValue();
                        Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.Number");
                        float diffPerc = f - ((Number)object3).floatValue();
                        if (diffPerc > 0.0f) {
                            float difLiter = INSTANCE.getFuelTank() * diffPerc / (float)100;
                            double distance = this.getDistanceForTimePeriod(first.getTimestamp(), last.getTimestamp());
                            if (distance > 0.0) {
                                log.debug("l/100km. distance " + distance + "; difLiter " + difLiter + "; result " + (double)((float)100 * difLiter) / (distance / (double)1000));
                                double result = (double)((float)100 * difLiter) / (distance / (double)1000);
                                return result > 100.0 ? (Number)Float.valueOf(Float.NaN) : (Number)result;
                            }
                        }
                        object = null;
                        break;
                    }
                    if (locValues.size() == 1) {
                        object = Float.valueOf(Float.NaN);
                        break;
                    }
                    object = null;
                    break;
                }
                case 16: {
                    if (locValues.size() >= 2) {
                        double dist;
                        OBDDataField<Object> first = locValues.get(locValues.size() - 2);
                        OBDDataField<Object> last = locValues.get(locValues.size() - 1);
                        Object object4 = first.getValue();
                        Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type kotlin.Number");
                        float f = ((Number)object4).floatValue();
                        Object object5 = last.getValue();
                        Intrinsics.checkNotNull((Object)object5, (String)"null cannot be cast to non-null type kotlin.Number");
                        float diffPerc = f - ((Number)object5).floatValue();
                        if (diffPerc > 0.0f && (dist = this.getDistanceForTimePeriod(first.getTimestamp(), last.getTimestamp())) > 0.0) {
                            float lastPerc = ((Number)last.getValue()).floatValue();
                            log.debug("left km. fuelLvl " + lastPerc + "; distance " + dist + "; difPercent " + diffPerc + "; result " + (double)lastPerc * dist / (double)diffPerc);
                            return (double)lastPerc * dist / (double)diffPerc;
                        }
                        object = null;
                        break;
                    }
                    if (locValues.size() == 1) {
                        object = Float.valueOf(Float.NaN);
                        break;
                    }
                    object = null;
                    break;
                }
                case 17: {
                    if (locValues.size() > 0) {
                        Object object6 = locValues.get(locValues.size() - 1).getValue();
                        Intrinsics.checkNotNull((Object)object6, (String)"null cannot be cast to non-null type kotlin.Float");
                        object = (Float)object6;
                        break;
                    }
                    object = null;
                    break;
                }
                case 18: {
                    if (locValues.size() > 0) {
                        float f = INSTANCE.getFuelTank();
                        Object object7 = locValues.get(locValues.size() - 1).getValue();
                        Intrinsics.checkNotNull((Object)object7, (String)"null cannot be cast to non-null type kotlin.Float");
                        object = Float.valueOf(f * ((Float)object7).floatValue() / (float)100);
                        break;
                    }
                    object = null;
                    break;
                }
                case 19: 
                case 20: 
                case 21: {
                    if (locValues.size() > 0) {
                        object = locValues.get(locValues.size() - 1).getValue();
                        break;
                    }
                    object = null;
                    break;
                }
                case 22: {
                    if (locValues.size() >= 2) {
                        OBDDataField<Object> first = locValues.get(locValues.size() - 2);
                        OBDDataField<Object> last = locValues.get(locValues.size() - 1);
                        Object object8 = first.getValue();
                        Intrinsics.checkNotNull((Object)object8, (String)"null cannot be cast to non-null type kotlin.Number");
                        float f = ((Number)object8).floatValue();
                        Object object9 = last.getValue();
                        Intrinsics.checkNotNull((Object)object9, (String)"null cannot be cast to non-null type kotlin.Number");
                        float diffPerc = f - ((Number)object9).floatValue();
                        if (diffPerc > 0.0f) {
                            float difLiter = INSTANCE.getFuelTank() * diffPerc / (float)100;
                            double distance = this.getDistanceForTimePeriod(first.getTimestamp(), last.getTimestamp());
                            if (distance > 0.0 && difLiter > 0.0f) {
                                double result = distance / (double)difLiter;
                                return result > 1000.0 ? (Number)Float.valueOf(Float.NaN) : (Number)result;
                            }
                        }
                        object = null;
                        break;
                    }
                    if (locValues.size() == 1) {
                        object = Float.valueOf(Float.NaN);
                        break;
                    }
                    object = null;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return object;
        }

        private final double getDistanceForTimePeriod(long startTime, long endTime) {
            int start;
            List<OBDLocation> localLocations = INSTANCE.getLocations();
            int end = localLocations.size() - 1;
            for (start = 0; start < localLocations.size() && localLocations.get(start).getTime() <= startTime; ++start) {
            }
            while (end >= 0 && localLocations.get(end).getTime() >= endTime) {
                --end;
            }
            double dist = 0.0;
            if (start < end) {
                int n = end;
                for (int k = start; k < n; ++k) {
                    dist += KMapUtils.INSTANCE.getDistance(localLocations.get(k).getLatLon(), localLocations.get(k + 1).getLatLon());
                }
            }
            return dist;
        }

        private final float calculateFuelConsumption(ArrayList<OBDDataField<Object>> locValues) {
            OBDDataField<Object> oBDDataField = locValues.get(locValues.size() - 2);
            Intrinsics.checkNotNullExpressionValue(oBDDataField, (String)"get(...)");
            OBDDataField<Object> first = oBDDataField;
            OBDDataField<Object> oBDDataField2 = locValues.get(locValues.size() - 1);
            Intrinsics.checkNotNullExpressionValue(oBDDataField2, (String)"get(...)");
            OBDDataField<Object> last = oBDDataField2;
            Object object = first.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Number");
            float f = ((Number)object).floatValue();
            Object object2 = last.getValue();
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Number");
            float diffPerc = f - ((Number)object2).floatValue();
            long diffTime = last.getTimestamp() - first.getTimestamp();
            return diffPerc / (float)diffTime * (float)1000 * (float)3600;
        }

        public final void acceptValue(@NotNull Map<OBDCommand, ? extends OBDDataField<Object>> value) {
            block12: {
                OBDDataField<Object> it;
                block13: {
                    Intrinsics.checkNotNullParameter(value, (String)"value");
                    OBDDataField<Object> oBDDataField = value.get((Object)this.type.getRequiredCommand());
                    if (oBDDataField == null) break block12;
                    it = oBDDataField;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it, OBDDataField.Companion.getNO_DATA())) break block13;
                    if (this.values.isEmpty()) {
                        int n = this.version;
                        this.version = n + 1;
                    }
                    Object[] objectArray = new OBDDataField[]{it};
                    this.values = CollectionsKt.mutableListOf((Object[])objectArray);
                    break block12;
                }
                switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: {
                        float f;
                        if (!((Collection)this.values).isEmpty()) {
                            Object object = this.values.get(this.values.size() - 1).getValue();
                            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Number");
                            f = ((Number)object).floatValue();
                        } else {
                            f = 0.0f;
                        }
                        float lastLvl = f;
                        Object object = it.getValue();
                        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Number");
                        float newlvl = ((Number)object).floatValue();
                        if (!this.values.isEmpty() && lastLvl == newlvl) break;
                        OBDDataField<Object> valueToAdd = it;
                        if (this.tmpValues.isEmpty() || Intrinsics.areEqual(((OBDDataField)CollectionsKt.last(this.tmpValues)).getValue(), (Object)Float.valueOf(newlvl))) {
                            log.debug("Fuel level increase found. last " + lastLvl + "; new " + newlvl + " tmpValues.size=" + this.tmpValues.size());
                            this.tmpValues = KCollectionUtils.INSTANCE.addToList((Collection)this.tmpValues, new OBDDataField<Float>(Float.valueOf(newlvl)));
                            if (this.tmpValues.size() >= 5) {
                                log.debug("New fuel level accepted");
                                valueToAdd = this.tmpValues.get(0);
                                this.tmpValues = CollectionsKt.emptyList();
                            } else {
                                valueToAdd = null;
                            }
                        } else if (!((Collection)this.tmpValues).isEmpty() && !Intrinsics.areEqual(((OBDDataField)CollectionsKt.last(this.tmpValues)).getValue(), (Object)Float.valueOf(newlvl))) {
                            log.debug("Last fuel level increase changed. last " + lastLvl + "; last change " + ((OBDDataField)CollectionsKt.last(this.tmpValues)).getValue() + " new " + newlvl);
                            Object[] objectArray = new OBDDataField[]{new OBDDataField<Float>(Float.valueOf(newlvl))};
                            this.tmpValues = CollectionsKt.arrayListOf((Object[])objectArray);
                            valueToAdd = null;
                        }
                        OBDDataField<Object> oBDDataField = valueToAdd;
                        if (oBDDataField != null) {
                            OBDDataField<Object> newData = oBDDataField;
                            boolean bl = false;
                            int n = this.version;
                            this.version = n + 1;
                            this.values = KCollectionUtils.INSTANCE.addToList((Collection)this.values, newData);
                        }
                        break;
                    }
                    default: {
                        int n = this.version;
                        this.version = n + 1;
                        this.values = KCollectionUtils.INSTANCE.addToList((Collection)this.values, it);
                    }
                }
            }
        }

        public final void resetLocations() {
            this.values = new ArrayList();
        }

        public final void cleanup(long now) {
            int inWindow;
            int timeout = this.averageTimeSeconds > 0 ? this.averageTimeSeconds : INSTANCE.getTimeoutForInstantValuesSeconds();
            for (inWindow = 0; inWindow < this.values.size() && this.values.get(inWindow).getTimestamp() < now - (long)(timeout * 1000); ++inWindow) {
            }
            if (inWindow > 0 && inWindow < this.values.size() - 1) {
                this.values = this.values.subList(inWindow, this.values.size());
            }
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[OBDTypeWidget.values().length];
                try {
                    nArray[OBDTypeWidget.TEMPERATURE_AMBIENT.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OBDTypeWidget.TEMPERATURE_COOLANT.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OBDTypeWidget.TEMPERATURE_INTAKE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OBDTypeWidget.ENGINE_OIL_TEMPERATURE.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OBDTypeWidget.SPEED.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OBDTypeWidget.BATTERY_VOLTAGE.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OBDTypeWidget.ADAPTER_BATTERY_VOLTAGE.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OBDTypeWidget.FUEL_CONSUMPTION_RATE_SENSOR.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OBDTypeWidget.FUEL_PRESSURE.ordinal()] = 9;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OBDTypeWidget.THROTTLE_POSITION.ordinal()] = 10;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OBDTypeWidget.CALCULATED_ENGINE_LOAD.ordinal()] = 11;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OBDTypeWidget.RPM.ordinal()] = 12;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OBDTypeWidget.FUEL_CONSUMPTION_RATE_PERCENT_HOUR.ordinal()] = 13;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OBDTypeWidget.FUEL_CONSUMPTION_RATE_LITER_HOUR.ordinal()] = 14;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OBDTypeWidget.FUEL_CONSUMPTION_RATE_LITER_KM.ordinal()] = 15;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OBDTypeWidget.FUEL_LEFT_KM.ordinal()] = 16;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OBDTypeWidget.FUEL_LEFT_PERCENT.ordinal()] = 17;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OBDTypeWidget.FUEL_LEFT_LITER.ordinal()] = 18;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OBDTypeWidget.FUEL_TYPE.ordinal()] = 19;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OBDTypeWidget.ENGINE_RUNTIME.ordinal()] = 20;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OBDTypeWidget.VIN.ordinal()] = 21;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OBDTypeWidget.FUEL_CONSUMPTION_RATE_M_PER_LITER.ordinal()] = 22;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\b\u001a\u00020\u00032\b\u0010\t\u001a\u0004\u0018\u00010\u0001H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lnet/osmand/shared/obd/OBDDataComputer$OBDComputerWidgetFormatter;", "", "pattern", "", "<init>", "(Ljava/lang/String;)V", "getPattern", "()Ljava/lang/String;", "format", "v", "OsmAnd-shared"})
    public static class OBDComputerWidgetFormatter {
        @NotNull
        private final String pattern;

        public OBDComputerWidgetFormatter(@NotNull String pattern) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            this.pattern = pattern;
        }

        public /* synthetic */ OBDComputerWidgetFormatter(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "%s";
            }
            this(string);
        }

        @NotNull
        public final String getPattern() {
            return this.pattern;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public String format(@Nullable Object v) {
            String string;
            if (v == null) {
                string = "-";
            } else {
                void var2_2;
                String ret = "";
                try {
                    Object[] objectArray = new Object[]{v};
                    ret = StringExtensionsKt.format(this.pattern, objectArray);
                }
                catch (Throwable error) {
                    Logger.error$default(log, error.getMessage(), null, 2, null);
                }
                string = var2_2;
            }
            return string;
        }

        public OBDComputerWidgetFormatter() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lnet/osmand/shared/obd/OBDDataComputer$OBDLocation;", "", "time", "", "latLon", "Lnet/osmand/shared/data/KLatLon;", "<init>", "(JLnet/osmand/shared/data/KLatLon;)V", "getTime", "()J", "getLatLon", "()Lnet/osmand/shared/data/KLatLon;", "OsmAnd-shared"})
    public static final class OBDLocation {
        private final long time;
        @NotNull
        private final KLatLon latLon;

        public OBDLocation(long time, @NotNull KLatLon latLon) {
            Intrinsics.checkNotNullParameter((Object)latLon, (String)"latLon");
            this.time = time;
            this.latLon = latLon;
        }

        public final long getTime() {
            return this.time;
        }

        @NotNull
        public final KLatLon getLatLon() {
            return this.latLon;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b$\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B3\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0006\u0010.\u001a\u00020\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b j\u0002\b!j\u0002\b\"j\u0002\b#j\u0002\b$j\u0002\b%j\u0002\b&j\u0002\b'j\u0002\b(j\u0002\b)j\u0002\b*j\u0002\b+j\u0002\b,j\u0002\b-\u00a8\u0006/"}, d2={"Lnet/osmand/shared/obd/OBDDataComputer$OBDTypeWidget;", "", "locationNeeded", "", "requiredCommand", "Lnet/osmand/shared/obd/OBDCommand;", "nameId", "", "formatter", "Lnet/osmand/shared/obd/OBDDataComputer$OBDComputerWidgetFormatter;", "defaultAverageTime", "", "<init>", "(Ljava/lang/String;IZLnet/osmand/shared/obd/OBDCommand;Ljava/lang/String;Lnet/osmand/shared/obd/OBDDataComputer$OBDComputerWidgetFormatter;I)V", "getLocationNeeded", "()Z", "getRequiredCommand", "()Lnet/osmand/shared/obd/OBDCommand;", "getNameId", "()Ljava/lang/String;", "getFormatter", "()Lnet/osmand/shared/obd/OBDDataComputer$OBDComputerWidgetFormatter;", "getDefaultAverageTime", "()I", "SPEED", "RPM", "ENGINE_RUNTIME", "FUEL_PRESSURE", "FUEL_LEFT_KM", "CALCULATED_ENGINE_LOAD", "THROTTLE_POSITION", "FUEL_LEFT_PERCENT", "FUEL_LEFT_LITER", "FUEL_CONSUMPTION_RATE_PERCENT_HOUR", "FUEL_CONSUMPTION_RATE_LITER_KM", "FUEL_CONSUMPTION_RATE_M_PER_LITER", "FUEL_CONSUMPTION_RATE_LITER_HOUR", "FUEL_CONSUMPTION_RATE_SENSOR", "TEMPERATURE_INTAKE", "ENGINE_OIL_TEMPERATURE", "TEMPERATURE_AMBIENT", "BATTERY_VOLTAGE", "ADAPTER_BATTERY_VOLTAGE", "FUEL_TYPE", "VIN", "TEMPERATURE_COOLANT", "getTitle", "OsmAnd-shared"})
    public static final class OBDTypeWidget
    extends Enum<OBDTypeWidget> {
        private final boolean locationNeeded;
        @NotNull
        private final OBDCommand requiredCommand;
        @NotNull
        private final String nameId;
        @NotNull
        private final OBDComputerWidgetFormatter formatter;
        private final int defaultAverageTime;
        public static final /* enum */ OBDTypeWidget SPEED = new OBDTypeWidget("SPEED", 0, false, OBDCommand.OBD_SPEED_COMMAND, "obd_widget_vehicle_speed", new OBDComputerWidgetFormatter("%.0f"), 0, 16, null);
        public static final /* enum */ OBDTypeWidget RPM = new OBDTypeWidget("RPM", 1, false, OBDCommand.OBD_RPM_COMMAND, "obd_widget_engine_speed", new OBDComputerWidgetFormatter("%d"), 0, 16, null);
        public static final /* enum */ OBDTypeWidget ENGINE_RUNTIME = new OBDTypeWidget("ENGINE_RUNTIME", 2, false, OBDCommand.OBD_ENGINE_RUNTIME_COMMAND, "obd_engine_runtime", new OBDComputerWidgetFormatter("%s"), 0, 16, null);
        public static final /* enum */ OBDTypeWidget FUEL_PRESSURE = new OBDTypeWidget("FUEL_PRESSURE", 3, false, OBDCommand.OBD_FUEL_PRESSURE_COMMAND, "obd_fuel_pressure", new OBDComputerWidgetFormatter("%d"), 0, 16, null);
        public static final /* enum */ OBDTypeWidget FUEL_LEFT_KM = new OBDTypeWidget("FUEL_LEFT_KM", 4, true, OBDCommand.OBD_FUEL_LEVEL_COMMAND, "remaining_fuel", new OBDComputerWidgetFormatter("%.0f"), 0, 16, null);
        public static final /* enum */ OBDTypeWidget CALCULATED_ENGINE_LOAD = new OBDTypeWidget("CALCULATED_ENGINE_LOAD", 5, false, OBDCommand.OBD_CALCULATED_ENGINE_LOAD_COMMAND, "obd_calculated_engine_load", new OBDComputerWidgetFormatter("%.0f"), 0, 16, null);
        public static final /* enum */ OBDTypeWidget THROTTLE_POSITION = new OBDTypeWidget("THROTTLE_POSITION", 6, false, OBDCommand.OBD_THROTTLE_POSITION_COMMAND, "obd_throttle_position", new OBDComputerWidgetFormatter("%.0f"), 0, 16, null);
        public static final /* enum */ OBDTypeWidget FUEL_LEFT_PERCENT = new OBDTypeWidget("FUEL_LEFT_PERCENT", 7, false, OBDCommand.OBD_FUEL_LEVEL_COMMAND, "remaining_fuel", new OBDComputerWidgetFormatter("%.1f"), 0, 16, null);
        public static final /* enum */ OBDTypeWidget FUEL_LEFT_LITER = new OBDTypeWidget("FUEL_LEFT_LITER", 8, false, OBDCommand.OBD_FUEL_LEVEL_COMMAND, "remaining_fuel", new OBDComputerWidgetFormatter("%.1f"), 0, 16, null);
        public static final /* enum */ OBDTypeWidget FUEL_CONSUMPTION_RATE_PERCENT_HOUR = new OBDTypeWidget(false, OBDCommand.OBD_FUEL_LEVEL_COMMAND, "obd_fuel_consumption_rate_percent_hour", new OBDComputerWidgetFormatter("%.1f"), 300);
        public static final /* enum */ OBDTypeWidget FUEL_CONSUMPTION_RATE_LITER_KM = new OBDTypeWidget(true, OBDCommand.OBD_FUEL_LEVEL_COMMAND, "obd_fuel_consumption_rate", new OBDComputerWidgetFormatter("%.1f"), 300);
        public static final /* enum */ OBDTypeWidget FUEL_CONSUMPTION_RATE_M_PER_LITER = new OBDTypeWidget(true, OBDCommand.OBD_FUEL_LEVEL_COMMAND, "obd_fuel_consumption_rate", new OBDComputerWidgetFormatter("%.1f"), 300);
        public static final /* enum */ OBDTypeWidget FUEL_CONSUMPTION_RATE_LITER_HOUR = new OBDTypeWidget(false, OBDCommand.OBD_FUEL_LEVEL_COMMAND, "obd_fuel_consumption_rate_liter_hour", new OBDComputerWidgetFormatter("%.1f"), 300);
        public static final /* enum */ OBDTypeWidget FUEL_CONSUMPTION_RATE_SENSOR = new OBDTypeWidget("FUEL_CONSUMPTION_RATE_SENSOR", 13, false, OBDCommand.OBD_FUEL_CONSUMPTION_RATE_COMMAND, "obd_fuel_consumption_rate_scanner", new OBDComputerWidgetFormatter("%.2f"), 0, 16, null);
        public static final /* enum */ OBDTypeWidget TEMPERATURE_INTAKE = new OBDTypeWidget("TEMPERATURE_INTAKE", 14, false, OBDCommand.OBD_AIR_INTAKE_TEMP_COMMAND, "obd_air_intake_temp", new OBDComputerWidgetFormatter("%.0f"), 0, 16, null);
        public static final /* enum */ OBDTypeWidget ENGINE_OIL_TEMPERATURE = new OBDTypeWidget("ENGINE_OIL_TEMPERATURE", 15, false, OBDCommand.OBD_ENGINE_OIL_TEMPERATURE_COMMAND, "obd_engine_oil_temperature", new OBDComputerWidgetFormatter("%.0f"), 0, 16, null);
        public static final /* enum */ OBDTypeWidget TEMPERATURE_AMBIENT = new OBDTypeWidget("TEMPERATURE_AMBIENT", 16, false, OBDCommand.OBD_AMBIENT_AIR_TEMPERATURE_COMMAND, "obd_ambient_air_temp", new OBDComputerWidgetFormatter("%.0f"), 0, 16, null);
        public static final /* enum */ OBDTypeWidget BATTERY_VOLTAGE = new OBDTypeWidget("BATTERY_VOLTAGE", 17, false, OBDCommand.OBD_BATTERY_VOLTAGE_COMMAND, "obd_battery_voltage", new OBDComputerWidgetFormatter("%.2f"), 0, 16, null);
        public static final /* enum */ OBDTypeWidget ADAPTER_BATTERY_VOLTAGE = new OBDTypeWidget("ADAPTER_BATTERY_VOLTAGE", 18, false, OBDCommand.OBD_ALT_BATTERY_VOLTAGE_COMMAND, "obd_alt_battery_voltage", new OBDComputerWidgetFormatter("%.1f"), 0, 16, null);
        public static final /* enum */ OBDTypeWidget FUEL_TYPE = new OBDTypeWidget("FUEL_TYPE", 19, false, OBDCommand.OBD_FUEL_TYPE_COMMAND, "obd_fuel_type", new OBDFuelTypeFormatter(), 0, 16, null);
        public static final /* enum */ OBDTypeWidget VIN = new OBDTypeWidget("VIN", 20, false, OBDCommand.OBD_VIN_COMMAND, "obd_vin", new OBDComputerWidgetFormatter("%s"), 0, 16, null);
        public static final /* enum */ OBDTypeWidget TEMPERATURE_COOLANT = new OBDTypeWidget("TEMPERATURE_COOLANT", 21, false, OBDCommand.OBD_ENGINE_COOLANT_TEMP_COMMAND, "obd_engine_coolant_temp", new OBDComputerWidgetFormatter("%.0f"), 0, 16, null);
        private static final /* synthetic */ OBDTypeWidget[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private OBDTypeWidget(boolean locationNeeded, OBDCommand requiredCommand, String nameId, OBDComputerWidgetFormatter formatter, int defaultAverageTime) {
            this.locationNeeded = locationNeeded;
            this.requiredCommand = requiredCommand;
            this.nameId = nameId;
            this.formatter = formatter;
            this.defaultAverageTime = defaultAverageTime;
        }

        /* synthetic */ OBDTypeWidget(String string, int n, boolean bl, OBDCommand oBDCommand, String string2, OBDComputerWidgetFormatter oBDComputerWidgetFormatter, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 0x10) != 0) {
                n2 = 0;
            }
            this(bl, oBDCommand, string2, oBDComputerWidgetFormatter, n2);
        }

        public final boolean getLocationNeeded() {
            return this.locationNeeded;
        }

        @NotNull
        public final OBDCommand getRequiredCommand() {
            return this.requiredCommand;
        }

        @NotNull
        public final String getNameId() {
            return this.nameId;
        }

        @NotNull
        public final OBDComputerWidgetFormatter getFormatter() {
            return this.formatter;
        }

        public final int getDefaultAverageTime() {
            return this.defaultAverageTime;
        }

        @NotNull
        public final String getTitle() {
            return Localization.INSTANCE.getString(this.nameId);
        }

        public static OBDTypeWidget[] values() {
            return (OBDTypeWidget[])$VALUES.clone();
        }

        public static OBDTypeWidget valueOf(String value) {
            return Enum.valueOf(OBDTypeWidget.class, value);
        }

        @NotNull
        public static EnumEntries<OBDTypeWidget> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = oBDTypeWidgetArray = new OBDTypeWidget[]{OBDTypeWidget.SPEED, OBDTypeWidget.RPM, OBDTypeWidget.ENGINE_RUNTIME, OBDTypeWidget.FUEL_PRESSURE, OBDTypeWidget.FUEL_LEFT_KM, OBDTypeWidget.CALCULATED_ENGINE_LOAD, OBDTypeWidget.THROTTLE_POSITION, OBDTypeWidget.FUEL_LEFT_PERCENT, OBDTypeWidget.FUEL_LEFT_LITER, OBDTypeWidget.FUEL_CONSUMPTION_RATE_PERCENT_HOUR, OBDTypeWidget.FUEL_CONSUMPTION_RATE_LITER_KM, OBDTypeWidget.FUEL_CONSUMPTION_RATE_M_PER_LITER, OBDTypeWidget.FUEL_CONSUMPTION_RATE_LITER_HOUR, OBDTypeWidget.FUEL_CONSUMPTION_RATE_SENSOR, OBDTypeWidget.TEMPERATURE_INTAKE, OBDTypeWidget.ENGINE_OIL_TEMPERATURE, OBDTypeWidget.TEMPERATURE_AMBIENT, OBDTypeWidget.BATTERY_VOLTAGE, OBDTypeWidget.ADAPTER_BATTERY_VOLTAGE, OBDTypeWidget.FUEL_TYPE, OBDTypeWidget.VIN, OBDTypeWidget.TEMPERATURE_COOLANT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

