/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.wiki.commonswiki.parser;

import java.util.ArrayList;
import java.util.List;
import net.osmand.wiki.commonswiki.parser.ParserUtils;

public final class LicenseParser {
    private static final String SELF_TEMPLATE = "self";
    private static final String STATUS_PARAM = "status=";
    private static final String COUNTRY_PARAM = "country";
    private static final String AUTHOR_PARAM = "author";

    private LicenseParser() {
    }

    public static String parse(List<String> licenseBlocks) {
        if (licenseBlocks == null || licenseBlocks.isEmpty()) {
            return null;
        }
        ArrayList<String> licenses = new ArrayList<String>();
        for (String block : licenseBlocks) {
            String cleaned = LicenseParser.cleanBlock(block);
            List<String> parts = ParserUtils.splitByPipeOutsideBraces(cleaned, false);
            for (String part : parts) {
                String license = LicenseParser.processLicensePart(part);
                if (license == null || license.isEmpty()) continue;
                licenses.add(license);
            }
        }
        return licenses.isEmpty() ? null : String.join((CharSequence)" - ", licenses);
    }

    public static String parseFromInformationBlock(String licenseValue) {
        if (licenseValue == null || licenseValue.isEmpty()) {
            return null;
        }
        if (licenseValue.startsWith("{{") && licenseValue.endsWith("}}")) {
            return LicenseParser.extractLicenseFromTemplate(licenseValue);
        }
        return licenseValue;
    }

    private static String extractLicenseFromTemplate(String template) {
        String templateContent = ParserUtils.extractTemplateContent(template);
        if (templateContent == null) {
            return null;
        }
        List<String> templateParts = ParserUtils.splitByPipeOutsideBraces(templateContent, true);
        if (templateParts.isEmpty()) {
            return null;
        }
        String templateName = templateParts.get(0).trim().toLowerCase();
        if (templateName.contains("flickreviewr") || templateName.contains("reviewed")) {
            for (int i = templateParts.size() - 1; i > 0; --i) {
                String part = templateParts.get(i).trim();
                if (part.isEmpty() || part.startsWith("http") || part.length() <= 10) continue;
                return part;
            }
        }
        return templateParts.get(0).trim();
    }

    public static String process(String license) {
        if (license == null || license.isEmpty()) {
            return license;
        }
        String cleaned = ParserUtils.removeWikiLinkBrackets(license);
        String upper = cleaned.replace("CC-", "CC ").replace("PD-", "PD ").replace("-expired", " expired").toUpperCase();
        upper = upper.replaceAll("\\s+-\\s+[A-Z0-9_]+=.*$", "");
        return upper;
    }

    private static String cleanBlock(String block) {
        if (block == null) {
            return "";
        }
        return ParserUtils.normalizeWhitespace(block);
    }

    private static String processLicensePart(String part) {
        if (LicenseParser.shouldSkipPart(part = part.trim())) {
            return null;
        }
        if (part.contains("|")) {
            part = LicenseParser.processNestedPipes(part);
        }
        if (part.toLowerCase().startsWith(AUTHOR_PARAM)) {
            return LicenseParser.extractAuthorLicense(part);
        }
        if (part.startsWith("{{") && part.endsWith("}}")) {
            return LicenseParser.extractLicenseFromTemplate(part);
        }
        return part;
    }

    private static boolean shouldSkipPart(String part) {
        return part.equalsIgnoreCase(SELF_TEMPLATE) || part.contains(STATUS_PARAM);
    }

    private static String processNestedPipes(String part) {
        List<String> subParts = ParserUtils.splitByPipeOutsideBraces(part, true);
        String result = part;
        for (String subPart : subParts) {
            String subPartLc = subPart.toLowerCase();
            if (!subPartLc.matches(".*country\\s*=\\s*.*") && !subPartLc.matches(".*author\\s*=\\s*.*")) continue;
            result = result.replace("|" + subPart, "");
        }
        return result.replace("|", " - ");
    }

    private static String extractAuthorLicense(String part) {
        List<String> authorParts = ParserUtils.splitByPipeOutsideBraces(part, true);
        authorParts.removeIf(p -> p.trim().toLowerCase().startsWith(AUTHOR_PARAM));
        if (authorParts.isEmpty()) {
            return null;
        }
        return String.join((CharSequence)" - ", authorParts);
    }
}

