/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common;

import java.io.PrintStream;

public class ExceptionUtils {
    public static void dumpStack(PrintStream printStream) {
        ExceptionUtils.dumpStack(printStream, 1, -1);
    }

    public static void dumpStack(PrintStream printStream, int n, int n2) {
        ExceptionUtils.dumpStack(printStream, new Exception(""), n + 1, n2);
    }

    public static void dumpStack(PrintStream printStream, Throwable throwable, int n, int n2) {
        ExceptionUtils.dumpStack(printStream, throwable.getStackTrace(), n, n2);
    }

    public static void dumpStack(PrintStream printStream, StackTraceElement[] stackTraceElementArray, int n, int n2) {
        if (null == stackTraceElementArray) {
            return;
        }
        int n3 = 0 > n2 ? stackTraceElementArray.length : Math.min(n2 + n, stackTraceElementArray.length);
        for (int i = n; i < n3; ++i) {
            printStream.println("    [" + i + "]: " + stackTraceElementArray[i]);
        }
    }

    public static void dumpThrowable(String string, Throwable throwable) {
        System.err.println("Caught " + string + " " + throwable.getClass().getSimpleName() + ": " + throwable.getMessage() + " on thread " + Thread.currentThread().getName());
        ExceptionUtils.dumpStack(System.err, throwable.getStackTrace(), 0, -1);
        int n = 1;
        for (Throwable throwable2 = throwable.getCause(); null != throwable2; throwable2 = throwable2.getCause()) {
            System.err.println("Caused[" + n + "] by " + throwable2.getClass().getSimpleName() + ": " + throwable2.getMessage() + " on thread " + Thread.currentThread().getName());
            ExceptionUtils.dumpStack(System.err, throwable2.getStackTrace(), 0, -1);
            ++n;
        }
    }
}

