/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.wiki.commonswiki.parser;

import info.bliki.wiki.filter.ITextConverter;
import info.bliki.wiki.filter.PlainTextConverter;
import info.bliki.wiki.model.WikiModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.osmand.wiki.commonswiki.parser.ParserUtils;

public final class DescriptionParser {
    private static final int MAX_LANGUAGE_CODE_LENGTH = 5;
    private static final Pattern LINK_PATTERN = Pattern.compile("\\[(https?://\\S+)\\s([^]]+)]");
    private static final Pattern PROVIDED_DESC_PATTERN = Pattern.compile("\\w+\\s+provided\\s+description\\s*:", 2);

    private DescriptionParser() {
    }

    public static Map<String, String> parse(String line) throws IOException {
        HashMap<String, String> result = new HashMap<String, String>();
        String descriptionBlock = line;
        descriptionBlock = DescriptionParser.parseMultilingualDescriptions(descriptionBlock, result);
        if (result.isEmpty()) {
            DescriptionParser.parsePlainTextDescription(descriptionBlock, result);
        }
        return result;
    }

    private static String parseMultilingualDescriptions(String descriptionBlock, Map<String, String> result) {
        LanguageBlock block;
        while (descriptionBlock.contains("{{") && descriptionBlock.contains("}}") && (block = DescriptionParser.extractLanguageBlock(descriptionBlock)) != null) {
            String cleanedDescription = DescriptionParser.cleanDescriptionText(block.content);
            result.put(block.language, cleanedDescription);
            descriptionBlock = descriptionBlock.substring(block.endIndex).trim();
        }
        return descriptionBlock;
    }

    private static LanguageBlock extractLanguageBlock(String descriptionBlock) {
        int langStart = descriptionBlock.indexOf("{{") + 2;
        int langEnd = descriptionBlock.indexOf("|", langStart);
        if (langEnd == -1) {
            return null;
        }
        String lang = descriptionBlock.substring(langStart, langEnd).trim();
        if (lang.length() > 5) {
            return null;
        }
        int descStart = DescriptionParser.findDescriptionStart(descriptionBlock, langEnd);
        int descEnd = DescriptionParser.findDescriptionEnd(descriptionBlock, descStart);
        if (descEnd == -1) {
            return null;
        }
        String content = descriptionBlock.substring(descStart, descEnd);
        return new LanguageBlock(lang, content, descEnd);
    }

    private static int findDescriptionStart(String descriptionBlock, int langEnd) {
        int explicitStart = descriptionBlock.indexOf("|1=", langEnd);
        if (explicitStart != -1) {
            return explicitStart + 3;
        }
        return langEnd + 1;
    }

    private static int findDescriptionEnd(String descriptionBlock, int startIndex) {
        int openBraces = 1;
        int currentIndex = startIndex;
        while (openBraces > 0 && currentIndex < descriptionBlock.length()) {
            if (descriptionBlock.startsWith("{{", currentIndex)) {
                ++openBraces;
                currentIndex += 2;
                continue;
            }
            if (descriptionBlock.startsWith("}}", currentIndex)) {
                --openBraces;
                currentIndex += 2;
                continue;
            }
            ++currentIndex;
        }
        return openBraces == 0 ? currentIndex : -1;
    }

    private static String cleanDescriptionText(String description) {
        return description.replaceAll("\\{\\{[^|]+\\|", "").replaceAll("}}", "").replaceAll("\\[\\[:[^|]+\\|", "").replaceAll("]]", "").replaceAll("\\{\\{", "").replaceAll("}$", "").trim();
    }

    private static void parsePlainTextDescription(String descriptionBlock, Map<String, String> result) throws IOException {
        String description = ParserUtils.extractFieldValue(descriptionBlock, "description");
        if (description == null) {
            description = descriptionBlock.trim();
        }
        if ((description = description.trim()).startsWith("{{")) {
            String plainText = DescriptionParser.renderWikiText(description);
            if ((plainText = plainText.trim()).isEmpty() || plainText.startsWith("Template:")) {
                plainText = DescriptionParser.extractTemplateName(description);
            }
            if (!plainText.isEmpty()) {
                result.put("en", plainText);
            }
            return;
        }
        Matcher matcher = PROVIDED_DESC_PATTERN.matcher(description);
        if (matcher.find() && matcher.start() < description.length() / 3) {
            description = description.substring(matcher.end()).trim();
        }
        String plainText = DescriptionParser.renderWikiText(description);
        plainText = plainText.trim();
        List<String> links = DescriptionParser.extractLinks(description);
        if (!links.isEmpty()) {
            plainText = DescriptionParser.appendLinks(plainText, links);
        }
        result.put("en", plainText);
    }

    private static String renderWikiText(String description) throws IOException {
        WikiModel wikiModel = new WikiModel("", "");
        return wikiModel.render((ITextConverter)new PlainTextConverter(true), description);
    }

    private static String extractTemplateName(String template) {
        if (!template.startsWith("{{") || !template.endsWith("}}")) {
            return "";
        }
        String content = template.substring(2, template.length() - 2).trim();
        List<String> parts = ParserUtils.splitByPipeOutsideBraces(content, true);
        if (parts.isEmpty()) {
            return "";
        }
        return parts.get(0).trim();
    }

    private static List<String> extractLinks(String description) {
        ArrayList<String> links = new ArrayList<String>();
        Matcher matcher = LINK_PATTERN.matcher(description);
        while (matcher.find()) {
            links.add(matcher.group(1));
        }
        return links;
    }

    private static String appendLinks(String text, List<String> links) {
        StringBuilder result = new StringBuilder(text);
        result.append("\n\nLinks:");
        for (int i = 0; i < links.size(); ++i) {
            result.append("\n[").append(i + 1).append("] ").append(links.get(i));
        }
        return result.toString();
    }

    private record LanguageBlock(String language, String content, int endIndex) {
    }
}

