/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.wiki.commonswiki.parser;

import java.util.Arrays;
import java.util.List;
import net.osmand.wiki.commonswiki.parser.ParserUtils;

public final class AuthorParser {
    private AuthorParser() {
    }

    public static String parse(String line) {
        String normalized = AuthorParser.stripAuthorPrefix(line);
        return AuthorParser.tryParserChain(normalized);
    }

    private static String tryParserChain(String normalized) {
        String[] parsers;
        for (String result : parsers = new String[]{AuthorParser.tryFromTemplateWithPipes(normalized), AuthorParser.tryFromSimpleTemplate(normalized), AuthorParser.tryFromParts(normalized)}) {
            if (result == null) continue;
            return result;
        }
        return "Unknown";
    }

    private static String stripAuthorPrefix(String line) {
        String authorValue = ParserUtils.extractFieldValue(line, "author");
        if (authorValue != null) {
            return authorValue;
        }
        String photographerValue = ParserUtils.extractFieldValue(line, "photographer");
        if (photographerValue != null) {
            return photographerValue;
        }
        return line.trim();
    }

    private static String tryFromTemplateWithPipes(String line) {
        if (!(line.startsWith("{{") && line.endsWith("}}") && line.contains("|"))) {
            return null;
        }
        String templateContent = line.substring(2, line.length() - 2);
        List<String> params = ParserUtils.splitByPipeOutsideBraces(templateContent, true);
        if (params.isEmpty()) {
            return null;
        }
        String fromAuthorParam = AuthorParser.findAuthorParameter(params);
        if (fromAuthorParam != null) {
            return fromAuthorParam;
        }
        for (int i = 1; i < params.size(); ++i) {
            String param = params.get(i).trim();
            String result = AuthorParser.tryPartFormats(param);
            if (result == null) continue;
            return result;
        }
        return AuthorParser.tryUserCreatorFromTemplateName(params.get(0).trim());
    }

    private static String findAuthorParameter(List<String> params) {
        for (int i = 1; i < params.size(); ++i) {
            String authorValue;
            String author;
            String param = params.get(i).trim();
            if (!param.toLowerCase().startsWith("author=") || (author = AuthorParser.processAuthorValue(authorValue = param.substring(7).trim())).equals("Unknown")) continue;
            return AuthorParser.cleanAuthor(author);
        }
        return null;
    }

    private static String tryUserCreatorFromTemplateName(String templateName) {
        String extracted = AuthorParser.extractUserCreatorName(templateName);
        return extracted != null ? AuthorParser.cleanAuthor(extracted) : null;
    }

    private static String tryFromSimpleTemplate(String line) {
        if (!line.startsWith("{{") || !line.endsWith("}}") || line.contains("|")) {
            return null;
        }
        String content = line.substring(2, line.length() - 2).trim();
        String extracted = AuthorParser.extractUserCreatorName(content);
        if (extracted != null) {
            return AuthorParser.cleanAuthor(extracted);
        }
        if (AuthorParser.isSimpleText(content)) {
            return AuthorParser.cleanAuthor(content);
        }
        return null;
    }

    private static String extractUserCreatorName(String content) {
        String contentLc = content.toLowerCase();
        if (!contentLc.startsWith("user:") && !contentLc.startsWith("creator:")) {
            return null;
        }
        String namePart = content.substring(content.indexOf(":") + 1);
        int slashPos = namePart.indexOf("/");
        if (slashPos != -1) {
            namePart = namePart.substring(0, slashPos);
        }
        return namePart.trim();
    }

    private static String tryFromParts(String line) {
        List<String> parts = ParserUtils.splitByPipeOutsideBraces(line, true);
        for (String part : parts) {
            String result = AuthorParser.tryPartFormats(part.trim());
            if (result == null) continue;
            return result;
        }
        return AuthorParser.tryFallbackFromSinglePart(parts);
    }

    private static String tryPartFormats(String part) {
        String result = AuthorParser.tryEditedBy(part);
        if (result != null) {
            return result;
        }
        result = AuthorParser.tryPublisher(part);
        if (result != null) {
            return result;
        }
        result = AuthorParser.tryHttpLink(part);
        if (result != null) {
            return result;
        }
        result = AuthorParser.tryWikiLink(part);
        if (result != null) {
            return result;
        }
        return AuthorParser.tryUserTemplateInPart(part);
    }

    private static String tryFallbackFromSinglePart(List<String> parts) {
        if (parts.size() != 1) {
            return null;
        }
        String singlePart = parts.get(0).trim();
        if (AuthorParser.isSimpleText(singlePart)) {
            return AuthorParser.cleanAuthor(singlePart);
        }
        return null;
    }

    private static boolean isSimpleText(String text) {
        return !text.startsWith("{{") && !text.startsWith("[[") && !text.startsWith("[http");
    }

    private static String tryEditedBy(String part) {
        if (part.contains("edited by")) {
            String author = part.substring(0, part.indexOf("edited by")).trim();
            return AuthorParser.cleanAuthor(author);
        }
        return null;
    }

    private static String tryPublisher(String part) {
        if (part.startsWith("Publisher:")) {
            String author = part.substring("Publisher:".length()).trim();
            return AuthorParser.cleanAuthor(author);
        }
        return null;
    }

    private static String tryHttpLink(String part) {
        if (!part.startsWith("[http")) {
            return null;
        }
        if (part.contains(" ")) {
            int spacePos = part.indexOf(" ", 5);
            int closePos = part.indexOf("]", spacePos);
            if (closePos != -1) {
                return AuthorParser.cleanAuthor(part.substring(spacePos + 1, closePos).trim());
            }
        } else {
            return "Unknown";
        }
        return null;
    }

    private static String tryWikiLink(String part) {
        if (!part.startsWith("[[") || !part.endsWith("]]")) {
            return null;
        }
        String linkContent = part.substring(2, part.length() - 2);
        List<String> linkParts = ParserUtils.splitByPipeOutsideBraces(linkContent, true);
        if (linkParts.size() > 1) {
            return AuthorParser.cleanAuthor(linkParts.get(1).trim());
        }
        return AuthorParser.extractNameFromWikiLink(linkParts.get(0).trim());
    }

    private static String extractNameFromWikiLink(String linkText) {
        if (linkText.contains(":")) {
            if (linkText.startsWith(":")) {
                linkText = linkText.substring(1);
            }
            String[] parts = linkText.split(":");
            return AuthorParser.cleanAuthor(parts[parts.length - 1].trim());
        }
        return AuthorParser.cleanAuthor(linkText);
    }

    private static String tryUserTemplateInPart(String part) {
        for (String template : Arrays.asList("User", "Creator")) {
            String result = AuthorParser.tryUserCreatorTemplate(part, template);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static String tryUserCreatorTemplate(String part, String template) {
        String prefix1 = "{{" + template + ":";
        String prefix2 = "[[" + template + ":";
        if (!part.startsWith(prefix1) && !part.startsWith(prefix2)) {
            return null;
        }
        int start = part.indexOf(":") + 1;
        int end = AuthorParser.findUserTemplateEnd(part, start);
        if (end == -1) {
            return null;
        }
        String userSection = part.substring(start, end).trim();
        return AuthorParser.extractUserSectionName(userSection);
    }

    private static int findUserTemplateEnd(String part, int start) {
        int end = part.indexOf("/", start);
        if (end != -1) {
            return end;
        }
        return part.indexOf(part.startsWith("{{") ? "}}" : "]]", start);
    }

    private static String extractUserSectionName(String userSection) {
        List<String> userParts = ParserUtils.splitByPipeOutsideBraces(userSection, true);
        if (userParts.size() > 1) {
            return AuthorParser.cleanAuthor(userParts.get(1).trim());
        }
        return AuthorParser.cleanAuthor(userSection.trim());
    }

    private static String processAuthorValue(String authorPart) {
        String result;
        if (authorPart.isEmpty()) {
            return "Unknown";
        }
        if (authorPart.startsWith("[[") && authorPart.endsWith("]]") && (result = AuthorParser.tryWikiLink(authorPart)) != null) {
            return result;
        }
        if (authorPart.contains(",")) {
            return authorPart.split(",")[0].trim();
        }
        if (authorPart.contains("|") && !authorPart.startsWith("{{") && !authorPart.startsWith("[[")) {
            String[] parts = authorPart.split("\\|", 2);
            return parts[0].trim();
        }
        return authorPart.trim();
    }

    private static String cleanAuthor(String author) {
        if (author == null || author.equals("Unknown")) {
            return "Unknown";
        }
        String cleaned = ParserUtils.removeWikiMarkup(author);
        return (author = cleaned.trim()).isEmpty() ? "Unknown" : author;
    }
}

