/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.renderer;

import java.util.ArrayDeque;
import java.util.Deque;
import org.xwiki.rendering.listener.chaining.AbstractChainingListener;
import org.xwiki.rendering.listener.chaining.ChainingListener;
import org.xwiki.rendering.renderer.PrintRenderer;
import org.xwiki.rendering.renderer.printer.WikiPrinter;

public abstract class AbstractChainingPrintRenderer
extends AbstractChainingListener
implements PrintRenderer {
    private Deque<WikiPrinter> printers = new ArrayDeque<WikiPrinter>();

    public WikiPrinter getMainPrinter() {
        return this.printers.getLast();
    }

    @Override
    public WikiPrinter getPrinter() {
        return this.printers.peek();
    }

    @Override
    public void setPrinter(WikiPrinter printer) {
        this.pushPrinter(printer);
    }

    protected void pushPrinter(WikiPrinter wikiPrinter) {
        this.printers.push(wikiPrinter);
        if (this.getListenerChain().indexOf(this.getClass()) == 0) {
            ChainingListener nextListener = this;
            while ((nextListener = this.getListenerChain().getNextListener(nextListener.getClass())) != null) {
                if (!PrintRenderer.class.isAssignableFrom(nextListener.getClass())) continue;
                ((PrintRenderer)((Object)nextListener)).setPrinter(wikiPrinter);
            }
        }
    }

    protected void popPrinter() {
        this.printers.pop();
    }
}

