/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.gpx;

import java.util.List;
import net.osmand.Location;
import net.osmand.gpx.GPXUtilities;
import net.osmand.gpx.SplitSegment;

abstract class SplitMetric {
    SplitMetric() {
    }

    public abstract double metric(GPXUtilities.WptPt var1, GPXUtilities.WptPt var2);

    static void splitSegment(SplitMetric metric, SplitMetric secondaryMetric, double metricLimit, List<SplitSegment> splitSegments, GPXUtilities.TrkSegment segment, boolean joinSegments) {
        double currentMetricEnd = metricLimit;
        double secondaryMetricEnd = 0.0;
        SplitSegment sp = new SplitSegment(segment, 0, 0.0);
        double total = 0.0;
        GPXUtilities.WptPt prev = null;
        for (int k = 0; k < segment.points.size(); ++k) {
            GPXUtilities.WptPt point = segment.points.get(k);
            if (k > 0) {
                double currentSegment = 0.0;
                if (!segment.generalSegment || joinSegments || !point.firstPoint) {
                    currentSegment = metric.metric(prev, point);
                    secondaryMetricEnd += secondaryMetric.metric(prev, point);
                }
                while (total + currentSegment > currentMetricEnd) {
                    double p = currentMetricEnd - total;
                    double cf = p / currentSegment;
                    sp.setLastPoint(k - 1, cf);
                    sp.metricEnd = currentMetricEnd;
                    sp.secondaryMetricEnd = secondaryMetricEnd;
                    splitSegments.add(sp);
                    sp = new SplitSegment(segment, k - 1, cf);
                    currentMetricEnd += metricLimit;
                }
                total += currentSegment;
            }
            prev = point;
        }
        if (segment.points.size() > 0 && (sp.endPointInd != segment.points.size() - 1 || sp.startCoeff != 1.0)) {
            sp.metricEnd = total;
            sp.secondaryMetricEnd = secondaryMetricEnd;
            sp.setLastPoint(segment.points.size() - 2, 1.0);
            splitSegments.add(sp);
        }
    }

    static class TimeSplitMetric
    extends SplitMetric {
        TimeSplitMetric() {
        }

        @Override
        public double metric(GPXUtilities.WptPt p1, GPXUtilities.WptPt p2) {
            if (p1.time != 0L && p2.time != 0L) {
                return (int)Math.abs((p2.time - p1.time) / 1000L);
            }
            return 0.0;
        }
    }

    static class DistanceSplitMetric
    extends SplitMetric {
        private final float[] calculations = new float[1];

        DistanceSplitMetric() {
        }

        @Override
        public double metric(GPXUtilities.WptPt p1, GPXUtilities.WptPt p2) {
            Location.distanceBetween(p1.lat, p1.lon, p2.lat, p2.lon, this.calculations);
            return this.calculations[0];
        }
    }
}

