/*
 * Decompiled with CFR 0.152.
 */
package net.osmand;

import java.util.Locale;
import net.osmand.Collator;
import net.osmand.OsmAndCollator;
import net.osmand.StringMatcher;
import net.osmand.util.ArabicNormalizer;

public class CollatorStringMatcher
implements StringMatcher {
    private final Collator collator = OsmAndCollator.primaryCollator();
    private final StringMatcherMode mode;
    private final String part;

    public CollatorStringMatcher(String part, StringMatcherMode mode) {
        part = CollatorStringMatcher.lowercaseAndAlignChars(part);
        if (part.length() > 0 && part.charAt(part.length() - 1) == '.') {
            part = part.substring(0, part.length() - 1);
            if (mode == StringMatcherMode.CHECK_EQUALS_FROM_SPACE) {
                mode = StringMatcherMode.CHECK_STARTS_FROM_SPACE;
            } else if (mode == StringMatcherMode.CHECK_EQUALS) {
                mode = StringMatcherMode.CHECK_ONLY_STARTS_WITH;
            }
        }
        this.part = part;
        this.mode = mode;
    }

    public Collator getCollator() {
        return this.collator;
    }

    @Override
    public boolean matches(String name) {
        return CollatorStringMatcher.cmatches(this.collator, name, this.part, false, this.mode);
    }

    public static boolean cmatches(Collator collator, String fullName, String part, StringMatcherMode mode) {
        return CollatorStringMatcher.cmatches(collator, fullName, part, true, mode);
    }

    private static boolean cmatches(Collator collator, String fullName, String part, boolean alignPart, StringMatcherMode mode) {
        if (fullName != null && fullName.indexOf(45) != -1 && CollatorStringMatcher.cmatches(collator, fullName.replace("-", ""), part, mode)) {
            return true;
        }
        if (alignPart) {
            part = CollatorStringMatcher.alignChars(part);
        }
        fullName = CollatorStringMatcher.lowercaseAndAlignChars(fullName);
        switch (mode) {
            case CHECK_CONTAINS: {
                return CollatorStringMatcher.ccontains(collator, fullName, part);
            }
            case CHECK_EQUALS_FROM_SPACE: {
                return CollatorStringMatcher.cstartsWith(collator, fullName, part, true, true, true);
            }
            case CHECK_STARTS_FROM_SPACE: {
                return CollatorStringMatcher.cstartsWith(collator, fullName, part, true, true, false);
            }
            case CHECK_STARTS_FROM_SPACE_NOT_BEGINNING: {
                return CollatorStringMatcher.cstartsWith(collator, fullName, part, false, true, false);
            }
            case CHECK_ONLY_STARTS_WITH: {
                return CollatorStringMatcher.cstartsWith(collator, fullName, part, true, false, false);
            }
            case CHECK_EQUALS: {
                return CollatorStringMatcher.cstartsWith(collator, fullName, part, false, false, true);
            }
            case MULTISEARCH: {
                return CollatorStringMatcher.cstartsWith(collator, part, fullName, true, true, true);
            }
        }
        return false;
    }

    private static boolean ccontains(Collator collator, String base, String part) {
        if (base.length() <= part.length()) {
            return collator.equals(base, part);
        }
        for (int pos = 0; pos <= base.length() - part.length() + 1; ++pos) {
            String temp = base.substring(pos, Math.min(pos + part.length() * 2, base.length()));
            for (int length = temp.length(); length >= 0; --length) {
                String temp2 = temp.substring(0, length);
                if (!collator.equals(temp2, part)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean cstartsWith(Collator collator, String searchIn, String theStart, boolean checkBeginning, boolean checkSpaces, boolean equals) {
        boolean starts;
        int searchInLength = searchIn.length();
        int startLength = theStart.length();
        if (startLength == 0) {
            return true;
        }
        if (startLength > searchInLength) {
            return false;
        }
        if (checkBeginning && (starts = collator.equals(searchIn.substring(0, startLength), theStart))) {
            if (equals) {
                if (startLength == searchInLength || CollatorStringMatcher.isSpace(searchIn.charAt(startLength))) {
                    return true;
                }
            } else {
                return true;
            }
        }
        if (checkSpaces) {
            for (int i = 1; i <= searchInLength - startLength; ++i) {
                if (!CollatorStringMatcher.isSpace(searchIn.charAt(i - 1)) || CollatorStringMatcher.isSpace(searchIn.charAt(i)) || !collator.equals(searchIn.substring(i, i + startLength), theStart)) continue;
                if (equals) {
                    if (i + startLength != searchInLength && !CollatorStringMatcher.isSpace(searchIn.charAt(i + startLength))) continue;
                    return true;
                }
                return true;
            }
        }
        if (!checkBeginning && !checkSpaces && equals) {
            return collator.equals(searchIn, theStart);
        }
        return false;
    }

    private static String lowercaseAndAlignChars(String fullText) {
        fullText = fullText.toLowerCase(Locale.getDefault());
        fullText = CollatorStringMatcher.alignChars(fullText);
        return fullText;
    }

    public static String alignChars(String fullText) {
        int i;
        if (ArabicNormalizer.isSpecialArabic((String)fullText)) {
            String normalized = ArabicNormalizer.normalize((String)fullText);
            Object object = fullText = normalized == null ? fullText : normalized;
        }
        while ((i = ((String)fullText).indexOf(39)) != -1) {
            fullText = ((String)fullText).substring(0, i) + ((String)fullText).substring(i + 1);
        }
        while ((i = ((String)fullText).indexOf(223)) != -1) {
            fullText = ((String)fullText).substring(0, i) + "ss" + ((String)fullText).substring(i + 1);
        }
        return fullText;
    }

    private static boolean isSpace(char c) {
        return !Character.isLetter(c) && !Character.isDigit(c);
    }

    public static enum StringMatcherMode {
        CHECK_ONLY_STARTS_WITH,
        CHECK_STARTS_FROM_SPACE,
        CHECK_STARTS_FROM_SPACE_NOT_BEGINNING,
        CHECK_EQUALS_FROM_SPACE,
        CHECK_CONTAINS,
        CHECK_EQUALS,
        MULTISEARCH;

    }
}

