/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.wiki.commonswiki;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.ibm.icu.util.ULocale;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.osmand.util.Algorithms;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WikiLangConverter {
    public static final String UNDEFINED_TAG = "und";
    public static final String UNDEFINED_MARK = "und:";
    private static final Logger log = LoggerFactory.getLogger(WikiLangConverter.class);
    public static final int REPLACED_CODE_LENGTH = "in".length();
    public static boolean DEBUG = false;
    private static final Gson gson = new Gson();
    private static final Type mapType = new TypeToken<Map<String, String>>(){}.getType();
    private static final Map<String, String> bcp47CodeCache = new ConcurrentHashMap<String, String>();
    private static final Map<String, String> wikiToBcp47Map = Map.ofEntries(Map.entry("no", "nb"), Map.entry("sh", "sr-Latn"), Map.entry("simple", "en-simple"), Map.entry("mo", "ro"), Map.entry("bh", "bho"), Map.entry("zh-yue", "yue"), Map.entry("zh-yue-hk", "yue-HK"), Map.entry("zh-min-nan", "nan"), Map.entry("zh-min-nan-tw", "nan-TW"), Map.entry("zh-classical", "lzh"), Map.entry("zh-wuu", "wuu"), Map.entry("zh-hakka", "hak"), Map.entry("zh-min-bei", "mnp"), Map.entry("zh-min-dong", "cdo"), Map.entry("zh-gan", "gan"), Map.entry("zh-hsn", "hsn"), Map.entry("zh-cmn", "cmn"), Map.entry("sr-el", "sr-Latn"), Map.entry("sr-ec", "sr-Cyrl"), Map.entry("gan-hans", "gan-Hans"), Map.entry("gan-hant", "gan-Hant"), Map.entry("kk-cyrl", "kk-Cyrl"), Map.entry("kk-latn", "kk-Latn"), Map.entry("kk-arab", "kk-Arab"), Map.entry("kk-cn", "kk-Arab-CN"), Map.entry("kk-kz", "kk-Cyrl-KZ"), Map.entry("kk-tr", "kk-Latn-TR"), Map.entry("ku-latn", "ku-Latn"), Map.entry("ku-arab", "ku-Arab"), Map.entry("tg-cyrl", "tg-Cyrl"), Map.entry("tg-latn", "tg-Latn"), Map.entry("ike-cans", "iu-Cans"), Map.entry("ike-latn", "iu-Latn"), Map.entry("shi-tfng", "shi-Tfng"), Map.entry("shi-latn", "shi-Latn"), Map.entry("als", "gsw"), Map.entry("bat-smg", "sgs"), Map.entry("be-x-old", "be-tarask"), Map.entry("cbk-zam", "cbk"), Map.entry("fiu-vro", "vro"), Map.entry("map-bms", "jv-x-bms"), Map.entry("nrm", "nrf"), Map.entry("roa-rup", "rup"), Map.entry("roa-tara", "nap-x-tara"), Map.entry("tp", "tok"), Map.entry("eml", "egl"), Map.entry("dk", "da"), Map.entry("jp", "ja"), Map.entry("cz", "cs"), Map.entry("ju", "jv"));

    public static String normalizeLang(String jsonStr) {
        if (Algorithms.isBlank((String)jsonStr)) {
            return "";
        }
        try {
            Map parsed = (Map)gson.fromJson(jsonStr, mapType);
            if (Algorithms.isEmpty((Map)parsed)) {
                return "";
            }
            HashMap<String, String> normalized = new HashMap<String, String>();
            for (Map.Entry e : parsed.entrySet()) {
                String wikiLangCode = ((String)e.getKey()).trim();
                String description = (String)e.getValue();
                String bcp47Code = null;
                if (!Algorithms.isBlank((String)description)) {
                    bcp47Code = WikiLangConverter.toBcp47FromWiki(wikiLangCode);
                }
                if (Algorithms.isBlank(bcp47Code)) continue;
                normalized.put(bcp47Code, description);
            }
            return gson.toJson(normalized);
        }
        catch (Exception ex) {
            log.info(ex.getMessage());
            return jsonStr;
        }
    }

    public static String toBcp47FromWiki(String wikiCode) {
        return bcp47CodeCache.computeIfAbsent(wikiCode, WikiLangConverter::computeBcp47);
    }

    private static String computeBcp47(String wikiCode) {
        String preparedWikiCode = wikiCode.replace('_', '-').toLowerCase(Locale.ROOT);
        String bcp47code = wikiToBcp47Map.get(preparedWikiCode);
        if (bcp47code != null) {
            return bcp47code;
        }
        try {
            ULocale uLocale = ULocale.forLanguageTag((String)preparedWikiCode);
            bcp47code = uLocale.toLanguageTag();
            if (UNDEFINED_TAG.equals(bcp47code)) {
                return WikiLangConverter.debugInfo(wikiCode);
            }
            String fixedBcp47code = WikiLangConverter.fixLegacyCodes(bcp47code);
            return fixedBcp47code != null ? fixedBcp47code : bcp47code;
        }
        catch (Exception ex) {
            log.info(ex.getMessage());
            return WikiLangConverter.debugInfo(wikiCode);
        }
    }

    private static String debugInfo(String wikiCode) {
        return DEBUG ? UNDEFINED_MARK + wikiCode : null;
    }

    private static String fixLegacyCodes(String tag) {
        return switch (tag.length() >= REPLACED_CODE_LENGTH ? tag.substring(0, REPLACED_CODE_LENGTH) : tag) {
            case "in" -> "id" + tag.substring(REPLACED_CODE_LENGTH);
            case "iw" -> "he" + tag.substring(REPLACED_CODE_LENGTH);
            case "ji" -> "yi" + tag.substring(REPLACED_CODE_LENGTH);
            default -> null;
        };
    }
}

