/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filter.internal.job;

import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.filter.input.InputFilterStream;
import org.xwiki.filter.input.InputFilterStreamFactory;
import org.xwiki.filter.job.FilterStreamConverterJobRequest;
import org.xwiki.filter.output.OutputFilterStream;
import org.xwiki.filter.output.OutputFilterStreamFactory;
import org.xwiki.job.GroupedJob;
import org.xwiki.job.JobGroupPath;
import org.xwiki.job.internal.AbstractJob;
import org.xwiki.job.internal.DefaultJobStatus;

@Component
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
@Named(value="filter.converter")
public class FilterStreamConverterJob
extends AbstractJob<FilterStreamConverterJobRequest, DefaultJobStatus<FilterStreamConverterJobRequest>>
implements GroupedJob {
    public static final String JOBTYPE = "filter.converter";
    public static final JobGroupPath ROOT_GROUP = new JobGroupPath(Arrays.asList("filter", "converter"));
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;

    public String getType() {
        return JOBTYPE;
    }

    public JobGroupPath getGroupPath() {
        return ROOT_GROUP;
    }

    protected void runInternal() throws Exception {
        InputFilterStreamFactory inputFactory = (InputFilterStreamFactory)((ComponentManager)this.componentManagerProvider.get()).getInstance(InputFilterStreamFactory.class, ((FilterStreamConverterJobRequest)this.getRequest()).getInputType().serialize());
        InputFilterStream inputFilter = inputFactory.createInputFilterStream(((FilterStreamConverterJobRequest)this.getRequest()).getInputProperties());
        OutputFilterStreamFactory outputFactory = (OutputFilterStreamFactory)((ComponentManager)this.componentManagerProvider.get()).getInstance(OutputFilterStreamFactory.class, ((FilterStreamConverterJobRequest)this.getRequest()).getOutputType().serialize());
        OutputFilterStream outputFilter = outputFactory.createOutputFilterStream(((FilterStreamConverterJobRequest)this.getRequest()).getOutputProperties());
        inputFilter.read(outputFilter.getFilter());
        inputFilter.close();
        outputFilter.close();
    }
}

