/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filter;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.xwiki.filter.FilterElementParameterDescriptor;

public class FilterElementDescriptor {
    private static final FilterElementParameterDescriptor<?>[] EMPTY_PARAMETERS = new FilterElementParameterDescriptor[0];
    private String name;
    private FilterElementParameterDescriptor<?>[] parameters;
    private Map<String, Integer> parametersIndex = new HashMap<String, Integer>();
    private Method beginMethod;
    private Method endMethod;
    private Method onMethod;

    public FilterElementDescriptor(String name) {
        this(name, EMPTY_PARAMETERS);
    }

    public FilterElementDescriptor(String name, FilterElementParameterDescriptor<?>[] parameters) {
        this.name = name;
        this.parameters = parameters;
        for (FilterElementParameterDescriptor<?> parameter : parameters) {
            if (parameter.getName() == null) continue;
            this.parametersIndex.put(parameter.getName(), parameter.getIndex());
        }
    }

    public String getName() {
        return this.name;
    }

    public FilterElementParameterDescriptor<?>[] getParameters() {
        return this.parameters;
    }

    public <T> FilterElementParameterDescriptor<T> getParameter(String name) {
        Integer index = this.parametersIndex.get(name);
        return index != null ? this.parameters[index] : null;
    }

    public Method getBeginMethod() {
        return this.beginMethod;
    }

    public void setBeginMethod(Method beginMethod) {
        this.beginMethod = beginMethod;
    }

    public Method getEndMethod() {
        return this.endMethod;
    }

    public void setEndMethod(Method endMethod) {
        this.endMethod = endMethod;
    }

    public Method getOnMethod() {
        return this.onMethod;
    }

    public void setOnMethod(Method onMethod) {
        this.onMethod = onMethod;
    }
}

