/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.core.jni;

import net.osmand.core.jni.IMapDataProvider;
import net.osmand.core.jni.MapState;
import net.osmand.core.jni.Metric;
import net.osmand.core.jni.OsmAndCoreJNI;
import net.osmand.core.jni.SWIGTYPE_p_QListT_void_const_p_t;
import net.osmand.core.jni.SWIGTYPE_p_std__shared_ptrT_OsmAnd__IMapDataProvider__Request_t;
import net.osmand.core.jni.SWIGTYPE_p_std__shared_ptrT_OsmAnd__IMapKeyedDataProvider__Data_t;
import net.osmand.core.jni.SWIGTYPE_p_void;
import net.osmand.core.jni.ZoomLevel;

public class IMapKeyedDataProvider
extends IMapDataProvider {
    private transient long swigCPtr;
    private transient boolean swigCMemOwnDerived;

    protected IMapKeyedDataProvider(long l, boolean bl) {
        super(OsmAndCoreJNI.IMapKeyedDataProvider_SWIGSmartPtrUpcast(l), true);
        this.swigCMemOwnDerived = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(IMapKeyedDataProvider iMapKeyedDataProvider) {
        return iMapKeyedDataProvider == null ? 0L : iMapKeyedDataProvider.swigCPtr;
    }

    @Override
    protected void swigSetCMemOwn(boolean bl) {
        this.swigCMemOwnDerived = bl;
        super.swigSetCMemOwn(bl);
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwnDerived) {
                this.swigCMemOwnDerived = false;
                OsmAndCoreJNI.delete_IMapKeyedDataProvider(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public ZoomLevel getMinZoom() {
        return ZoomLevel.swigToEnum(OsmAndCoreJNI.IMapKeyedDataProvider_getMinZoom(this.swigCPtr, this));
    }

    public ZoomLevel getMaxZoom() {
        return ZoomLevel.swigToEnum(OsmAndCoreJNI.IMapKeyedDataProvider_getMaxZoom(this.swigCPtr, this));
    }

    public long getPriority() {
        return OsmAndCoreJNI.IMapKeyedDataProvider_getPriority(this.swigCPtr, this);
    }

    public void setPriority(long l) {
        OsmAndCoreJNI.IMapKeyedDataProvider_setPriority(this.swigCPtr, this, l);
    }

    public SWIGTYPE_p_QListT_void_const_p_t getProvidedDataKeys() {
        return new SWIGTYPE_p_QListT_void_const_p_t(OsmAndCoreJNI.IMapKeyedDataProvider_getProvidedDataKeys(this.swigCPtr, this), true);
    }

    public boolean obtainKeyedData(Request request, SWIGTYPE_p_std__shared_ptrT_OsmAnd__IMapKeyedDataProvider__Data_t sWIGTYPE_p_std__shared_ptrT_OsmAnd__IMapKeyedDataProvider__Data_t, Metric metric) {
        return OsmAndCoreJNI.IMapKeyedDataProvider_obtainKeyedData__SWIG_0(this.swigCPtr, this, Request.getCPtr(request), request, SWIGTYPE_p_std__shared_ptrT_OsmAnd__IMapKeyedDataProvider__Data_t.getCPtr(sWIGTYPE_p_std__shared_ptrT_OsmAnd__IMapKeyedDataProvider__Data_t), Metric.getCPtr(metric), metric);
    }

    public boolean obtainKeyedData(Request request, SWIGTYPE_p_std__shared_ptrT_OsmAnd__IMapKeyedDataProvider__Data_t sWIGTYPE_p_std__shared_ptrT_OsmAnd__IMapKeyedDataProvider__Data_t) {
        return OsmAndCoreJNI.IMapKeyedDataProvider_obtainKeyedData__SWIG_1(this.swigCPtr, this, Request.getCPtr(request), request, SWIGTYPE_p_std__shared_ptrT_OsmAnd__IMapKeyedDataProvider__Data_t.getCPtr(sWIGTYPE_p_std__shared_ptrT_OsmAnd__IMapKeyedDataProvider__Data_t));
    }

    public static class Request
    extends IMapDataProvider.Request {
        private transient long swigCPtr;

        protected Request(long l, boolean bl) {
            super(OsmAndCoreJNI.IMapKeyedDataProvider_Request_SWIGUpcast(l), bl);
            this.swigCPtr = l;
        }

        protected static long getCPtr(Request request) {
            return request == null ? 0L : request.swigCPtr;
        }

        protected static long swigRelease(Request request) {
            long l = 0L;
            if (request != null) {
                if (!request.swigCMemOwn) {
                    throw new RuntimeException("Cannot release ownership as memory is not owned");
                }
                l = request.swigCPtr;
                request.swigCMemOwn = false;
                request.delete();
            }
            return l;
        }

        @Override
        protected void finalize() {
            this.delete();
        }

        @Override
        public synchronized void delete() {
            if (this.swigCPtr != 0L) {
                if (this.swigCMemOwn) {
                    this.swigCMemOwn = false;
                    OsmAndCoreJNI.delete_IMapKeyedDataProvider_Request(this.swigCPtr);
                }
                this.swigCPtr = 0L;
            }
            super.delete();
        }

        public void setKey(SWIGTYPE_p_void sWIGTYPE_p_void) {
            OsmAndCoreJNI.IMapKeyedDataProvider_Request_key_set(this.swigCPtr, this, SWIGTYPE_p_void.getCPtr(sWIGTYPE_p_void));
        }

        public SWIGTYPE_p_void getKey() {
            long l = OsmAndCoreJNI.IMapKeyedDataProvider_Request_key_get(this.swigCPtr, this);
            return l == 0L ? null : new SWIGTYPE_p_void(l, false);
        }

        public void setMapState(MapState mapState) {
            OsmAndCoreJNI.IMapKeyedDataProvider_Request_mapState_set(this.swigCPtr, this, MapState.getCPtr(mapState), mapState);
        }

        public MapState getMapState() {
            long l = OsmAndCoreJNI.IMapKeyedDataProvider_Request_mapState_get(this.swigCPtr, this);
            return l == 0L ? null : new MapState(l, false);
        }

        public Request() {
            this(OsmAndCoreJNI.new_IMapKeyedDataProvider_Request__SWIG_0(), true);
        }

        public Request(IMapDataProvider.Request request) {
            this(OsmAndCoreJNI.new_IMapKeyedDataProvider_Request__SWIG_1(IMapDataProvider.Request.getCPtr(request), request), true);
        }

        public static void copy(Request request, IMapDataProvider.Request request2) {
            OsmAndCoreJNI.IMapKeyedDataProvider_Request_copy(Request.getCPtr(request), request, IMapDataProvider.Request.getCPtr(request2), request2);
        }

        @Override
        public SWIGTYPE_p_std__shared_ptrT_OsmAnd__IMapDataProvider__Request_t clone() {
            return new SWIGTYPE_p_std__shared_ptrT_OsmAnd__IMapDataProvider__Request_t(OsmAndCoreJNI.IMapKeyedDataProvider_Request_clone(this.swigCPtr, this), true);
        }
    }

    public static class Data
    extends IMapDataProvider.Data {
        private transient long swigCPtr;

        protected Data(long l, boolean bl) {
            super(OsmAndCoreJNI.IMapKeyedDataProvider_Data_SWIGUpcast(l), bl);
            this.swigCPtr = l;
        }

        protected static long getCPtr(Data data) {
            return data == null ? 0L : data.swigCPtr;
        }

        protected static long swigRelease(Data data) {
            long l = 0L;
            if (data != null) {
                if (!data.swigCMemOwn) {
                    throw new RuntimeException("Cannot release ownership as memory is not owned");
                }
                l = data.swigCPtr;
                data.swigCMemOwn = false;
                data.delete();
            }
            return l;
        }

        @Override
        protected void finalize() {
            this.delete();
        }

        @Override
        public synchronized void delete() {
            if (this.swigCPtr != 0L) {
                if (this.swigCMemOwn) {
                    this.swigCMemOwn = false;
                    OsmAndCoreJNI.delete_IMapKeyedDataProvider_Data(this.swigCPtr);
                }
                this.swigCPtr = 0L;
            }
            super.delete();
        }

        public Data(SWIGTYPE_p_void sWIGTYPE_p_void, IMapDataProvider.RetainableCacheMetadata retainableCacheMetadata) {
            this(OsmAndCoreJNI.new_IMapKeyedDataProvider_Data__SWIG_0(SWIGTYPE_p_void.getCPtr(sWIGTYPE_p_void), IMapDataProvider.RetainableCacheMetadata.getCPtr(retainableCacheMetadata), retainableCacheMetadata), true);
        }

        public Data(SWIGTYPE_p_void sWIGTYPE_p_void) {
            this(OsmAndCoreJNI.new_IMapKeyedDataProvider_Data__SWIG_1(SWIGTYPE_p_void.getCPtr(sWIGTYPE_p_void)), true);
        }

        public void setKey(SWIGTYPE_p_void sWIGTYPE_p_void) {
            OsmAndCoreJNI.IMapKeyedDataProvider_Data_key_set(this.swigCPtr, this, SWIGTYPE_p_void.getCPtr(sWIGTYPE_p_void));
        }

        public SWIGTYPE_p_void getKey() {
            long l = OsmAndCoreJNI.IMapKeyedDataProvider_Data_key_get(this.swigCPtr, this);
            return l == 0L ? null : new SWIGTYPE_p_void(l, false);
        }
    }
}

