/*
 * Decompiled with CFR 0.152.
 */
package rtree;

import java.io.IOException;
import rtree.Element;
import rtree.IllegalValueException;
import rtree.LeafElement;
import rtree.Node;
import rtree.NodeEmptyException;
import rtree.NodeFullException;
import rtree.NodeWriteException;
import rtree.NonLeafElement;
import rtree.RTreeException;
import rtree.Rect;

class ReadNode
extends Node {
    ReadNode() {
    }

    public static ReadNode makeReadNode(Node node) {
        ReadNode rdNode = new ReadNode();
        try {
            rdNode.file = node.file;
            rdNode.dirty = node.dirty;
            rdNode.fileName = new String(node.fileName.toCharArray());
            rdNode.nodeIndex = node.nodeIndex;
            rdNode.sorted = node.sorted;
            rdNode.nodeMBR = new Rect(node.nodeMBR);
            rdNode.elements = new Element[node.elements.length];
            if (node.elementType == 1) {
                for (int i = 0; i < node.totalElements; ++i) {
                    rdNode.elements[i] = new LeafElement(new Rect(node.elements[i].getRect()), node.elements[i].getPtr());
                }
            } else {
                for (int i = 0; i < node.totalElements; ++i) {
                    rdNode.elements[i] = new NonLeafElement(new Rect(node.elements[i].getRect()), node.elements[i].getPtr());
                }
            }
            rdNode.fileHdr = node.fileHdr;
            rdNode.totalElements = node.totalElements;
            rdNode.parent = node.parent;
            rdNode.elementSize = node.elementSize;
            rdNode.elementType = node.elementType;
            return rdNode;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void deleteElement(int index, boolean force) throws IllegalValueException, NodeWriteException {
        throw new UnsupportedOperationException("operation not supported");
    }

    @Override
    public void insertElement(Element elmt) throws NodeWriteException, NodeFullException {
        throw new UnsupportedOperationException("operation not supported");
    }

    @Override
    public void insertElement(Element[] elmts, boolean updateChldrn) throws NodeWriteException, NodeFullException {
        throw new UnsupportedOperationException("operation not supported");
    }

    @Override
    public int getElementType() {
        return super.getElementType();
    }

    @Override
    public long getNodeIndex() {
        return super.getNodeIndex();
    }

    @Override
    Rect[] getAllRectangles() throws IllegalValueException {
        return super.getAllRectangles();
    }

    @Override
    public Element getLeastEnlargement(Element elmt) throws NodeEmptyException, IllegalValueException, NodeWriteException {
        return super.getLeastEnlargement(elmt);
    }

    @Override
    boolean isInsertPossible() {
        return super.isInsertPossible();
    }

    @Override
    public Node[] splitNode(Element elmtM1, long slotIndex) throws RTreeException, NodeWriteException {
        throw new UnsupportedOperationException("operation not supported");
    }

    @Override
    public long getParent() {
        return super.getParent();
    }

    @Override
    public int getElementIndex(long ptr) {
        return super.getElementIndex(ptr);
    }

    @Override
    public void modifyElement(int index, Element elmt) throws IllegalValueException, IOException, NodeWriteException {
        throw new UnsupportedOperationException("operation not supported");
    }

    @Override
    public void modifyElement(int index, long pointer) throws IllegalValueException, IOException, NodeWriteException {
        throw new UnsupportedOperationException("operation not supported");
    }

    @Override
    public void modifyElement(int index, Rect rect) throws IllegalValueException, IOException, NodeWriteException {
        throw new UnsupportedOperationException("operation not supported");
    }

    @Override
    public Rect getNodeMBR() throws IllegalValueException {
        return super.getNodeMBR();
    }

    @Override
    public void setParent(long prnt) throws IOException, NodeWriteException {
        throw new UnsupportedOperationException("operation not supported");
    }

    @Override
    public int getTotalElements() {
        return super.getTotalElements();
    }

    @Override
    public Element[] getAllElements() {
        return super.getAllElements();
    }

    @Override
    Element getElement(int index) throws IllegalValueException {
        return super.getElement(index);
    }

    @Override
    public void deleteNode() throws NodeWriteException {
        throw new UnsupportedOperationException("operation not supported");
    }

    @Override
    void sweepSort() {
        super.sweepSort();
    }

    @Override
    public boolean flush() throws NodeWriteException {
        throw new UnsupportedOperationException("operation not supported");
    }

    @Override
    void setDirty(boolean val) {
        throw new UnsupportedOperationException("operation not supported");
    }

    @Override
    public boolean isDirty() {
        throw new UnsupportedOperationException("operation not supported");
    }
}

