/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.obf.preparation;

import com.sun.media.imageioimpl.plugins.tiff.TIFFImageReader;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferFloat;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import net.osmand.PlatformUtil;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IndexWeatherData {
    private static final Log log = PlatformUtil.getLog(IndexWeatherData.class);
    public static final int NEAREST_NEIGHBOOR_INTERPOLATION = 0;
    public static final int BILINEAR_INTERPOLATION = 1;
    public static final int BICUBIC_INTERPOLATION = 2;
    public static int INTERPOLATION = 1;
    public static final double INEXISTENT_VALUE = Double.MIN_VALUE;
    public static final int REF_WIDTH = 1440;
    public static final int REF_HEIGHT = 721;
    private static final String ECWMF_WEATHER_TYPE = "ecmwf";
    private static final String TIFF_PLUGIN = "com_sun_media_imageio_plugins_tiff_image_1.0";
    private static final String TIFF_FIELD = "TIFFField";
    private static final String METADATA_TAG_NUMBER = "42112";

    public static void main(String[] args) {
        IndexWeatherData.readWeatherData("/Users/plotva/osmand/weather/gfs/", "20250913_%02d00.tiff", 8, 23, 1);
    }

    private static void readWeatherData(String folder, String fmt, int min, int max, int step) {
        double lat = 52.3121;
        double lon = 4.888;
        int len = (max + 1 - min) / step;
        double[][] wth = new double[6][len];
        for (int i = 0; i < len; ++i) {
            int vl = min + step * i;
            File f = new File(folder, String.format(fmt, vl));
            WeatherTiff td = new WeatherTiff(f);
            Map<Integer, String> codes = td.getBandData();
            Integer iCloud = IndexWeatherData.bandIndexByCode(codes, WeatherParam.CLOUD.code);
            Integer iTemp = IndexWeatherData.bandIndexByCode(codes, WeatherParam.TEMP.code);
            Integer iPres = IndexWeatherData.bandIndexByCode(codes, WeatherParam.PRESSURE.code);
            Integer iWind = IndexWeatherData.bandIndexByCode(codes, WeatherParam.WIND.code);
            Integer iPrec = IndexWeatherData.bandIndexByCode(codes, WeatherParam.PRECIP.code);
            wth[0][i] = vl;
            wth[1][i] = iTemp != null ? td.getValue(iTemp, lat, lon, ECWMF_WEATHER_TYPE) : Double.MIN_VALUE;
            wth[2][i] = iPrec != null ? td.getValue(iPrec, lat, lon, ECWMF_WEATHER_TYPE) : Double.MIN_VALUE;
            wth[3][i] = iWind != null ? td.getValue(iWind, lat, lon, ECWMF_WEATHER_TYPE) : Double.MIN_VALUE;
            wth[4][i] = iPres != null ? td.getValue(iPres, lat, lon, ECWMF_WEATHER_TYPE) : Double.MIN_VALUE;
            wth[5][i] = iCloud != null ? td.getValue(iCloud, lat, lon, ECWMF_WEATHER_TYPE) : Double.MIN_VALUE;
        }
        System.out.println("TIME    :      " + IndexWeatherData.format("%3.0f:00", wth[0]));
        System.out.println("Temp (C):      " + IndexWeatherData.format("%6.1f", wth[1]));
        System.out.println("Precipitation: " + IndexWeatherData.format("%6.2f", wth[2], 1000000.0));
        System.out.println("Wind (m/s):    " + IndexWeatherData.format("%6.2f", wth[3]));
        System.out.println("Pressure (kPa):" + IndexWeatherData.format("%6.2f", wth[4], 0.001));
        System.out.println("Cloud %%:      " + IndexWeatherData.format("%6.2f", wth[5]));
    }

    private static String format(String fmt, double[] ds) {
        return IndexWeatherData.format(fmt, ds, 1.0);
    }

    private static String format(String fmt, double[] ds, double mult) {
        Object s = "";
        for (int i = 0; i < ds.length; ++i) {
            if (i > 0) {
                s = (String)s + "  ";
            }
            s = (String)s + String.format(fmt, ds[i] * mult);
        }
        return s;
    }

    public static Integer bandIndexByCode(Map<Integer, String> sampleToCode, String code) {
        if (sampleToCode == null) {
            return null;
        }
        for (Map.Entry<Integer, String> e : sampleToCode.entrySet()) {
            if (!code.equals(e.getValue())) continue;
            return e.getKey();
        }
        return null;
    }

    public static class WeatherTiff {
        public double ORIGIN_LON = -180.125;
        public double ORIGIN_LAT = 90.125;
        public double PX_SIZE_LON = 0.25;
        public double PX_SIZE_LAT = -0.25;
        public double ECMWF_ORIGIN_LON = -180.1999;
        public double ECMWF_ORIGIN_LAT = 90.2;
        public double ECMWF_PX_SIZE_LON = 0.28;
        public double ECMWF_PX_SIZE_LAT = -0.28;
        public final File file;
        private DataBufferFloat data;
        private int height;
        private int width;
        private int bands;
        private Map<Integer, String> bandData;

        public WeatherTiff(File file) {
            this.file = file;
            this.readTiffFile(file, false);
        }

        public WeatherTiff(File file, boolean readMetadata) {
            this.file = file;
            this.readTiffFile(file, readMetadata);
        }

        public int getBands() {
            return this.bands;
        }

        public Map<Integer, String> getBandData() {
            return this.bandData;
        }

        private void readTiffFile(File file, boolean readMetadata) {
            if (file.exists()) {
                if (readMetadata) {
                    Pair<BufferedImage, String> p = this.iterativeReadDataWithMeta(file);
                    BufferedImage img = (BufferedImage)p.getLeft();
                    String metadata = (String)p.getRight();
                    this.readWeatherData(img);
                    this.bandData = this.parseBandData(metadata);
                    if (img == null) {
                        log.error((Object)("Failed to read image data from file: " + file.getAbsolutePath()));
                    }
                } else {
                    BufferedImage img = this.iterativeReadData(file);
                    this.readWeatherData(img);
                    if (img == null) {
                        log.error((Object)("Failed to read image data from file: " + file.getAbsolutePath()));
                    }
                }
            } else {
                log.error((Object)("File does not exist: " + file.getAbsolutePath()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private BufferedImage iterativeReadData(File file) {
            boolean readSuccess = false;
            BufferedImage img = null;
            Iterator<ImageReader> readers = ImageIO.getImageReadersBySuffix("tiff");
            ImageInputStream iis = null;
            while (readers.hasNext() && !readSuccess) {
                ImageReader reader = readers.next();
                if (!(reader instanceof TIFFImageReader)) continue;
                try {
                    iis = ImageIO.createImageInputStream(file);
                    reader.setInput(iis, true);
                    img = reader.read(0);
                    readSuccess = true;
                }
                catch (IOException e) {
                    log.info((Object)("Error reading TIFF file with reader " + reader.getClass().getName() + ": " + e.getMessage()));
                }
                finally {
                    reader.dispose();
                    if (iis == null) continue;
                    try {
                        iis.close();
                        iis = null;
                    }
                    catch (IOException e) {
                        log.error((Object)("Error closing ImageInputStream: " + e.getMessage()));
                    }
                }
            }
            if (!readSuccess) {
                log.error((Object)"Failed to read TIFF file with all available readers.");
            }
            return img;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Pair<BufferedImage, String> iterativeReadDataWithMeta(File file) {
            boolean readSuccess = false;
            BufferedImage img = null;
            String metaData = null;
            Iterator<ImageReader> readers = ImageIO.getImageReadersBySuffix("tiff");
            ImageInputStream iis = null;
            while (readers.hasNext() && !readSuccess) {
                ImageReader reader = readers.next();
                if (!(reader instanceof TIFFImageReader)) continue;
                try {
                    iis = ImageIO.createImageInputStream(file);
                    reader.setInput(iis, true);
                    metaData = this.readMetaData(reader);
                    img = reader.read(0);
                    readSuccess = true;
                }
                catch (IOException e) {
                    log.info((Object)("Error reading TIFF file with reader " + reader.getClass().getName() + ": " + e.getMessage()));
                }
                finally {
                    reader.dispose();
                    if (iis == null) continue;
                    try {
                        iis.close();
                        iis = null;
                    }
                    catch (IOException e) {
                        log.error((Object)("Error closing ImageInputStream: " + e.getMessage()));
                    }
                }
            }
            if (!readSuccess) {
                log.error((Object)"Failed to read TIFF file with all available readers.");
            }
            return Pair.of(img, metaData);
        }

        private String readMetaData(ImageReader reader) throws IOException {
            IIOMetadata md = reader.getImageMetadata(0);
            Node root = null;
            try {
                root = md.getAsTree(IndexWeatherData.TIFF_PLUGIN);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (root == null) {
                try {
                    root = md.getAsTree("javax_imageio_1.0");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (!(root instanceof Element)) {
                return null;
            }
            NodeList fields = ((Element)root).getElementsByTagName(IndexWeatherData.TIFF_FIELD);
            String metadata = null;
            for (int i = 0; i < fields.getLength() && metadata == null; ++i) {
                Element f = (Element)fields.item(i);
                if (!IndexWeatherData.METADATA_TAG_NUMBER.equals(f.getAttribute("number"))) continue;
                for (Node c = f.getFirstChild(); c != null; c = c.getNextSibling()) {
                    String n = c.getNodeName();
                    if ("TIFFAscii".equals(n)) {
                        NamedNodeMap av = c.getAttributes();
                        if (av != null && av.getNamedItem("value") != null) {
                            metadata = av.getNamedItem("value").getNodeValue();
                            continue;
                        }
                        if (c.getFirstChild() == null) continue;
                        metadata = c.getFirstChild().getNodeValue();
                        continue;
                    }
                    if (!"TIFFAsciis".equals(n)) continue;
                    StringBuilder sb = new StringBuilder();
                    for (Node a = c.getFirstChild(); a != null; a = a.getNextSibling()) {
                        if (!"TIFFAscii".equals(a.getNodeName())) continue;
                        NamedNodeMap av = a.getAttributes();
                        if (av != null && av.getNamedItem("value") != null) {
                            sb.append(av.getNamedItem("value").getNodeValue());
                            continue;
                        }
                        if (a.getFirstChild() == null) continue;
                        sb.append(a.getFirstChild().getNodeValue());
                    }
                    if (sb.isEmpty()) continue;
                    metadata = sb.toString();
                }
            }
            return metadata;
        }

        private Map<Integer, String> parseBandData(String metadata) {
            HashMap<Integer, String> out = new HashMap<Integer, String>();
            if (metadata == null || metadata.isEmpty()) {
                return out;
            }
            Pattern p = Pattern.compile("<Item\\s+name\\s*=\\s*\"DESCRIPTION\"\\s+sample\\s*=\\s*\"(\\d+)\"[^>]*>(.*?)</Item>", 34);
            Matcher m = p.matcher(metadata);
            while (m.find()) {
                int sample = Integer.parseInt(m.group(1));
                String text = m.group(2) == null ? "" : m.group(2).trim();
                int colon = text.indexOf(58);
                String code = (colon >= 0 ? text.substring(0, colon) : text).trim();
                if (code.isEmpty()) continue;
                out.put(sample, code);
            }
            return out;
        }

        private void readWeatherData(BufferedImage img) {
            if (img != null) {
                this.width = img.getWidth();
                this.height = img.getHeight();
                this.data = (DataBufferFloat)img.getRaster().getDataBuffer();
                this.bands = this.data.getSize() / this.width / this.height;
            }
        }

        public double getValue(int band, double lat, double lon, String weatherType) {
            double x;
            double y;
            if (weatherType.equals(IndexWeatherData.ECWMF_WEATHER_TYPE)) {
                y = (lat - this.ECMWF_ORIGIN_LAT) / this.ECMWF_PX_SIZE_LAT;
                x = (lon - this.ECMWF_ORIGIN_LON) / this.ECMWF_PX_SIZE_LON;
            } else {
                y = (lat - this.ORIGIN_LAT) / this.PX_SIZE_LAT;
                x = (lon - this.ORIGIN_LON) / this.PX_SIZE_LON;
            }
            if (y < 0.0 || y > (double)this.height || x < 0.0 || x > (double)this.width) {
                return Double.MIN_VALUE;
            }
            return this.getInterpolationValue(band, x, y, null);
        }

        public double getInterpolationValue(int band, double x, double y, double[] array) {
            if (this.data == null) {
                return Double.MIN_VALUE;
            }
            if (INTERPOLATION == 1) {
                return this.bilinearInterpolation(band, x, y, array);
            }
            if (INTERPOLATION == 2) {
                return this.bicubicInterpolation(band, x, y, array);
            }
            return this.nearestNeighboor(band, x, y);
        }

        protected double nearestNeighboor(int band, double x, double y) {
            int px = (int)Math.round(x);
            int py = (int)Math.round(y);
            return this.getElem(band, px, py);
        }

        protected double getElem(int band, int px, int py) {
            int ind;
            if (px < 0) {
                px = 0;
            }
            if (py < 0) {
                py = 1;
            }
            if (px > this.width - 1) {
                px = this.width - 1;
            }
            if (py >= this.height - 1) {
                py = this.height - 1;
            }
            if ((ind = (px + py * this.width) * this.bands + band) >= this.data.getSize()) {
                throw new IllegalArgumentException("Illegal access (" + px + ", " + py + ") " + ind + " - " + this.file.getName());
            }
            return this.data.getElemDouble(ind);
        }

        protected double bilinearInterpolation(int band, double x, double y, double[] array) {
            int px = (int)Math.ceil(x);
            int py = (int)Math.ceil(y);
            if (array == null) {
                array = new double[]{this.getElem(band, px - 1, py - 1), this.getElem(band, px, py - 1), this.getElem(band, px - 1, py), this.getElem(band, px, py)};
            }
            double cx = x + 1.0 - (double)px;
            double cy = y + 1.0 - (double)py;
            return (1.0 - cx) * (1.0 - cy) * array[0] + cx * (1.0 - cy) * array[1] + (1.0 - cx) * cy * array[2] + cx * cy * array[3];
        }

        protected double bicubicInterpolation(int band, double ix, double iy, double[] cf) {
            int px = (int)Math.floor(ix);
            int py = (int)Math.floor(iy);
            double x = ix - (double)px;
            double y = iy - (double)py;
            if (cf == null) {
                cf = new double[16];
            }
            Arrays.fill(cf, 0.0);
            cf[0] = (x - 1.0) * (x - 2.0) * (x + 1.0) * (y - 1.0) * (y - 2.0) * (y + 1.0) / 4.0 * this.getElem(band, px, py);
            cf[1] = -x * (x - 2.0) * (x + 1.0) * (y - 1.0) * (y - 2.0) * (y + 1.0) / 4.0 * this.getElem(band, px, py + 1);
            cf[2] = -(x - 1.0) * (x - 2.0) * (x + 1.0) * y * (y - 2.0) * (y + 1.0) / 4.0 * this.getElem(band, px + 1, py);
            cf[3] = x * (x - 2.0) * (x + 1.0) * y * (y - 2.0) * (y + 1.0) / 4.0 * this.getElem(band, px + 1, py + 1);
            cf[4] = -x * (x - 2.0) * (x - 1.0) * (y - 1.0) * (y - 2.0) * (y + 1.0) / 12.0 * this.getElem(band, px, py - 1);
            cf[5] = -(x + 1.0) * (x - 2.0) * (x - 1.0) * (y - 1.0) * (y - 2.0) * y / 12.0 * this.getElem(band, px - 1, py);
            cf[6] = x * (x - 2.0) * (x - 1.0) * (y + 1.0) * (y - 2.0) * y / 12.0 * this.getElem(band, px + 1, py - 1);
            cf[7] = x * (x - 2.0) * (x + 1.0) * (y - 1.0) * (y - 2.0) * y / 12.0 * this.getElem(band, px - 1, py + 1);
            cf[8] = x * (x - 1.0) * (x + 1.0) * (y - 1.0) * (y - 2.0) * (y + 1.0) / 12.0 * this.getElem(band, px, py + 2);
            cf[9] = (x - 2.0) * (x - 1.0) * (x + 1.0) * (y - 1.0) * y * (y + 1.0) / 12.0 * this.getElem(band, px + 2, py);
            cf[10] = x * (x - 1.0) * (x - 2.0) * y * (y - 1.0) * (y - 2.0) / 36.0 * this.getElem(band, px - 1, py - 1);
            cf[11] = -x * (x - 1.0) * (x + 1.0) * y * (y + 1.0) * (y - 2.0) / 12.0 * this.getElem(band, px + 1, py + 2);
            cf[12] = -x * (x + 1.0) * (x - 2.0) * y * (y - 1.0) * (y + 1.0) / 12.0 * this.getElem(band, px + 2, py + 1);
            cf[13] = -x * (x - 1.0) * (x + 1.0) * y * (y - 1.0) * (y - 2.0) / 36.0 * this.getElem(band, px - 1, py + 2);
            cf[14] = -x * (x - 1.0) * (x - 2.0) * y * (y - 1.0) * (y + 1.0) / 36.0 * this.getElem(band, px + 2, py - 1);
            cf[15] = x * (x - 1.0) * (x + 1.0) * y * (y - 1.0) * (y + 1.0) / 36.0 * this.getElem(band, px + 2, py + 2);
            double h = 0.0;
            for (double v : cf) {
                h += v;
            }
            return h;
        }
    }

    public static enum WeatherParam {
        TEMP("TMP", "temp"),
        PRESSURE("PRMSL", "press"),
        WIND("GUST", "wind"),
        PRECIP("PRATE", "precip"),
        CLOUD("TCDC", "cloud");

        public final String code;
        final String field;

        private WeatherParam(String code, String field) {
            this.code = code;
            this.field = field;
        }
    }
}

