/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.core.jni;

import net.osmand.core.jni.MapObject;
import net.osmand.core.jni.ObfMapObject;
import net.osmand.core.jni.ObfMapSectionDataBlockId;
import net.osmand.core.jni.OsmAndCoreJNI;
import net.osmand.core.jni.SWIGTYPE_p_std__shared_ptrT_OsmAnd__ObfMapSectionInfo_const_t;
import net.osmand.core.jni.SWIGTYPE_p_std__shared_ptrT_OsmAnd__ObfMapSectionLevel_const_t;
import net.osmand.core.jni.SWIGTYPE_p_unsigned_long_long;
import net.osmand.core.jni.ZoomLevel;

public class BinaryMapObject
extends ObfMapObject {
    private transient long swigCPtr;
    private transient boolean swigCMemOwnDerived;

    protected BinaryMapObject(long l, boolean bl) {
        super(OsmAndCoreJNI.BinaryMapObject_SWIGSmartPtrUpcast(l), true);
        this.swigCMemOwnDerived = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(BinaryMapObject binaryMapObject) {
        return binaryMapObject == null ? 0L : binaryMapObject.swigCPtr;
    }

    @Override
    protected void swigSetCMemOwn(boolean bl) {
        this.swigCMemOwnDerived = bl;
        super.swigSetCMemOwn(bl);
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwnDerived) {
                this.swigCMemOwnDerived = false;
                OsmAndCoreJNI.delete_BinaryMapObject(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public SWIGTYPE_p_std__shared_ptrT_OsmAnd__ObfMapSectionInfo_const_t getSection() {
        long l = OsmAndCoreJNI.BinaryMapObject_section_get(this.swigCPtr, this);
        return l == 0L ? null : new SWIGTYPE_p_std__shared_ptrT_OsmAnd__ObfMapSectionInfo_const_t(l, false);
    }

    public SWIGTYPE_p_std__shared_ptrT_OsmAnd__ObfMapSectionLevel_const_t getLevel() {
        long l = OsmAndCoreJNI.BinaryMapObject_level_get(this.swigCPtr, this);
        return l == 0L ? null : new SWIGTYPE_p_std__shared_ptrT_OsmAnd__ObfMapSectionLevel_const_t(l, false);
    }

    public void setBlockId(ObfMapSectionDataBlockId obfMapSectionDataBlockId) {
        OsmAndCoreJNI.BinaryMapObject_blockId_set(this.swigCPtr, this, ObfMapSectionDataBlockId.getCPtr(obfMapSectionDataBlockId), obfMapSectionDataBlockId);
    }

    public ObfMapSectionDataBlockId getBlockId() {
        long l = OsmAndCoreJNI.BinaryMapObject_blockId_get(this.swigCPtr, this);
        return l == 0L ? null : new ObfMapSectionDataBlockId(l, false);
    }

    @Override
    public String toString() {
        return OsmAndCoreJNI.BinaryMapObject_toString(this.swigCPtr, this);
    }

    @Override
    public boolean obtainSharingKey(SWIGTYPE_p_unsigned_long_long sWIGTYPE_p_unsigned_long_long) {
        return OsmAndCoreJNI.BinaryMapObject_obtainSharingKey(this.swigCPtr, this, SWIGTYPE_p_unsigned_long_long.getCPtr(sWIGTYPE_p_unsigned_long_long));
    }

    @Override
    public boolean obtainSortingKey(SWIGTYPE_p_unsigned_long_long sWIGTYPE_p_unsigned_long_long) {
        return OsmAndCoreJNI.BinaryMapObject_obtainSortingKey(this.swigCPtr, this, SWIGTYPE_p_unsigned_long_long.getCPtr(sWIGTYPE_p_unsigned_long_long));
    }

    @Override
    public ZoomLevel getMinZoomLevel() {
        return ZoomLevel.swigToEnum(OsmAndCoreJNI.BinaryMapObject_getMinZoomLevel(this.swigCPtr, this));
    }

    @Override
    public ZoomLevel getMaxZoomLevel() {
        return ZoomLevel.swigToEnum(OsmAndCoreJNI.BinaryMapObject_getMaxZoomLevel(this.swigCPtr, this));
    }

    @Override
    public MapObject.LayerType getLayerType() {
        return MapObject.LayerType.swigToEnum(OsmAndCoreJNI.BinaryMapObject_getLayerType(this.swigCPtr, this));
    }

    @Override
    public String debugInfo(int n, boolean bl) {
        return OsmAndCoreJNI.BinaryMapObject_debugInfo(this.swigCPtr, this, n, bl);
    }
}

