/*
 * Decompiled with CFR 0.152.
 */
package rtree;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.List;
import rtree.ABL;
import rtree.Element;
import rtree.LeafElement;
import rtree.Point;
import rtree.RTreeException;
import rtree.Rect;

public class RTreeClient {
    private Socket socket;

    public RTreeClient(String host, int port) {
        try {
            this.socket = new Socket(host, port);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void insert(Element element) throws RTreeException {
        String command = "insert";
        Object[] obj = new Object[]{element};
        this.sendRequest(command, obj);
    }

    public void delete(LeafElement element) throws RTreeException {
        String command = "delete";
        Object[] obj = new Object[]{element};
        this.sendRequest(command, obj);
    }

    public List overlaps(Rect rect) throws RTreeException {
        String command = "overlaps";
        Object[] obj = new Object[]{rect};
        Object[] response = this.sendRequest(command, obj);
        return (List)response[0];
    }

    public List nonDisjoint(Rect rect) throws RTreeException {
        String command = "nondisjoint";
        Object[] obj = new Object[]{rect};
        Object[] response = this.sendRequest(command, obj);
        return (List)response[0];
    }

    public List containedBy(Rect rect) throws RTreeException {
        String command = "containedby";
        Object[] obj = new Object[]{rect};
        Object[] response = this.sendRequest(command, obj);
        return (List)response[0];
    }

    public List equal(Rect rect) throws RTreeException {
        String command = "equal";
        Object[] obj = new Object[]{rect};
        Object[] response = this.sendRequest(command, obj);
        return (List)response[0];
    }

    public List meet(Rect rect) throws RTreeException {
        String command = "meet";
        Object[] obj = new Object[]{rect};
        Object[] response = this.sendRequest(command, obj);
        return (List)response[0];
    }

    public List contains(Rect rect) throws RTreeException {
        String command = "contains";
        Object[] obj = new Object[]{rect};
        Object[] response = this.sendRequest(command, obj);
        return (List)response[0];
    }

    public List getAllElements() throws RTreeException {
        String command = "getallelements";
        Object[] response = this.sendRequest(command, null);
        return (List)response[0];
    }

    public Rect getTreeMBR() throws RTreeException {
        String command = "gettreembr";
        Object[] response = this.sendRequest(command, null);
        return (Rect)response[0];
    }

    public ABL[] nearestSearch(Point pt, long ln, int in) throws RTreeException {
        String command = "nearest";
        Object[] obj = new Object[]{pt, new Long(ln), new Integer(in)};
        Object[] response = this.sendRequest(command, obj);
        if (response != null) {
            ABL[] abl = new ABL[response.length];
            for (int i = 0; i < response.length; ++i) {
                abl[i] = (ABL)response[i];
            }
            return abl;
        }
        return null;
    }

    public List nearestSearch(Point pt, long ln) throws RTreeException {
        String command = "nearestsearch";
        Object[] obj = new Object[]{pt, new Long(ln)};
        Object[] response = this.sendRequest(command, obj);
        return (List)response[0];
    }

    private Object[] sendRequest(String command, Object[] param) throws RTreeException {
        try {
            int val;
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bout);
            OutputStream fout = this.socket.getOutputStream();
            out.writeObject(command);
            if (param != null) {
                out.writeObject(new Integer(param.length));
                for (int i = 0; i < param.length; ++i) {
                    out.writeObject(param[i]);
                }
            } else {
                out.writeObject(new Integer(0));
            }
            out.close();
            fout.write(bout.toByteArray());
            fout.flush();
            InputStream in = this.socket.getInputStream();
            byte[] bbf = new byte[100];
            int i = 0;
            int total = -1;
            while ((val = in.read(bbf, i, 1)) != -1) {
                if (++i == 10) {
                    byte[] ln = new byte[10];
                    System.arraycopy(bbf, 0, ln, 0, 10);
                    ByteArrayInputStream lin = new ByteArrayInputStream(ln);
                    ObjectInputStream loin = new ObjectInputStream(lin);
                    total = loin.readInt();
                    byte[] temp = new byte[total];
                    System.arraycopy(bbf, 0, temp, 0, bbf.length);
                    bbf = temp;
                }
                if (i < total || total == -1) continue;
                break;
            }
            byte[] tby = new byte[bbf.length - 10];
            System.arraycopy(bbf, 10, tby, 0, tby.length);
            ByteArrayInputStream bin = new ByteArrayInputStream(tby);
            ObjectInputStream oIn = new ObjectInputStream(bin);
            Boolean bool = (Boolean)oIn.readObject();
            Integer count = (Integer)oIn.readObject();
            if (bool.booleanValue()) {
                Object[] obj = new Object[count.intValue()];
                for (int j = 0; j < count; ++j) {
                    obj[j] = oIn.readObject();
                }
                return obj;
            }
            throw (Exception)oIn.readObject();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RTreeException(e.getMessage());
        }
    }
}

